/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.runtime;

import java.lang.reflect.InvocationTargetException;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.UtilMessage;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

public class RuntimeAnnotatedMembers {
    public static <T> T newInstance(AnnotatedConstructor<T> constructor, Object ... parameters) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return SecureReflections.ensureAccessible(constructor.getJavaMember()).newInstance(parameters);
    }

    public static void setFieldValue(AnnotatedField<?> field, Object instance, Object value) throws IllegalArgumentException, IllegalAccessException {
        SecureReflections.ensureAccessible(field.getJavaMember()).set(instance, value);
    }

    public static void setFieldValueOnInstance(AnnotatedField<?> field, Object instance, Object value) throws IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        SecureReflections.getField(instance.getClass(), field.getJavaMember().getName()).set(instance, value);
    }

    public static <T, X> T getFieldValue(AnnotatedField<X> field, Object instance) {
        try {
            return Reflections.cast(SecureReflections.ensureAccessible(field.getJavaMember()).get(instance));
        }
        catch (Exception e) {
            throw new WeldException(UtilMessage.ACCESS_ERROR_ON_FIELD, (Throwable)e, field.getJavaMember().getName(), field.getJavaMember().getDeclaringClass());
        }
    }

    public static <T, X> T invokeMethod(AnnotatedMethod<X> method, Object instance, Object ... parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return SecureReflections.invoke(instance, method.getJavaMember(), parameters);
    }
}

