/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import org.jboss.weld.bootstrap.events.AnnotationDiscovery;
import org.jboss.weld.resources.ReflectionCache;

public class SimpleAnnotationDiscovery
implements AnnotationDiscovery {
    private final ReflectionCache cache;

    public SimpleAnnotationDiscovery(ReflectionCache cache) {
        this.cache = cache;
    }

    @Override
    public boolean containsAnnotations(Class<?> javaClass, Collection<Class<? extends Annotation>> requiredAnnotations) {
        for (Class<?> clazz = javaClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (this.containsAnnotations(this.cache.getAnnotations(clazz), requiredAnnotations)) {
                return true;
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (!this.containsAnnotations(this.cache.getAnnotations(field), requiredAnnotations)) continue;
                return true;
            }
            for (AccessibleObject accessibleObject : clazz.getConstructors()) {
                if (this.containsAnnotations(this.cache.getAnnotations(accessibleObject), requiredAnnotations)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Constructor)accessibleObject).getParameterAnnotations()) {
                    if (!this.containsAnnotations(parameterAnnotations, requiredAnnotations)) continue;
                    return true;
                }
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (this.containsAnnotations(this.cache.getAnnotations(accessibleObject), requiredAnnotations)) {
                    return true;
                }
                for (Annotation[] parameterAnnotations : ((Method)accessibleObject).getParameterAnnotations()) {
                    if (!this.containsAnnotations(parameterAnnotations, requiredAnnotations)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean containsAnnotations(Annotation[] annotations, Collection<Class<? extends Annotation>> requiredAnnotations) {
        return this.containsAnnotations(annotations, requiredAnnotations, true);
    }

    private boolean containsAnnotations(Annotation[] annotations, Collection<Class<? extends Annotation>> requiredAnnotations, boolean checkMetaAnnotations) {
        for (Class<? extends Annotation> requiredAnnotation : requiredAnnotations) {
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (requiredAnnotation.equals(annotationType)) {
                    return true;
                }
                if (!checkMetaAnnotations || !this.containsAnnotations(this.cache.getAnnotations(annotationType), requiredAnnotations, false)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void cleanup() {
    }
}

