/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.TransientReference;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.annotated.enhanced.ConstructorSignature;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.runtime.RuntimeAnnotatedMembers;
import org.jboss.weld.injection.AbstractCallableInjectionPoint;
import org.jboss.weld.injection.AroundConstructCallback;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;

public class ConstructorInjectionPoint<T>
extends AbstractCallableInjectionPoint<T, T, Constructor<T>> {
    private final AnnotatedConstructor<T> constructor;
    private final ConstructorSignature signature;

    protected ConstructorInjectionPoint(EnhancedAnnotatedConstructor<T> constructor, Bean<T> declaringBean, Class<?> declaringComponentClass, InjectionPointFactory factory, BeanManagerImpl manager) {
        super(constructor, declaringBean, declaringComponentClass, false, factory, manager);
        this.constructor = constructor.slim();
        this.signature = constructor.getSignature();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T newInstance(BeanManagerImpl manager, CreationalContext<?> ctx, AroundConstructCallback<T> callback) {
        CreationalContext invocationContext = manager.createCreationalContext((Contextual)null);
        try {
            Object[] parameterValues = this.getParameterValues(manager, ctx, invocationContext);
            if (callback == null) {
                T t = this.newInstance(parameterValues);
                return t;
            }
            T t = callback.aroundConstruct(parameterValues, new AroundConstructCallback.ConstructionHandle<T>(){

                @Override
                public T construct(Object[] parameters) {
                    return ConstructorInjectionPoint.this.newInstance(parameters);
                }
            });
            return t;
        }
        finally {
            invocationContext.release();
        }
    }

    protected T newInstance(Object[] parameterValues) {
        try {
            return RuntimeAnnotatedMembers.newInstance(this.getAnnotated(), parameterValues);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (InstantiationException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e);
        }
        return null;
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object[] getParameterValues(BeanManagerImpl manager, CreationalContext<?> ctx, CreationalContext<?> invocationContext) {
        Object[] parameterValues = new Object[this.getParameterInjectionPoints().size()];
        Iterator iterator = this.getParameterInjectionPoints().iterator();
        for (int i = 0; i < parameterValues.length; ++i) {
            ParameterInjectionPoint param = iterator.next();
            parameterValues[i] = param.getAnnotated().isAnnotationPresent(TransientReference.class) ? param.getValueToInject(manager, invocationContext) : param.getValueToInject(manager, ctx);
        }
        return parameterValues;
    }

    @Override
    public AnnotatedConstructor<T> getAnnotated() {
        return this.constructor;
    }

    public ConstructorSignature getSignature() {
        return this.signature;
    }
}

