/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.util.EmptyStackException;
import java.util.Stack;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.bootstrap.api.Service;

public class InjectionPointStack
implements Service {
    private final ThreadLocal<Stack<InjectionPoint>> injectionPointStack = new ThreadLocal();

    public void push(InjectionPoint injectionPoint) {
        Stack<InjectionPoint> stack = this.injectionPointStack.get();
        if (stack == null) {
            stack = new Stack();
            this.injectionPointStack.set(stack);
        }
        stack.push(injectionPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InjectionPoint pop() {
        Stack<InjectionPoint> stack = this.injectionPointStack.get();
        if (stack == null) {
            throw new EmptyStackException();
        }
        try {
            InjectionPoint injectionPoint = stack.pop();
            return injectionPoint;
        }
        finally {
            if (stack.isEmpty()) {
                this.injectionPointStack.remove();
            }
        }
    }

    public InjectionPoint peek() {
        Stack<InjectionPoint> stack = this.injectionPointStack.get();
        if (stack == null) {
            return null;
        }
        if (!stack.empty()) {
            return stack.peek();
        }
        return null;
    }

    @Override
    public void cleanup() {
    }
}

