/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.util.List;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.runtime.RuntimeAnnotatedMembers;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.injection.producer.LifecycleCallbackInvoker;
import org.jboss.weld.interceptor.util.InterceptionUtils;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.util.BeanMethods;

public class DefaultLifecycleCallbackInvoker<T>
implements LifecycleCallbackInvoker<T> {
    private final List<AnnotatedMethod<? super T>> postConstructMethods;
    private final List<AnnotatedMethod<? super T>> preDestroyMethods;

    public DefaultLifecycleCallbackInvoker(EnhancedAnnotatedType<T> type) {
        this.postConstructMethods = BeanMethods.getPostConstructMethods(type);
        this.preDestroyMethods = BeanMethods.getPreDestroyMethods(type);
    }

    @Override
    public void postConstruct(T instance, Instantiator<T> instantiator) {
        if (instantiator.hasInterceptorSupport()) {
            InterceptionUtils.executePostConstruct(instance);
        } else {
            this.invokeMethods(this.postConstructMethods, instance);
        }
    }

    @Override
    public void preDestroy(T instance, Instantiator<T> instantiator) {
        if (instantiator.hasInterceptorSupport()) {
            InterceptionUtils.executePredestroy(instance);
        } else {
            this.invokeMethods(this.preDestroyMethods, instance);
        }
    }

    protected void invokeMethods(List<AnnotatedMethod<? super T>> methods, T instance) {
        for (AnnotatedMethod<T> annotatedMethod : methods) {
            try {
                RuntimeAnnotatedMembers.invokeMethod(annotatedMethod, instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, annotatedMethod, instance);
            }
        }
    }

    @Override
    public List<AnnotatedMethod<? super T>> getPostConstructMethods() {
        return this.postConstructMethods;
    }

    @Override
    public List<AnnotatedMethod<? super T>> getPreDestroyMethods() {
        return this.preDestroyMethods;
    }
}

