/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.enterprise.context.spi.CreationalContext;
import javax.interceptor.InvocationContext;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.AroundConstructCallback;
import org.jboss.weld.injection.producer.Instantiator;
import org.jboss.weld.interceptor.proxy.DefaultInvocationContextFactory;
import org.jboss.weld.interceptor.proxy.InterceptionContext;
import org.jboss.weld.interceptor.proxy.InterceptorInvocation;
import org.jboss.weld.interceptor.proxy.InterceptorInvocationContext;
import org.jboss.weld.interceptor.proxy.InterceptorMethodHandler;
import org.jboss.weld.interceptor.proxy.SimpleInterceptionChain;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionTypeRegistry;
import org.jboss.weld.manager.BeanManagerImpl;

public class InterceptorApplyingInstantiator<T>
implements Instantiator<T> {
    private final TargetClassInterceptorMetadata<T> targetClassInterceptorMetadata;
    private final InterceptionModel<ClassMetadata<?>, ?> interceptionModel;
    private final Instantiator<T> delegate;
    private final Constructor<T> constructor;

    public InterceptorApplyingInstantiator(EnhancedAnnotatedType<T> type, Instantiator<T> delegate, BeanManagerImpl manager, Constructor<T> constructor) {
        this.targetClassInterceptorMetadata = manager.getInterceptorMetadataReader().getTargetClassInterceptorMetadata(manager.getInterceptorMetadataReader().getClassMetadata(type.getJavaClass()));
        this.interceptionModel = (InterceptionModel)manager.getInterceptorModelRegistry().get(type.getJavaClass());
        this.delegate = delegate;
        this.constructor = constructor;
    }

    @Override
    public T newInstance(CreationalContext<T> ctx, BeanManagerImpl manager, AroundConstructCallback<T> ignored) {
        InterceptionContext interceptionContext = new InterceptionContext(this.targetClassInterceptorMetadata, this.interceptionModel, ctx, manager);
        T instance = this.invokeConstructor(interceptionContext, ctx, manager);
        this.applyInterceptors(instance, interceptionContext);
        return instance;
    }

    protected T invokeConstructor(InterceptionContext interceptionContext, CreationalContext<T> ctx, BeanManagerImpl manager) {
        List<InterceptorMetadata<?>> interceptors;
        AroundConstructCallback callback = null;
        if (InterceptionTypeRegistry.isSupported(InterceptionType.AROUND_CONSTRUCT) && !(interceptors = this.interceptionModel.getConstructorInvocationInterceptors()).isEmpty()) {
            final ArrayList<InterceptorInvocation> interceptorInvocations = new ArrayList<InterceptorInvocation>(interceptors.size());
            for (InterceptorMetadata<?> interceptorMetadata : interceptors) {
                interceptorInvocations.add(interceptorMetadata.getInterceptorInvocation(interceptionContext.getInterceptorInstance(interceptorMetadata), InterceptionType.AROUND_CONSTRUCT));
            }
            callback = new AroundConstructCallback<T>(){

                @Override
                public T aroundConstruct(Object[] parameters, final AroundConstructCallback.ConstructionHandle<T> constructionHandle) {
                    final AtomicReference target = new AtomicReference();
                    SimpleInterceptionChain chain = new SimpleInterceptionChain(interceptorInvocations){

                        @Override
                        protected Object interceptorChainCompleted(InvocationContext invocationCtx) throws Exception {
                            target.set(constructionHandle.construct(invocationCtx.getParameters()));
                            return null;
                        }
                    };
                    InterceptorInvocationContext invocationCtx = new InterceptorInvocationContext(chain, InterceptorApplyingInstantiator.this.constructor, parameters){

                        @Override
                        public Object getTarget() {
                            return target.get();
                        }
                    };
                    try {
                        chain.invokeNextInterceptor(invocationCtx);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new WeldException(e);
                    }
                    return target.get();
                }
            };
        }
        return this.delegate.newInstance(ctx, manager, callback);
    }

    protected T applyInterceptors(T instance, InterceptionContext interceptionContext) {
        try {
            InterceptorMethodHandler methodHandler = new InterceptorMethodHandler(interceptionContext, new DefaultInvocationContextFactory());
            CombinedInterceptorAndDecoratorStackMethodHandler wrapperMethodHandler = (CombinedInterceptorAndDecoratorStackMethodHandler)((ProxyObject)instance).getHandler();
            wrapperMethodHandler.setInterceptorMethodHandler(methodHandler);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        return instance;
    }

    public String toString() {
        return "InterceptorApplyingInstantiator for " + this.delegate;
    }

    @Override
    public boolean hasInterceptorSupport() {
        return true;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return this.delegate.hasDecoratorSupport();
    }
}

