/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.proxy;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.reader.cache.MetadataCachingReader;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Reflections;

public class InterceptionContext
implements Serializable {
    private static final long serialVersionUID = 7500722360133273633L;
    private final transient TargetClassInterceptorMetadata<?> targetClassInterceptorMetadata;
    private final transient InterceptionModel<ClassMetadata<?>, ?> interceptionModel;
    private final Map<Class<?>, Object> interceptorInstances;
    private final BeanManagerImpl manager;
    private final Class<?> targetClass;

    public InterceptionContext(TargetClassInterceptorMetadata<?> targetClassInterceptorMetadata, InterceptionModel<ClassMetadata<?>, ?> interceptionModel, CreationalContext<?> ctx, BeanManagerImpl manager) {
        this(InterceptionContext.initInterceptorInstanceMap(interceptionModel.getAllInterceptors(), ctx, manager), manager, targetClassInterceptorMetadata, interceptionModel, targetClassInterceptorMetadata.getInterceptorClass().getJavaClass());
    }

    private InterceptionContext(Map<Class<?>, Object> interceptorInstances, BeanManagerImpl manager, TargetClassInterceptorMetadata<?> targetClassInterceptorMetadata, InterceptionModel<ClassMetadata<?>, ?> interceptionModel, Class<?> targetClass) {
        this.interceptorInstances = interceptorInstances;
        this.manager = manager;
        this.targetClassInterceptorMetadata = targetClassInterceptorMetadata;
        this.interceptionModel = interceptionModel;
        this.targetClass = targetClass;
    }

    private static Map<Class<?>, Object> initInterceptorInstanceMap(Iterable<? extends InterceptorMetadata<?>> interceptorMetadata, CreationalContext ctx, BeanManagerImpl manager) {
        HashMap interceptorInstances = new HashMap();
        for (InterceptorMetadata<?> interceptor : interceptorMetadata) {
            interceptorInstances.put(interceptor.getInterceptorClass().getJavaClass(), interceptor.getInterceptorFactory().create(ctx, manager));
        }
        return WeldCollections.immutableMap(interceptorInstances);
    }

    public TargetClassInterceptorMetadata<?> getTargetClassInterceptorMetadata() {
        return this.targetClassInterceptorMetadata;
    }

    public InterceptionModel<ClassMetadata<?>, ?> getInterceptionModel() {
        return this.interceptionModel;
    }

    public <T> T getInterceptorInstance(InterceptorMetadata<T> interceptorMetadata) {
        return Reflections.cast(this.interceptorInstances.get(interceptorMetadata.getInterceptorClass().getJavaClass()));
    }

    private Object readResolve() throws ObjectStreamException {
        InterceptionModel interceptionModel = (InterceptionModel)this.manager.getInterceptorModelRegistry().get(this.targetClass);
        MetadataCachingReader reader = this.manager.getInterceptorMetadataReader();
        TargetClassInterceptorMetadata<?> targetClassInterceptorMetadata = reader.getTargetClassInterceptorMetadata(reader.getClassMetadata(this.targetClass));
        return new InterceptionContext(this.interceptorInstances, this.manager, targetClassInterceptorMetadata, interceptionModel, this.targetClass);
    }
}

