/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.Context;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.Container;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bean.builtin.ee.ServletContextBean;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpRequestContextImpl;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ConversationMessage;
import org.jboss.weld.logging.messages.JsfMessage;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.servlet.api.helpers.AbstractServletListener;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

public class WeldListener
extends AbstractServletListener {
    private static final String NO_CID = "nocid";
    private static final String CONVERSATION_PROPAGATION = "conversationPropagation";
    private static final String CONVERSATION_PROPAGATION_NONE = "none";
    private static final String CONTEXT_ACTIVATED_IN_REQUEST = WeldListener.class.getName() + "CONTEXT_ACTIVATED_IN_REQUEST";
    private static final String HTTP_SESSION_EVENT = "org.jboss.weld." + HttpSessionEvent.class.getName();
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.SERVLET);
    private transient HttpSessionContext sessionContextCache;
    private transient HttpRequestContext requestContextCache;
    private transient HttpConversationContext conversationContextCache;
    @Inject
    private BeanManagerImpl beanManager;

    private HttpSessionContext sessionContext() {
        if (this.sessionContextCache == null) {
            this.sessionContextCache = (HttpSessionContext)Container.instance().deploymentManager().instance().select(HttpSessionContext.class, new Annotation[0]).get();
        }
        return this.sessionContextCache;
    }

    private HttpRequestContext requestContext() {
        if (this.requestContextCache == null) {
            this.requestContextCache = (HttpRequestContext)Container.instance().deploymentManager().instance().select(HttpRequestContext.class, new Annotation[0]).get();
        }
        return this.requestContextCache;
    }

    private HttpConversationContext conversationContext() {
        if (this.conversationContextCache == null) {
            this.conversationContextCache = (HttpConversationContext)Container.instance().deploymentManager().instance().select(HttpConversationContext.class, new Annotation[0]).get();
        }
        return this.conversationContextCache;
    }

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        if (this.beanManager == null) {
            this.beanManager = BeanManagerProxy.unwrap(CDI.current().getBeanManager());
        }
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)sce, InitializedLiteral.APPLICATION);
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)sce, DestroyedLiteral.APPLICATION);
    }

    @Override
    public void sessionCreated(HttpSessionEvent event) {
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)event, InitializedLiteral.SESSION);
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        if (Container.available()) {
            boolean destroyed = this.sessionContext().destroy(event.getSession());
            RequestScopedBeanCache.endRequest();
            if (destroyed) {
                this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)event, DestroyedLiteral.SESSION);
            } else if (this.requestContext() instanceof HttpRequestContextImpl) {
                HttpServletRequest request = ((HttpRequestContextImpl)Reflections.cast(this.requestContext())).getHttpServletRequest();
                request.setAttribute(HTTP_SESSION_EVENT, (Object)event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void requestDestroyed(ServletRequestEvent event) {
        log.trace(ServletMessage.REQUEST_DESTROYED, event.getServletRequest());
        if (!Container.available()) return;
        if (!(event.getServletRequest() instanceof HttpServletRequest)) throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        try {
            this.deactivateConversations(event);
            this.requestContext().invalidate();
            this.requestContext().deactivate();
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)event, DestroyedLiteral.REQUEST);
            this.sessionContext().deactivate();
            if (this.sessionContext().isValid()) return;
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent(request.getAttribute(HTTP_SESSION_EVENT), DestroyedLiteral.SESSION);
            return;
        }
        finally {
            this.requestContext().dissociate(request);
            this.sessionContext().dissociate(request);
            this.conversationContext().dissociate(request);
            ServletContextBean.cleanup();
        }
    }

    private void deactivateConversations(ServletRequestEvent event) {
        ConversationContext conversationContext = (ConversationContext)WeldListener.instance().select(HttpConversationContext.class, new Annotation[0]).get();
        boolean isTransient = conversationContext.getCurrentConversation().isTransient();
        if (log.isTraceEnabled()) {
            if (isTransient) {
                log.trace(ConversationMessage.CLEANING_UP_TRANSIENT_CONVERSATION, new Object[0]);
            } else {
                log.trace(JsfMessage.CLEANING_UP_CONVERSATION, conversationContext.getCurrentConversation().getId());
            }
        }
        conversationContext.invalidate();
        if (conversationContext.isActive()) {
            conversationContext.deactivate();
        }
        if (isTransient) {
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)event, DestroyedLiteral.CONVERSATION);
        }
    }

    @Override
    public void requestInitialized(ServletRequestEvent event) {
        log.trace(ServletMessage.REQUEST_INITIALIZED, event.getServletRequest());
        if (Container.available()) {
            if (event.getServletRequest() instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
                ServletContextBean.setServletContext(event.getServletContext());
                this.requestContext().associate(request);
                this.sessionContext().associate(request);
                this.conversationContext().associate(request);
                this.requestContext().activate();
                this.sessionContext().activate();
                try {
                    this.activateConversations(event);
                    this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)event, InitializedLiteral.REQUEST);
                }
                catch (RuntimeException e) {
                    this.requestDestroyed(event);
                    throw e;
                }
            } else {
                throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
            }
        }
    }

    private void activateConversations(ServletRequestEvent event) {
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        HttpConversationContext conversationContext = (HttpConversationContext)WeldListener.instance().select(HttpConversationContext.class, new Annotation[0]).get();
        String cid = WeldListener.getConversationId(request, conversationContext);
        log.debug(JsfMessage.RESUMING_CONVERSATION, cid);
        if (!this.isContextActivatedInRequest(request)) {
            this.setContextActivatedInRequest(request);
            conversationContext.activate(cid);
            if (cid == null) {
                this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)event, InitializedLiteral.CONVERSATION);
            }
        } else {
            conversationContext.dissociate(request);
            conversationContext.associate(request);
            conversationContext.activate(cid);
        }
    }

    private void setContextActivatedInRequest(HttpServletRequest request) {
        request.setAttribute(CONTEXT_ACTIVATED_IN_REQUEST, (Object)true);
    }

    private boolean isContextActivatedInRequest(HttpServletRequest request) {
        Object result = request.getAttribute(CONTEXT_ACTIVATED_IN_REQUEST);
        if (result == null) {
            return false;
        }
        return (Boolean)result;
    }

    private static Instance<Context> instance() {
        return Container.instance().deploymentManager().instance().select(Context.class, new Annotation[0]);
    }

    public static String getConversationId(HttpServletRequest request, ConversationContext conversationContext) {
        if (request.getParameter(NO_CID) != null) {
            return null;
        }
        if (CONVERSATION_PROPAGATION_NONE.equals(request.getParameter(CONVERSATION_PROPAGATION))) {
            return null;
        }
        String cidName = conversationContext.getParameterName();
        String cid = request.getParameter(cidName);
        log.trace(JsfMessage.FOUND_CONVERSATION_FROM_REQUEST, cid);
        return cid;
    }
}

