/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.util.reflection.SecureReflectionAccess;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;

public class SecureReflections {
    public static Field getField(final Class<?> clazz, final String fieldName) throws NoSuchFieldException {
        return (Field)new SecureReflectionAccess<Field>(){

            @Override
            protected Field work() throws Exception {
                return clazz.getField(fieldName);
            }
        }.runAsFieldAccess();
    }

    public static Field getDeclaredField(final Class<?> clazz, final String fieldName) throws NoSuchFieldException {
        return (Field)new SecureReflectionAccess<Field>(){

            @Override
            protected Field work() throws Exception {
                return clazz.getDeclaredField(fieldName);
            }
        }.runAsFieldAccess();
    }

    public static Field[] getFields(final Class<?> clazz) {
        return (Field[])new SecureReflectionAccess<Field[]>(){

            @Override
            protected Field[] work() throws Exception {
                return clazz.getFields();
            }
        }.runAndWrap();
    }

    public static Field[] getDeclaredFields(final Class<?> clazz) {
        return (Field[])new SecureReflectionAccess<Field[]>(){

            @Override
            protected Field[] work() throws Exception {
                return clazz.getDeclaredFields();
            }
        }.runAndWrap();
    }

    public static Method getMethod(final Class<?> clazz, final String methodName, final Class<?> ... parameterTypes) throws NoSuchMethodException {
        return (Method)new SecureReflectionAccess<Method>(){

            @Override
            protected Method work() throws Exception {
                return clazz.getMethod(methodName, parameterTypes);
            }
        }.runAsMethodAccess();
    }

    public static Method getDeclaredMethod(final Class<?> clazz, final String methodName, final Class<?> ... parameterTypes) throws NoSuchMethodException {
        return (Method)new SecureReflectionAccess<Method>(){

            @Override
            protected Method work() throws Exception {
                return clazz.getDeclaredMethod(methodName, parameterTypes);
            }
        }.runAsMethodAccess();
    }

    public static Method[] getMethods(final Class<?> clazz) {
        return (Method[])new SecureReflectionAccess<Method[]>(){

            @Override
            protected Method[] work() throws Exception {
                return clazz.getMethods();
            }
        }.runAndWrap();
    }

    public static Method[] getDeclaredMethods(final Class<?> clazz) {
        return (Method[])new SecureReflectionAccess<Method[]>(){

            @Override
            protected Method[] work() throws Exception {
                return clazz.getDeclaredMethods();
            }
        }.runAndWrap();
    }

    public static <T> Constructor<T> getConstructor(final Class<T> clazz, final Class<?> ... parameterTypes) throws NoSuchMethodException {
        return (Constructor)new SecureReflectionAccess<Constructor<T>>(){

            @Override
            protected Constructor<T> work() throws Exception {
                return clazz.getConstructor(parameterTypes);
            }
        }.runAsMethodAccess();
    }

    public static <T> Constructor<T> getDeclaredConstructor(final Class<T> clazz, final Class<?> ... parameterTypes) throws NoSuchMethodException {
        return (Constructor)new SecureReflectionAccess<Constructor<T>>(){

            @Override
            protected Constructor<T> work() throws Exception {
                return clazz.getDeclaredConstructor(parameterTypes);
            }
        }.runAsMethodAccess();
    }

    public static Constructor<?>[] getConstructors(final Class<?> clazz) {
        return (Constructor[])new SecureReflectionAccess<Constructor<?>[]>(){

            @Override
            protected Constructor<?>[] work() throws Exception {
                return clazz.getConstructors();
            }
        }.runAndWrap();
    }

    public static Constructor<?>[] getDeclaredConstructors(final Class<?> clazz) {
        return (Constructor[])new SecureReflectionAccess<Constructor<?>[]>(){

            @Override
            protected Constructor<?>[] work() throws Exception {
                return clazz.getDeclaredConstructors();
            }
        }.runAndWrap();
    }

    public static <T> T invoke(final Object instance, final Method method, final Object ... parameters) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return new SecureReflectionAccess<T>(){

            @Override
            protected T work() throws Exception {
                Object result = SecureReflections.ensureAccessible(method).invoke(instance, parameters);
                return result;
            }
        }.runAsInvocation();
    }

    public static <T> T invokeAndUnwrap(Object instance, Method method, Object ... parameters) throws Throwable {
        try {
            return SecureReflections.invoke(instance, method, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new WeldException(e);
        }
        catch (IllegalAccessException e) {
            throw new WeldException(e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public static <T extends AccessibleObject> T ensureAccessible(final T accessibleObject) {
        if (accessibleObject.isAccessible()) {
            return accessibleObject;
        }
        return (T)((AccessibleObject)new SecureReflectionAccess<T>(){

            @Override
            protected T work() throws Exception {
                accessibleObject.setAccessible(true);
                return accessibleObject;
            }
        }.runAndWrap());
    }

    public static <T> T newInstance(final Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return new SecureReflectionAccess<T>(){

            @Override
            protected T work() throws Exception {
                return clazz.newInstance();
            }
        }.runAsInstantiation();
    }

    public static <T> T newUnsafeInstance(final Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return new SecureReflectionAccess<T>(){

            @Override
            protected T work() throws Exception {
                ServiceRegistry services = Container.instance().services();
                InstantiatorFactory factory = services.get(InstantiatorFactory.class);
                return factory.getInstantiator().instantiate(clazz);
            }
        }.runAsInstantiation();
    }

    public static Method lookupMethod(Object instance, Method method) throws NoSuchMethodException {
        if (method.getDeclaringClass() == instance.getClass()) {
            return method;
        }
        return SecureReflections.lookupMethod(instance.getClass(), method.getName(), method.getParameterTypes());
    }

    public static Method lookupMethod(final Class<?> clazz, final String methodName, final Class<?> ... parameterTypes) throws NoSuchMethodException {
        return (Method)new SecureReflectionAccess<Method>(){

            private Method lookupMethod(Class<?> currentClass) throws NoSuchMethodException {
                for (Class<?> inspectedClass = currentClass; inspectedClass != null; inspectedClass = inspectedClass.getSuperclass()) {
                    for (Class<?> inspectedInterface : inspectedClass.getInterfaces()) {
                        try {
                            return this.lookupMethod(inspectedInterface);
                        }
                        catch (NoSuchMethodException e) {
                        }
                    }
                    try {
                        return SecureReflections.getDeclaredMethod(inspectedClass, methodName, parameterTypes);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        continue;
                    }
                }
                throw new NoSuchMethodException();
            }

            @Override
            protected Method work() throws Exception {
                return this.lookupMethod(clazz);
            }
        }.runAsMethodAccess();
    }

    public static boolean isMethodExists(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            SecureReflections.getMethod(clazz, methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }
}

