/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Inject;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bean.builtin.ee.ServletContextBean;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpRequestContextImpl;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.servlet.ConversationContextActivator;
import org.jboss.weld.servlet.ConversationFilter;
import org.jboss.weld.servlet.api.helpers.AbstractServletListener;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

public class WeldListener
extends AbstractServletListener {
    private static final String HTTP_SESSION_EVENT = "org.jboss.weld." + HttpSessionEvent.class.getName();
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.SERVLET);
    private HttpSessionContext sessionContextCache;
    private HttpRequestContext requestContextCache;
    private ConversationContextActivator conversationContextActivator;
    private volatile Boolean conversationFilterRegistered;
    @Inject
    private BeanManagerImpl beanManager;

    private HttpSessionContext sessionContext() {
        if (this.sessionContextCache == null) {
            this.sessionContextCache = (HttpSessionContext)this.beanManager.instance().select(HttpSessionContext.class, new Annotation[0]).get();
        }
        return this.sessionContextCache;
    }

    private HttpRequestContext requestContext() {
        if (this.requestContextCache == null) {
            this.requestContextCache = (HttpRequestContext)this.beanManager.instance().select(HttpRequestContext.class, new Annotation[0]).get();
        }
        return this.requestContextCache;
    }

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        if (this.beanManager == null) {
            this.beanManager = BeanManagerProxy.unwrap(CDI.current().getBeanManager());
        }
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)sce, InitializedLiteral.APPLICATION);
        this.conversationContextActivator = new ConversationContextActivator(this.beanManager, sce.getServletContext());
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)sce, DestroyedLiteral.APPLICATION);
    }

    @Override
    public void sessionCreated(HttpSessionEvent event) {
        this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)event, InitializedLiteral.SESSION);
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        boolean destroyed = this.sessionContext().destroy(event.getSession());
        RequestScopedBeanCache.endRequest();
        if (destroyed) {
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)event, DestroyedLiteral.SESSION);
        } else if (this.requestContext() instanceof HttpRequestContextImpl) {
            HttpServletRequest request = ((HttpRequestContextImpl)Reflections.cast(this.requestContext())).getHttpServletRequest();
            request.setAttribute(HTTP_SESSION_EVENT, (Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void requestDestroyed(ServletRequestEvent event) {
        log.trace(ServletMessage.REQUEST_DESTROYED, event.getServletRequest());
        if (!(event.getServletRequest() instanceof HttpServletRequest)) throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        try {
            this.conversationContextActivator.deactivateConversationContext(request);
            this.requestContext().invalidate();
            this.requestContext().deactivate();
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)event, DestroyedLiteral.REQUEST);
            this.sessionContext().deactivate();
            if (this.sessionContext().isValid()) return;
            this.beanManager.getAccessibleLenientObserverNotifier().fireEvent(request.getAttribute(HTTP_SESSION_EVENT), DestroyedLiteral.SESSION);
            return;
        }
        finally {
            this.requestContext().dissociate(request);
            this.sessionContext().dissociate(request);
            this.conversationContextActivator.disassociateConversationContext(request);
            ServletContextBean.cleanup();
        }
    }

    @Override
    public void requestInitialized(ServletRequestEvent event) {
        log.trace(ServletMessage.REQUEST_INITIALIZED, event.getServletRequest());
        if (this.conversationFilterRegistered == null) {
            Object value = event.getServletContext().getAttribute(ConversationFilter.CONVERSATION_FILTER_INITIALIZED);
            this.conversationFilterRegistered = value != null && value.equals(Boolean.TRUE);
        }
        if (event.getServletRequest() instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
            ServletContextBean.setServletContext(event.getServletContext());
            this.requestContext().associate(request);
            this.sessionContext().associate(request);
            if (!this.conversationFilterRegistered.booleanValue()) {
                this.conversationContextActivator.associateConversationContext(request);
            }
            this.requestContext().activate();
            this.sessionContext().activate();
            try {
                if (!this.conversationFilterRegistered.booleanValue()) {
                    this.conversationContextActivator.activateConversationContext(request);
                }
                this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Object)event, InitializedLiteral.REQUEST);
            }
            catch (RuntimeException e) {
                this.requestDestroyed(event);
                throw e;
            }
        } else {
            throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
        }
    }
}

