/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.injection.attributes.SpecialParameterInjectionPoint;
import org.jboss.weld.logging.messages.EventMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.HierarchyDiscovery;

public class ObserverMethodImpl<T, X>
implements ObserverMethod<T> {
    public static final String ID_PREFIX = ObserverMethodImpl.class.getPackage().getName();
    public static final String ID_SEPARATOR = "-";
    private final Set<Annotation> bindings;
    private final Type eventType;
    protected final BeanManagerImpl beanManager;
    private final Reception reception;
    protected final RIBean<X> declaringBean;
    protected final MethodInjectionPoint<T, ? super X> observerMethod;
    protected TransactionPhase transactionPhase;
    private final String id;
    private final Set<WeldInjectionPoint<?, ?>> injectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> newInjectionPoints;

    protected ObserverMethodImpl(EnhancedAnnotatedMethod<T, ? super X> observer, RIBean<X> declaringBean, BeanManagerImpl manager) {
        this.beanManager = manager;
        this.declaringBean = declaringBean;
        this.observerMethod = this.initMethodInjectionPoint(observer, declaringBean, manager);
        EnhancedAnnotatedParameter<?, X> eventParameter = observer.getEnhancedParameters(Observes.class).get(0);
        this.eventType = new HierarchyDiscovery(declaringBean.getBeanClass()).resolveType(eventParameter.getBaseType());
        this.id = ObserverMethodImpl.createId(observer, declaringBean);
        this.bindings = manager.getServices().get(SharedObjectCache.class).getSharedSet(observer.getEnhancedParameters(Observes.class).get(0).getMetaAnnotations(Qualifier.class));
        Observes observesAnnotation = observer.getEnhancedParameters(Observes.class).get(0).getAnnotation(Observes.class);
        this.reception = observesAnnotation.notifyObserver();
        this.transactionPhase = ObserverFactory.getTransactionalPhase(observer);
        HashSet injectionPoints = new HashSet();
        HashSet newInjectionPoints = new HashSet();
        for (ParameterInjectionPoint<?, New> parameterInjectionPoint : this.observerMethod.getParameterInjectionPoints()) {
            if (parameterInjectionPoint instanceof SpecialParameterInjectionPoint) continue;
            if (parameterInjectionPoint.getQualifier(New.class) != null) {
                newInjectionPoints.add(parameterInjectionPoint);
            }
            injectionPoints.add(parameterInjectionPoint);
        }
        this.injectionPoints = WeldCollections.immutableSet(injectionPoints);
        this.newInjectionPoints = WeldCollections.immutableSet(newInjectionPoints);
    }

    protected static String createId(EnhancedAnnotatedMethod<?, ?> observer, RIBean<?> declaringBean) {
        String typeId = null;
        if (declaringBean instanceof AbstractClassBean) {
            AbstractClassBean classBean = (AbstractClassBean)declaringBean;
            typeId = ((AnnotatedTypeIdentifier)classBean.getAnnotated().getIdentifier()).asString();
        } else {
            typeId = declaringBean.getBeanClass().getName();
        }
        return ID_PREFIX + ID_SEPARATOR + ObserverMethod.class.getSimpleName() + ID_SEPARATOR + typeId + "." + observer.getSignature();
    }

    protected MethodInjectionPoint<T, ? super X> initMethodInjectionPoint(EnhancedAnnotatedMethod<T, ? super X> observer, RIBean<X> declaringBean, BeanManagerImpl manager) {
        return InjectionPointFactory.instance().createMethodInjectionPoint(observer, declaringBean, declaringBean.getBeanClass(), true, manager);
    }

    public Set<WeldInjectionPoint<?, ?>> getInjectionPoints() {
        return Collections.unmodifiableSet(this.injectionPoints);
    }

    public Set<WeldInjectionPoint<?, ?>> getNewInjectionPoints() {
        return Collections.unmodifiableSet(this.newInjectionPoints);
    }

    private <Y> void checkObserverMethod(EnhancedAnnotatedMethod<T, Y> annotated) {
        List<EnhancedAnnotatedParameter<?, Y>> eventObjects = annotated.getEnhancedParameters(Observes.class);
        if (this.reception.equals((Object)Reception.IF_EXISTS) && this.declaringBean.getScope().equals(Dependent.class)) {
            throw new DefinitionException(EventMessage.INVALID_SCOPED_CONDITIONAL_OBSERVER, this);
        }
        if (eventObjects.size() > 1) {
            throw new DefinitionException(EventMessage.MULTIPLE_EVENT_PARAMETERS, this);
        }
        EnhancedAnnotatedParameter<?, Y> eventParameter = eventObjects.iterator().next();
        this.checkRequiredTypeAnnotations(eventParameter);
        List<EnhancedAnnotatedParameter<?, Y>> disposeParams = annotated.getEnhancedParameters(Disposes.class);
        if (disposeParams.size() > 0) {
            throw new DefinitionException(EventMessage.INVALID_DISPOSES_PARAMETER, this);
        }
        if (this.observerMethod.getAnnotated().isAnnotationPresent(Produces.class)) {
            throw new DefinitionException(EventMessage.INVALID_PRODUCER, this);
        }
        if (this.observerMethod.getAnnotated().isAnnotationPresent(Inject.class)) {
            throw new DefinitionException(EventMessage.INVALID_INITIALIZER, this);
        }
        boolean containerLifecycleObserverMethod = Observers.isContainerLifecycleObserverMethod(this);
        for (EnhancedAnnotatedParameter parameter : annotated.getEnhancedParameters()) {
            if (!containerLifecycleObserverMethod || parameter.isAnnotationPresent(Observes.class) || BeanManager.class.equals((Object)parameter.getBaseType())) continue;
            throw new DefinitionException(EventMessage.INVALID_INJECTION_POINT, this);
        }
    }

    protected void checkRequiredTypeAnnotations(EnhancedAnnotatedParameter<?, ?> eventParameter) {
        if (eventParameter.isAnnotationPresent(WithAnnotations.class)) {
            throw new DefinitionException(EventMessage.INVALID_WITH_ANNOTATIONS, this);
        }
    }

    @Override
    public Class<X> getBeanClass() {
        return this.declaringBean.getType();
    }

    public RIBean<X> getDeclaringBean() {
        return this.declaringBean;
    }

    @Override
    public Reception getReception() {
        return this.reception;
    }

    @Override
    public Set<Annotation> getObservedQualifiers() {
        return this.bindings;
    }

    @Override
    public Type getObservedType() {
        return this.eventType;
    }

    @Override
    public TransactionPhase getTransactionPhase() {
        return this.transactionPhase;
    }

    public MethodInjectionPoint<T, ? super X> getMethod() {
        return this.observerMethod;
    }

    public void initialize(EnhancedAnnotatedMethod<T, ? super X> annotated) {
        this.checkObserverMethod(annotated);
    }

    @Override
    public void notify(T event) {
        this.sendEvent(event);
    }

    protected void sendEvent(T event) {
        if (this.observerMethod.getAnnotated().isStatic()) {
            this.sendEvent(event, null, this.beanManager.createCreationalContext((Contextual)this.declaringBean));
        } else {
            CreationalContext creationalContext = this.reception.equals((Object)Reception.IF_EXISTS) ? null : this.beanManager.createCreationalContext((Contextual)this.declaringBean);
            Object receiver = this.getReceiverIfExists(creationalContext);
            if (receiver != null) {
                this.sendEvent(event, receiver, creationalContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEvent(T event, Object receiver, CreationalContext<?> creationalContext) {
        try {
            this.preNotify(event, receiver);
            if (receiver == null) {
                this.observerMethod.invokeWithSpecialValue(null, Observes.class, event, this.beanManager, creationalContext, ObserverException.class);
            } else {
                this.observerMethod.invokeOnInstanceWithSpecialValue(receiver, Observes.class, event, this.beanManager, creationalContext, ObserverException.class);
            }
        }
        finally {
            this.postNotify(event, receiver);
            if (creationalContext != null) {
                creationalContext.release();
            }
        }
    }

    protected void preNotify(T event, Object receiver) {
    }

    protected void postNotify(T event, Object receiver) {
    }

    private Object getReceiverIfExists(CreationalContext<?> creationalContext) {
        try {
            return this.getReceiver(creationalContext);
        }
        catch (ContextNotActiveException e) {
            return null;
        }
    }

    protected Object getReceiver(CreationalContext<?> ctx) {
        return this.beanManager.getReference(this.declaringBean, null, ctx, true);
    }

    public String toString() {
        return this.observerMethod.toString();
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObserverMethodImpl) {
            ObserverMethodImpl that = (ObserverMethodImpl)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

