/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import com.google.common.util.concurrent.ForwardingExecutorService;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.manager.api.ExecutorServices;
import org.slf4j.cal10n.LocLogger;

public class ProfilingExecutorServices
implements ExecutorServices {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BOOTSTRAP);
    private final ExecutorServices delegate;
    private final AtomicInteger executionId = new AtomicInteger();
    private final AtomicLong executionTimeSum = new AtomicLong();
    private final ProfilingExecutorService wrappedInstance = new ProfilingExecutorService();

    public ProfilingExecutorServices(ExecutorServices delegate) {
        this.delegate = delegate;
        log.info("Delegating to {}", (Object)delegate);
    }

    @Override
    public ExecutorService getTaskExecutor() {
        return this.wrappedInstance;
    }

    @Override
    public void cleanup() {
        if (!this.getTaskExecutor().isShutdown()) {
            log.info("Total time spent in ThreadPool execution is " + this.executionTimeSum.get() + " ms");
        }
        this.delegate.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAllAndCheckForExceptions(Collection<? extends Callable<T>> tasks) {
        Measurement measurement = new Measurement();
        measurement.startProfiling();
        try {
            List list = this.delegate.invokeAllAndCheckForExceptions(tasks);
            return list;
        }
        finally {
            measurement.stopProfiling();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAllAndCheckForExceptions(ExecutorServices.TaskFactory<T> factory) {
        Measurement measurement = new Measurement();
        measurement.startProfiling();
        try {
            List<Future<T>> list = this.delegate.invokeAllAndCheckForExceptions(factory);
            return list;
        }
        finally {
            measurement.stopProfiling();
        }
    }

    public ExecutorServices getDelegate() {
        return this.delegate;
    }

    static /* synthetic */ AtomicInteger access$000(ProfilingExecutorServices x0) {
        return x0.executionId;
    }

    private class ProfilingExecutorService
    extends ForwardingExecutorService {
        private ProfilingExecutorService() {
        }

        @Override
        protected ExecutorService delegate() {
            return ProfilingExecutorServices.this.delegate.getTaskExecutor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            Measurement measurement = new Measurement();
            try {
                measurement.startProfiling();
                List list = this.delegate().invokeAll(tasks);
                return list;
            }
            finally {
                measurement.stopProfiling();
            }
        }
    }

    private class Measurement {
        private volatile long start = 0L;
        private final int id = ProfilingExecutorServices.access$000(ProfilingExecutorServices.this).incrementAndGet();

        private Measurement() {
        }

        public void startProfiling() {
            if (this.start != 0L) {
                throw new IllegalStateException();
            }
            this.start = System.currentTimeMillis();
        }

        public void stopProfiling() {
            if (this.start == 0L) {
                throw new IllegalStateException();
            }
            long current = System.currentTimeMillis();
            long time = current - this.start;
            log.info("ThreadPool task execution #{} took {} ms", (Object)this.id, (Object)time);
            this.start = 0L;
            ProfilingExecutorServices.this.executionTimeSum.addAndGet(time);
        }
    }
}

