/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.spi.helpers;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.jboss.weld.bootstrap.spi.BootstrapConfiguration;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public class FileBasedBootstrapConfiguration
implements BootstrapConfiguration {
    private static final String CONFIGURATION_FILE = "org.jboss.weld.bootstrap.properties";
    private static final String CONCURRENT_DEPLOYMENT = "concurrentDeployment";
    private static final String PRELOADER_THREAD_POOL_SIZE = "preloaderThreadPoolSize";
    private final boolean concurrentDeployment;
    private final int preloaderThreadPoolSize;

    public FileBasedBootstrapConfiguration(ResourceLoader loader) {
        URL configuration = loader.getResource(CONFIGURATION_FILE);
        Properties properties = null;
        if (configuration != null) {
            properties = FileBasedBootstrapConfiguration.loadProperties(configuration);
        }
        this.concurrentDeployment = FileBasedBootstrapConfiguration.initBooleanValue(properties, CONCURRENT_DEPLOYMENT, true);
        this.preloaderThreadPoolSize = FileBasedBootstrapConfiguration.initIntValue(properties, PRELOADER_THREAD_POOL_SIZE, Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
    }

    private static Properties loadProperties(URL url) {
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (IOException e) {
            throw new ResourceLoadingException(e);
        }
        return properties;
    }

    private static int initIntValue(Properties properties, String property, int defaultValue) {
        if (properties == null || properties.get(property) == null) {
            return defaultValue;
        }
        String value = properties.getProperty(property);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ResourceLoadingException("Invalid thread pool size " + value);
        }
    }

    private static boolean initBooleanValue(Properties properties, String property, boolean defaultValue) {
        if (properties == null || properties.get(property) == null) {
            return defaultValue;
        }
        return Boolean.valueOf(properties.getProperty(property));
    }

    @Override
    public boolean isConcurrentDeploymentEnabled() {
        return this.concurrentDeployment;
    }

    @Override
    public int getPreloaderThreadPoolSize() {
        return this.preloaderThreadPoolSize;
    }

    @Override
    public void cleanup() {
    }
}

