/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.Validator;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.util.reflection.Reflections;

public class DisposalMethod<X, T> {
    private final BeanManagerImpl beanManager;
    private final AbstractClassBean<X> declaringBean;
    private final MethodInjectionPoint<T, ? super X> disposalMethodInjectionPoint;
    private final AnnotatedParameter<? super X> disposesParameter;
    private final Set<QualifierInstance> qualifiers;

    public static <X, T> DisposalMethod<X, T> of(BeanManagerImpl manager, EnhancedAnnotatedMethod<T, ? super X> method, AbstractClassBean<X> declaringBean) {
        return new DisposalMethod<X, T>(manager, method, declaringBean);
    }

    protected DisposalMethod(BeanManagerImpl beanManager, EnhancedAnnotatedMethod<T, ? super X> enhancedAnnotatedMethod, AbstractClassBean<X> declaringBean) {
        this.disposalMethodInjectionPoint = InjectionPointFactory.instance().createMethodInjectionPoint(enhancedAnnotatedMethod, declaringBean, declaringBean.getBeanClass(), true, beanManager);
        this.beanManager = beanManager;
        this.declaringBean = declaringBean;
        EnhancedAnnotatedParameter<?, X> enhancedDisposesParameter = this.getEnhancedDisposesParameter(enhancedAnnotatedMethod);
        this.disposesParameter = enhancedDisposesParameter.slim();
        this.qualifiers = QualifierInstance.qualifiers(beanManager, enhancedDisposesParameter.getMetaAnnotations(Qualifier.class));
        this.checkDisposalMethod(enhancedAnnotatedMethod, declaringBean);
    }

    private EnhancedAnnotatedParameter<?, ? super X> getEnhancedDisposesParameter(EnhancedAnnotatedMethod<T, ? super X> enhancedAnnotatedMethod) {
        return enhancedAnnotatedMethod.getEnhancedParameters(Disposes.class).get(0);
    }

    public AnnotatedParameter<? super X> getDisposesParameter() {
        return this.disposesParameter;
    }

    public AnnotatedMethod<? super X> getAnnotated() {
        return this.disposalMethodInjectionPoint.getAnnotated();
    }

    public void invokeDisposeMethod(Object receiver, Object instance, CreationalContext<?> creationalContext) {
        if (receiver == null) {
            this.disposalMethodInjectionPoint.invokeWithSpecialValue(null, Disposes.class, instance, this.beanManager, creationalContext, IllegalArgumentException.class);
        } else {
            this.disposalMethodInjectionPoint.invokeOnInstanceWithSpecialValue(receiver, Disposes.class, instance, this.beanManager, creationalContext, IllegalArgumentException.class);
        }
    }

    private void checkDisposalMethod(EnhancedAnnotatedMethod<T, ? super X> enhancedAnnotatedMethod, AbstractClassBean<X> declaringBean) {
        SessionBean sessionBean;
        Set<MethodSignature> businessMethodSignatures;
        if (enhancedAnnotatedMethod.getEnhancedParameters(Disposes.class).size() > 1) {
            throw new DefinitionException(BeanMessage.MULTIPLE_DISPOSE_PARAMS, this.disposalMethodInjectionPoint);
        }
        if (enhancedAnnotatedMethod.getEnhancedParameters(Observes.class).size() > 0) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Observes", "@Disposes", this.disposalMethodInjectionPoint);
        }
        if (enhancedAnnotatedMethod.getAnnotation(Inject.class) != null) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Intitializer", "@Disposes", this.disposalMethodInjectionPoint);
        }
        if (enhancedAnnotatedMethod.getAnnotation(Produces.class) != null) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Produces", "@Disposes", this.disposalMethodInjectionPoint);
        }
        if (enhancedAnnotatedMethod.getAnnotation(Specializes.class) != null) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Specialized", "@Disposes", this.disposalMethodInjectionPoint);
        }
        if (declaringBean instanceof SessionBean && !(businessMethodSignatures = (sessionBean = (SessionBean)declaringBean).getBusinessMethodSignatures()).contains(enhancedAnnotatedMethod.getSignature())) {
            throw new DefinitionException(BeanMessage.METHOD_NOT_BUSINESS_METHOD, enhancedAnnotatedMethod, declaringBean);
        }
        for (ParameterInjectionPoint ip : this.disposalMethodInjectionPoint.getParameterInjectionPoints()) {
            Class rawType = Reflections.getRawType(ip.getType());
            if (!Bean.class.equals(rawType) && !Interceptor.class.equals(rawType) && !Decorator.class.equals(rawType)) continue;
            Validator.checkBeanMetadataInjectionPoint(this, ip, this.getDisposesParameter().getBaseType());
        }
    }

    public Type getGenericType() {
        return this.getDisposesParameter().getBaseType();
    }

    public Set<QualifierInstance> getQualifiers() {
        return this.qualifiers;
    }

    public AbstractClassBean<X> getDeclaringBean() {
        return this.declaringBean;
    }

    public String toString() {
        return "Disposer method [" + this.getDisposesParameter().getDeclaringCallable() + "]";
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.disposalMethodInjectionPoint.getInjectionPoints();
    }
}

