/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import java.util.Collection;
import java.util.Iterator;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.BoundBeanStore;
import org.jboss.weld.context.beanstore.HashMapBeanStore;
import org.jboss.weld.context.beanstore.LockStore;
import org.jboss.weld.context.beanstore.LockedBean;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ContextMessage;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.slf4j.cal10n.LocLogger;

public abstract class AttributeBeanStore
implements BoundBeanStore {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);
    private final HashMapBeanStore beanStore;
    private final NamingScheme namingScheme;
    private boolean attached;

    public AttributeBeanStore(NamingScheme namingScheme) {
        this.namingScheme = namingScheme;
        this.beanStore = new HashMapBeanStore();
    }

    @Override
    public boolean detach() {
        if (this.attached) {
            this.attached = false;
            log.trace(ContextMessage.BEAN_STORE_DETACHED, this);
            return true;
        }
        return false;
    }

    @Override
    public boolean attach() {
        if (!this.attached) {
            this.attached = true;
            for (BeanIdentifier id : this.beanStore) {
                ContextualInstance instance = this.beanStore.get(id);
                String prefixedId = this.getNamingScheme().prefix(id);
                log.trace(ContextMessage.UPDATING_STORE_WITH_CONTEXTUAL_UNDER_ID, instance, id);
                this.setAttribute(prefixedId, instance);
            }
            for (String prefixedId : this.getPrefixedAttributeNames()) {
                BeanIdentifier id = this.getNamingScheme().deprefix(prefixedId);
                if (this.beanStore.contains(id)) continue;
                ContextualInstance instance = (ContextualInstance)this.getAttribute(prefixedId);
                this.beanStore.put(id, instance);
                log.trace(ContextMessage.ADDING_DETACHED_CONTEXTUAL_UNDER_ID, instance, id);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isAttached() {
        return this.attached;
    }

    @Override
    public <T> ContextualInstance<T> get(BeanIdentifier id) {
        ContextualInstance instance = this.beanStore.get(id);
        log.trace(ContextMessage.CONTEXTUAL_INSTANCE_FOUND, id, instance, this);
        return instance;
    }

    @Override
    public <T> void put(BeanIdentifier id, ContextualInstance<T> instance) {
        this.beanStore.put(id, instance);
        if (this.isAttached()) {
            String prefixedId = this.namingScheme.prefix(id);
            this.setAttribute(prefixedId, instance);
        }
        log.trace(ContextMessage.CONTEXTUAL_INSTANCE_ADDED, instance.getContextual(), id, this);
    }

    @Override
    public <T> ContextualInstance<T> remove(BeanIdentifier id) {
        ContextualInstance instance = this.beanStore.remove(id);
        if (instance != null) {
            if (this.isAttached()) {
                this.removeAttribute(this.namingScheme.prefix(id));
            }
            log.trace(ContextMessage.CONTEXTUAL_INSTANCE_REMOVED, id, this);
        }
        return instance;
    }

    @Override
    public void clear() {
        Iterator<BeanIdentifier> it = this.iterator();
        while (it.hasNext()) {
            BeanIdentifier id = it.next();
            if (this.isAttached()) {
                String prefixedId = this.namingScheme.prefix(id);
                this.removeAttribute(prefixedId);
            }
            it.remove();
            log.trace(ContextMessage.CONTEXTUAL_INSTANCE_REMOVED, id, this);
        }
        log.trace(ContextMessage.CONTEXT_CLEARED, this);
    }

    @Override
    public boolean contains(BeanIdentifier id) {
        return this.get(id) != null;
    }

    protected NamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    @Override
    public Iterator<BeanIdentifier> iterator() {
        return this.beanStore.iterator();
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void removeAttribute(String var1);

    protected abstract Collection<String> getAttributeNames();

    protected Collection<String> getPrefixedAttributeNames() {
        return this.getNamingScheme().filterIds(this.getAttributeNames());
    }

    protected abstract void setAttribute(String var1, Object var2);

    @Override
    public LockedBean lock(BeanIdentifier id) {
        LockStore lockStore = this.getLockStore();
        if (lockStore == null) {
            return null;
        }
        return lockStore.lock(id);
    }

    protected abstract LockStore getLockStore();
}

