/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.tomcat;

import org.jboss.weld.environment.AbstractContainer;
import org.jboss.weld.environment.Container;
import org.jboss.weld.environment.ContainerContext;
import org.jboss.weld.environment.tomcat.WeldForwardingInstanceManager;

public class TomcatContainer
extends AbstractContainer {
    public static Container INSTANCE = new TomcatContainer();

    @Override
    protected String classToCheck() {
        return "org.apache.tomcat.InstanceManager";
    }

    @Override
    public void initialize(ContainerContext context) {
        try {
            WeldForwardingInstanceManager.replaceInstanceManager(context.getServletContext(), context.getManager());
            this.log.info("Tomcat 7+ detected, CDI injection will be available in Servlets and Filters. Injection into Listeners is not supported");
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to replace Tomcat 7 AnnotationProcessor. CDI injection will not be available in Servlets, Filters, or Listeners", e);
        }
    }
}

