/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.util.Map;
import java.util.Set;
import org.jboss.weld.Container;
import org.jboss.weld.resources.SharedObjectCache;

public class SharedObjectFacade {
    private SharedObjectFacade() {
    }

    public static <T> Set<T> wrap(String contextId, Set<T> set) {
        SharedObjectCache cache = SharedObjectFacade.getSharedObjectCache(contextId);
        if (cache != null) {
            return cache.getSharedSet(set);
        }
        return set;
    }

    public static <K, V> Map<K, V> wrap(String contextId, Map<K, V> map) {
        SharedObjectCache cache = SharedObjectFacade.getSharedObjectCache(contextId);
        if (cache != null) {
            return Container.instance(contextId).services().get(SharedObjectCache.class).getSharedMap(map);
        }
        return map;
    }

    private static SharedObjectCache getSharedObjectCache(String contextId) {
        try {
            return Container.instance(contextId).services().get(SharedObjectCache.class);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

