/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.el.ELContextListener;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.TypeDiscoveryConfiguration;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.CDI11Deployment;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.configuration.spi.ExternalConfiguration;
import org.jboss.weld.configuration.spi.helpers.ExternalConfigurationBuilder;
import org.jboss.weld.el.WeldELContextListener;
import org.jboss.weld.environment.Container;
import org.jboss.weld.environment.ContainerContext;
import org.jboss.weld.environment.deployment.WeldBeanDeploymentArchive;
import org.jboss.weld.environment.deployment.WeldDeployment;
import org.jboss.weld.environment.deployment.WeldResourceLoader;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategyFactory;
import org.jboss.weld.environment.gwtdev.GwtDevHostedModeContainer;
import org.jboss.weld.environment.jetty.JettyContainer;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.servlet.SecurityActions;
import org.jboss.weld.environment.servlet.deployment.ServletContextBeanArchiveHandler;
import org.jboss.weld.environment.servlet.deployment.WebAppBeanArchiveScanner;
import org.jboss.weld.environment.servlet.logging.WeldServletLogger;
import org.jboss.weld.environment.servlet.services.ServletResourceInjectionServices;
import org.jboss.weld.environment.servlet.util.ServiceLoader;
import org.jboss.weld.environment.tomcat.TomcatContainer;
import org.jboss.weld.environment.undertow.UndertowContainer;
import org.jboss.weld.environment.util.Reflections;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.metadata.MetadataImpl;
import org.jboss.weld.resources.ManagerObjectFactory;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.servlet.WeldInitialListener;
import org.jboss.weld.servlet.api.ServletListener;

public class WeldServletLifecycle {
    public static final String BEAN_MANAGER_ATTRIBUTE_NAME = WeldServletLifecycle.class.getPackage().getName() + "." + BeanManager.class.getName();
    static final String INSTANCE_ATTRIBUTE_NAME = WeldServletLifecycle.class.getPackage().getName() + ".lifecycleInstance";
    private static final String EXPRESSION_FACTORY_NAME = "org.jboss.weld.el.ExpressionFactory";
    private static final String PROBE_EXTENSION_CLASS_NAME = "org.jboss.weld.probe.ProbeExtension";
    private static final String PROBE_FILTER_CLASS_NAME = "org.jboss.weld.probe.ProbeFilter";
    private static final String CONTEXT_PARAM_ARCHIVE_ISOLATION = WeldServletLifecycle.class.getPackage().getName() + ".archive.isolation";
    private static final String CONTEXT_PARAM_DEV_MODE = "org.jboss.weld.development";
    private static final String JSP_FACTORY_CLASS_NAME = "javax.servlet.jsp.JspFactory";
    private final transient CDI11Bootstrap bootstrap;
    private final transient ServletListener weldListener;
    private final transient ResourceLoader resourceLoader = new WeldResourceLoader();
    private Container container;
    private boolean isBootstrapNeeded = true;
    private boolean isDevModeEnabled;

    WeldServletLifecycle() {
        this.bootstrap = new WeldBootstrap();
        this.weldListener = new WeldInitialListener();
    }

    boolean initialize(ServletContext context) {
        StringBuilder dump;
        ContainerContext containerContext;
        Container container;
        this.isDevModeEnabled = Boolean.valueOf(context.getInitParameter(CONTEXT_PARAM_DEV_MODE));
        WeldManager manager = (WeldManager)context.getAttribute(BEAN_MANAGER_ATTRIBUTE_NAME);
        if (manager != null) {
            this.isBootstrapNeeded = false;
        }
        if (this.isBootstrapNeeded) {
            CDI11Deployment deployment = this.createDeployment(context, this.bootstrap);
            deployment.getServices().add(ExternalConfiguration.class, new ExternalConfigurationBuilder().add(ConfigurationKey.BEAN_IDENTIFIER_INDEX_OPTIMIZATION.get(), Boolean.FALSE.toString()).build());
            if (deployment.getBeanDeploymentArchives().isEmpty()) {
                CommonLogger.LOG.initSkippedNoBeanArchiveFound();
                return false;
            }
            ServletResourceInjectionServices resourceInjectionServices = new ServletResourceInjectionServices(){};
            try {
                for (BeanDeploymentArchive beanDeploymentArchive : deployment.getBeanDeploymentArchives()) {
                    beanDeploymentArchive.getServices().add(ResourceInjectionServices.class, resourceInjectionServices);
                }
            }
            catch (NoClassDefFoundError e) {
                WeldServletLogger.LOG.resourceInjectionNotAvailable();
            }
            String id = context.getInitParameter("WELD_CONTEXT_ID_KEY");
            if (id != null) {
                this.bootstrap.startContainer(id, Environments.SERVLET, deployment);
            } else {
                this.bootstrap.startContainer(Environments.SERVLET, deployment);
            }
            this.bootstrap.startInitialization();
            for (BeanDeploymentArchive bda : deployment.getBeanDeploymentArchives()) {
                if (!bda.getId().contains(ManagerObjectFactory.WEB_INF_CLASSES_FILE_PATH) && !bda.getId().contains("/WEB-INF/classes")) continue;
                manager = this.bootstrap.getManager(bda);
                break;
            }
            if (manager == null) {
                manager = this.bootstrap.getManager(deployment.getBeanDeploymentArchives().iterator().next());
            }
            context.setAttribute(BEAN_MANAGER_ATTRIBUTE_NAME, (Object)manager);
        }
        if ((container = this.findContainer(containerContext = new ContainerContext(context, manager), dump = new StringBuilder())) == null) {
            WeldServletLogger.LOG.noSupportedServletContainerDetected();
            WeldServletLogger.LOG.debugv("Exception dump from Container lookup: {0}", (Object)dump);
        } else {
            container.initialize(containerContext);
            this.container = container;
        }
        if (Reflections.isClassLoadable(WeldClassLoaderResourceLoader.INSTANCE, JSP_FACTORY_CLASS_NAME) && JspFactory.getDefaultFactory() != null) {
            JspApplicationContext jspApplicationContext = JspFactory.getDefaultFactory().getJspApplicationContext(context);
            jspApplicationContext.addELResolver(manager.getELResolver());
            try {
                jspApplicationContext.addELContextListener((ELContextListener)new WeldELContextListener());
            }
            catch (Exception e) {
                throw WeldServletLogger.LOG.errorLoadingWeldELContextListener(e);
            }
            context.setAttribute(EXPRESSION_FACTORY_NAME, (Object)manager.wrapExpressionFactory(jspApplicationContext.getExpressionFactory()));
        }
        if (this.isBootstrapNeeded) {
            this.bootstrap.deployBeans().validateBeans().endInitialization();
            if (this.isDevModeEnabled) {
                FilterRegistration.Dynamic dynamic = context.addFilter("Weld Probe Filter", PROBE_FILTER_CLASS_NAME);
                dynamic.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.INCLUDE), true, new String[]{"/*"});
            }
        }
        return true;
    }

    void destroy(ServletContext context) {
        if (this.isBootstrapNeeded) {
            this.bootstrap.shutdown();
        }
        if (this.container != null) {
            this.container.destroy(new ContainerContext(context, null));
        }
    }

    ServletListener getWeldListener() {
        return this.weldListener;
    }

    protected CDI11Deployment createDeployment(ServletContext context, CDI11Bootstrap bootstrap) {
        ImmutableSet.Builder extensionsBuilder = ImmutableSet.builder();
        extensionsBuilder.addAll(bootstrap.loadExtensions(WeldResourceLoader.getClassLoader()));
        if (this.isDevModeEnabled) {
            try {
                Class probeExtensionClass = Reflections.loadClass(this.resourceLoader, PROBE_EXTENSION_CLASS_NAME);
                if (probeExtensionClass == null) {
                    throw WeldServletLogger.LOG.probeComponentNotFoundOnClasspath(PROBE_EXTENSION_CLASS_NAME);
                }
                extensionsBuilder.add(new MetadataImpl(SecurityActions.newInstance(probeExtensionClass), "N/A"));
            }
            catch (Exception e) {
                throw WeldServletLogger.LOG.unableToInitializeProbeComponent(e.getMessage(), e);
            }
        }
        ImmutableCollection extensions = extensionsBuilder.build();
        TypeDiscoveryConfiguration typeDiscoveryConfiguration = bootstrap.startExtensions(extensions);
        DiscoveryStrategy strategy = DiscoveryStrategyFactory.create(this.resourceLoader, bootstrap, typeDiscoveryConfiguration.getKnownBeanDefiningAnnotations());
        strategy.registerHandler(new ServletContextBeanArchiveHandler(context));
        strategy.setScanner(new WebAppBeanArchiveScanner(this.resourceLoader, bootstrap, context));
        Set<WeldBeanDeploymentArchive> beanDeploymentArchives = strategy.performDiscovery();
        String isolation = context.getInitParameter(CONTEXT_PARAM_ARCHIVE_ISOLATION);
        if (isolation != null && Boolean.valueOf(isolation).equals(Boolean.FALSE)) {
            CommonLogger.LOG.archiveIsolationDisabled();
            beanDeploymentArchives = Collections.singleton(WeldBeanDeploymentArchive.merge(bootstrap, beanDeploymentArchives));
        } else {
            CommonLogger.LOG.archiveIsolationEnabled();
        }
        WeldDeployment deployment = new WeldDeployment(this.resourceLoader, bootstrap, beanDeploymentArchives, extensions);
        if (strategy.getClassFileServices() != null) {
            deployment.getServices().add(ClassFileServices.class, strategy.getClassFileServices());
        }
        return deployment;
    }

    protected Container findContainer(ContainerContext ctx, StringBuilder dump) {
        Iterable<Container> extContainers;
        Container container = null;
        String containerClassName = ctx.getServletContext().getInitParameter(Container.CONTEXT_PARAM_CONTAINER_CLASS);
        if (containerClassName != null) {
            try {
                Class containerClass = Reflections.classForName(this.resourceLoader, containerClassName);
                container = (Container)SecurityActions.newInstance(containerClass);
                WeldServletLogger.LOG.containerDetectionSkipped(containerClassName);
            }
            catch (Exception e) {
                WeldServletLogger.LOG.unableToInstantiateCustomContainerClass(containerClassName);
                WeldServletLogger.LOG.catchingDebug(e);
            }
        }
        if (container == null && (container = this.checkContainers(ctx, dump, extContainers = ServiceLoader.load(Container.class, this.getClass().getClassLoader()))) == null) {
            container = this.checkContainers(ctx, dump, Arrays.asList(TomcatContainer.INSTANCE, JettyContainer.INSTANCE, UndertowContainer.INSTANCE, GwtDevHostedModeContainer.INSTANCE));
        }
        return container;
    }

    protected Container checkContainers(ContainerContext containerContext, StringBuilder dump, Iterable<Container> containers) {
        for (Container container : containers) {
            try {
                if (!container.touch(this.resourceLoader, containerContext)) continue;
                return container;
            }
            catch (Throwable t) {
                dump.append(container).append("->").append(t.getMessage()).append("\n");
            }
        }
        return null;
    }
}

