/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Model;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Scope;
import javax.interceptor.Interceptor;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Reflections;

public class AnnotatedTypes {
    private static Set<Class<? extends Annotation>> BEAN_DEFINING_ANNOTATIONS = ImmutableSet.of(new Class[]{Dependent.class, RequestScoped.class, ConversationScoped.class, SessionScoped.class, ApplicationScoped.class, Interceptor.class, Decorator.class, Model.class});
    private static Set<Class<? extends Annotation>> META_ANNOTATIONS = ImmutableSet.of(new Class[]{Stereotype.class, NormalScope.class});
    public static final Set<Class<? extends Annotation>> TRIM_META_ANNOTATIONS = ImmutableSet.of(new Class[]{Stereotype.class, NormalScope.class, Scope.class});
    private static final char SEPARATOR = ';';

    public static <X> String createTypeId(AnnotatedType<X> annotatedType) {
        return AnnotatedTypes.createTypeId(annotatedType.getJavaClass(), annotatedType.getAnnotations(), annotatedType.getMethods(), annotatedType.getFields(), annotatedType.getConstructors());
    }

    public static <X> String createTypeId(Class<X> clazz, Collection<Annotation> annotations, Collection<AnnotatedMethod<? super X>> methods, Collection<AnnotatedField<? super X>> fields, Collection<AnnotatedConstructor<X>> constructors) {
        StringBuilder builder = new StringBuilder();
        builder.append(clazz.getName());
        builder.append(AnnotatedTypes.createAnnotationCollectionId(annotations));
        builder.append("{");
        ArrayList<AnnotatedField<? super X>> sortedFields = new ArrayList<AnnotatedField<? super X>>();
        sortedFields.addAll(fields);
        Collections.sort(sortedFields, AnnotatedFieldComparator.instance());
        for (AnnotatedField annotatedField : sortedFields) {
            if (annotatedField.getAnnotations().isEmpty()) continue;
            builder.append(AnnotatedTypes.createFieldId(annotatedField));
            builder.append(';');
        }
        ArrayList<AnnotatedMethod<? super X>> sortedMethods = new ArrayList<AnnotatedMethod<? super X>>();
        sortedMethods.addAll(methods);
        Collections.sort(sortedMethods, AnnotatedMethodComparator.instance());
        for (AnnotatedMethod annotatedMethod : sortedMethods) {
            if (annotatedMethod.getAnnotations().isEmpty() && !AnnotatedTypes.hasMethodParameters(annotatedMethod)) continue;
            builder.append(AnnotatedTypes.createCallableId(annotatedMethod));
            builder.append(';');
        }
        ArrayList<AnnotatedConstructor<X>> arrayList = new ArrayList<AnnotatedConstructor<X>>();
        arrayList.addAll(constructors);
        Collections.sort(arrayList, AnnotatedConstructorComparator.instance());
        for (AnnotatedConstructor annotatedConstructor : arrayList) {
            if (annotatedConstructor.getAnnotations().isEmpty() && !AnnotatedTypes.hasMethodParameters(annotatedConstructor)) continue;
            builder.append(AnnotatedTypes.createCallableId(annotatedConstructor));
            builder.append(';');
        }
        builder.append("}");
        return builder.toString();
    }

    private static <X> boolean hasMethodParameters(AnnotatedCallable<X> callable) {
        for (AnnotatedParameter<X> parameter : callable.getParameters()) {
            if (parameter.getAnnotations().isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected static String createAnnotationCollectionId(Collection<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.size());
        annotationList.addAll(annotations);
        Collections.sort(annotationList, AnnotationComparator.INSTANCE);
        for (Annotation a : annotationList) {
            builder.append('@');
            builder.append(a.annotationType().getName());
            builder.append('(');
            Method[] declaredMethods = AccessController.doPrivileged(new GetDeclaredMethodsAction(a.annotationType()));
            ArrayList methods = new ArrayList(declaredMethods.length);
            Collections.addAll(methods, declaredMethods);
            Collections.sort(methods, MethodComparator.INSTANCE);
            for (int i = 0; i < methods.size(); ++i) {
                Method method = (Method)methods.get(i);
                try {
                    Object value = method.invoke((Object)a, new Object[0]);
                    builder.append(method.getName());
                    builder.append('=');
                    builder.append(value.toString());
                }
                catch (NullPointerException e) {
                    AnnotatedTypes.throwRE(a, method, e);
                }
                catch (IllegalArgumentException e) {
                    AnnotatedTypes.throwRE(a, method, e);
                }
                catch (IllegalAccessException e) {
                    AnnotatedTypes.throwRE(a, method, e);
                }
                catch (InvocationTargetException e) {
                    AnnotatedTypes.throwRE(a, method, e);
                }
                if (i + 1 == methods.size()) continue;
                builder.append(',');
            }
            builder.append(')');
        }
        builder.append(']');
        return builder.toString();
    }

    private static void throwRE(Annotation a, Method method, Throwable e) {
        throw new RuntimeException(e.getClass().getSimpleName() + " accessing annotation member, annotation: " + a.annotationType().getName() + " member: " + method.getName(), e);
    }

    public static <X> String createFieldId(AnnotatedField<X> field) {
        return AnnotatedTypes.createFieldId(field.getJavaMember(), field.getAnnotations());
    }

    public static <X> String createFieldId(Field field, Collection<Annotation> annotations) {
        StringBuilder builder = new StringBuilder();
        builder.append(field.getDeclaringClass().getName());
        builder.append('.');
        builder.append(field.getName());
        builder.append(AnnotatedTypes.createAnnotationCollectionId(annotations));
        return builder.toString();
    }

    public static <X> String createCallableId(AnnotatedCallable<X> method) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getJavaMember().getDeclaringClass().getName());
        builder.append('.');
        builder.append(method.getJavaMember().getName());
        builder.append(AnnotatedTypes.createAnnotationCollectionId(method.getAnnotations()));
        builder.append(AnnotatedTypes.createParameterListId(method.getParameters()));
        return builder.toString();
    }

    public static <X> String createMethodId(Method method, Set<Annotation> annotations, List<AnnotatedParameter<X>> parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append(method.getDeclaringClass().getName());
        builder.append('.');
        builder.append(method.getName());
        builder.append(AnnotatedTypes.createAnnotationCollectionId(annotations));
        builder.append(AnnotatedTypes.createParameterListId(parameters));
        return builder.toString();
    }

    public static <X> String createConstructorId(Constructor<X> constructor, Set<Annotation> annotations, List<AnnotatedParameter<X>> parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append(constructor.getDeclaringClass().getName());
        builder.append('.');
        builder.append(constructor.getName());
        builder.append(AnnotatedTypes.createAnnotationCollectionId(annotations));
        builder.append(AnnotatedTypes.createParameterListId(parameters));
        return builder.toString();
    }

    public static <X> String createParameterListId(List<AnnotatedParameter<X>> parameters) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            AnnotatedParameter<X> ap = parameters.get(i);
            builder.append(AnnotatedTypes.createParameterId(ap));
            if (i + 1 == parameters.size()) continue;
            builder.append(',');
        }
        builder.append(")");
        return builder.toString();
    }

    public static <X> String createParameterId(AnnotatedParameter<X> annotatedParameter) {
        return AnnotatedTypes.createParameterId(annotatedParameter.getBaseType(), annotatedParameter.getAnnotations());
    }

    public static <X> String createParameterId(Type type, Set<Annotation> annotations) {
        StringBuilder builder = new StringBuilder();
        if (type instanceof Class) {
            Class c = (Class)type;
            builder.append(c.getName());
        } else {
            builder.append(type.toString());
        }
        builder.append(AnnotatedTypes.createAnnotationCollectionId(annotations));
        return builder.toString();
    }

    private static boolean compareAnnotated(Annotated a1, Annotated a2) {
        return a1.getAnnotations().equals(a2.getAnnotations());
    }

    private static boolean compareAnnotatedParameters(List<? extends AnnotatedParameter<?>> p1, List<? extends AnnotatedParameter<?>> p2) {
        if (p1.size() != p2.size()) {
            return false;
        }
        for (int i = 0; i < p1.size(); ++i) {
            if (AnnotatedTypes.compareAnnotated(p1.get(i), p2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean compareAnnotatedParameters(AnnotatedParameter<?> p1, AnnotatedParameter<?> p2) {
        return AnnotatedTypes.compareAnnotatedCallable(p1.getDeclaringCallable(), p2.getDeclaringCallable()) && p1.getPosition() == p2.getPosition() && AnnotatedTypes.compareAnnotated(p1, p2);
    }

    public static boolean compareAnnotatedField(AnnotatedField<?> f1, AnnotatedField<?> f2) {
        if (!f1.getJavaMember().equals(f2.getJavaMember())) {
            return false;
        }
        return AnnotatedTypes.compareAnnotated(f1, f2);
    }

    public static boolean compareAnnotatedCallable(AnnotatedCallable<?> m1, AnnotatedCallable<?> m2) {
        if (!m1.getJavaMember().equals(m2.getJavaMember())) {
            return false;
        }
        if (!AnnotatedTypes.compareAnnotated(m1, m2)) {
            return false;
        }
        return AnnotatedTypes.compareAnnotatedParameters(m1.getParameters(), m2.getParameters());
    }

    public static boolean compareAnnotatedTypes(AnnotatedType<?> t1, AnnotatedType<?> t2) {
        if (!t1.getJavaClass().equals(t2.getJavaClass())) {
            return false;
        }
        if (!AnnotatedTypes.compareAnnotated(t1, t2)) {
            return false;
        }
        if (t1.getFields().size() != t2.getFields().size()) {
            return false;
        }
        HashMap fields = new HashMap();
        for (AnnotatedField<?> annotatedField : t2.getFields()) {
            fields.put(annotatedField.getJavaMember(), annotatedField);
        }
        for (AnnotatedField<?> annotatedField : t1.getFields()) {
            if (fields.containsKey(annotatedField.getJavaMember())) {
                if (AnnotatedTypes.compareAnnotatedField(annotatedField, (AnnotatedField)fields.get(annotatedField.getJavaMember()))) continue;
                return false;
            }
            return false;
        }
        if (t1.getMethods().size() != t2.getMethods().size()) {
            return false;
        }
        HashMap methods = new HashMap();
        for (AnnotatedMethod<?> f : t2.getMethods()) {
            methods.put(f.getJavaMember(), f);
        }
        for (AnnotatedMethod<?> f : t1.getMethods()) {
            if (methods.containsKey(f.getJavaMember())) {
                if (AnnotatedTypes.compareAnnotatedCallable(f, (AnnotatedCallable)methods.get(f.getJavaMember()))) continue;
                return false;
            }
            return false;
        }
        if (t1.getConstructors().size() != t2.getConstructors().size()) {
            return false;
        }
        HashMap hashMap = new HashMap();
        for (AnnotatedConstructor<?> f : t2.getConstructors()) {
            hashMap.put(f.getJavaMember(), f);
        }
        for (AnnotatedConstructor<?> f : t1.getConstructors()) {
            if (hashMap.containsKey(f.getJavaMember())) {
                if (AnnotatedTypes.compareAnnotatedCallable(f, (AnnotatedCallable)hashMap.get(f.getJavaMember()))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static AnnotatedType<?> getDeclaringAnnotatedType(Annotated annotated) {
        if (annotated == null) {
            throw new IllegalArgumentException("Annotated cannot be null");
        }
        if (annotated instanceof AnnotatedType) {
            return (AnnotatedType)Reflections.cast(annotated);
        }
        if (annotated instanceof AnnotatedMember) {
            return ((AnnotatedMember)Reflections.cast(annotated)).getDeclaringType();
        }
        if (annotated instanceof AnnotatedParameter) {
            return AnnotatedTypes.getDeclaringAnnotatedType(((AnnotatedParameter)Reflections.cast(annotated)).getDeclaringCallable());
        }
        throw new IllegalArgumentException("Unrecognized annotated " + annotated);
    }

    private AnnotatedTypes() {
    }

    public static boolean hasBeanDefiningAnnotation(AnnotatedType<?> annotatedType) {
        return AnnotatedTypes.hasBeanDefiningAnnotation(annotatedType, META_ANNOTATIONS);
    }

    public static boolean hasBeanDefiningAnnotation(AnnotatedType<?> annotatedType, Set<Class<? extends Annotation>> metaAnnotations) {
        for (Class<? extends Annotation> beanDefiningAnnotation : BEAN_DEFINING_ANNOTATIONS) {
            if (!annotatedType.isAnnotationPresent(beanDefiningAnnotation)) continue;
            return true;
        }
        for (Class<? extends Annotation> metaAnnotation : metaAnnotations) {
            if (!AnnotatedTypes.hasBeanDefiningMetaAnnotationSpecified(annotatedType.getAnnotations(), metaAnnotation)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasBeanDefiningMetaAnnotationSpecified(Set<Annotation> annotations, Class<? extends Annotation> metaAnnotationType) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(metaAnnotationType)) continue;
            return true;
        }
        return false;
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class MethodComparator
    implements Comparator<Method> {
        public static final Comparator<Method> INSTANCE = new MethodComparator();

        private MethodComparator() {
        }

        @Override
        public int compare(Method arg0, Method arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class AnnotationComparator
    implements Comparator<Annotation> {
        public static final Comparator<Annotation> INSTANCE = new AnnotationComparator();

        private AnnotationComparator() {
        }

        @Override
        public int compare(Annotation arg0, Annotation arg1) {
            return arg0.annotationType().getName().compareTo(arg1.annotationType().getName());
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class AnnotatedFieldComparator<T>
    implements Comparator<AnnotatedField<? super T>> {
        private AnnotatedFieldComparator() {
        }

        public static <T> Comparator<AnnotatedField<? super T>> instance() {
            return new AnnotatedFieldComparator<T>();
        }

        @Override
        public int compare(AnnotatedField<? super T> arg0, AnnotatedField<? super T> arg1) {
            if (arg0.getJavaMember().getName().equals(arg1.getJavaMember().getName())) {
                return arg0.getJavaMember().getDeclaringClass().getName().compareTo(arg1.getJavaMember().getDeclaringClass().getName());
            }
            return arg0.getJavaMember().getName().compareTo(arg1.getJavaMember().getName());
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class AnnotatedConstructorComparator<T>
    implements Comparator<AnnotatedConstructor<? super T>> {
        private AnnotatedCallableComparator<T> callableComparator = new AnnotatedCallableComparator();

        private AnnotatedConstructorComparator() {
        }

        public static <T> Comparator<AnnotatedConstructor<? super T>> instance() {
            return new AnnotatedConstructorComparator<T>();
        }

        @Override
        public int compare(AnnotatedConstructor<? super T> arg0, AnnotatedConstructor<? super T> arg1) {
            int result = this.callableComparator.compare(arg0, arg1);
            if (result != 0) {
                return result;
            }
            result = arg0.getJavaMember().getParameterTypes().length - arg1.getJavaMember().getParameterTypes().length;
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < arg0.getJavaMember().getParameterTypes().length; ++i) {
                Class<?> p0 = arg0.getJavaMember().getParameterTypes()[i];
                Class<?> p1 = arg1.getJavaMember().getParameterTypes()[i];
                result = p0.getName().compareTo(p1.getName());
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class AnnotatedMethodComparator<T>
    implements Comparator<AnnotatedMethod<? super T>> {
        private AnnotatedCallableComparator<T> callableComparator = new AnnotatedCallableComparator();

        private AnnotatedMethodComparator() {
        }

        public static <T> Comparator<AnnotatedMethod<? super T>> instance() {
            return new AnnotatedMethodComparator<T>();
        }

        @Override
        public int compare(AnnotatedMethod<? super T> arg0, AnnotatedMethod<? super T> arg1) {
            int result = this.callableComparator.compare(arg0, arg1);
            if (result != 0) {
                return result;
            }
            result = arg0.getJavaMember().getParameterTypes().length - arg1.getJavaMember().getParameterTypes().length;
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < arg0.getJavaMember().getParameterTypes().length; ++i) {
                Class<?> p0 = arg0.getJavaMember().getParameterTypes()[i];
                Class<?> p1 = arg1.getJavaMember().getParameterTypes()[i];
                result = p0.getName().compareTo(p1.getName());
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static class AnnotatedCallableComparator<T>
    implements Comparator<AnnotatedCallable<? super T>> {
        private AnnotatedCallableComparator() {
        }

        @Override
        public int compare(AnnotatedCallable<? super T> arg0, AnnotatedCallable<? super T> arg1) {
            int result = arg0.getJavaMember().getName().compareTo(arg1.getJavaMember().getName());
            if (result != 0) {
                return result;
            }
            result = arg0.getJavaMember().getDeclaringClass().getName().compareTo(arg1.getJavaMember().getDeclaringClass().getName());
            if (result != 0) {
                return result;
            }
            result = arg0.getParameters().size() - arg1.getParameters().size();
            return result;
        }
    }
}

