/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.BeanDeploymentModule;
import org.jboss.weld.bootstrap.BeanDeploymentModules;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.context.BoundContext;
import org.jboss.weld.context.ManagedContext;
import org.jboss.weld.context.cache.RequestScopedCache;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpRequestContextImpl;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.context.http.HttpSessionDestructionContext;
import org.jboss.weld.event.EventMetadataImpl;
import org.jboss.weld.event.FastEvent;
import org.jboss.weld.literal.DestroyedLiteral;
import org.jboss.weld.literal.InitializedLiteral;
import org.jboss.weld.logging.ServletLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.servlet.ConversationContextActivator;
import org.jboss.weld.servlet.ServletApiAbstraction;
import org.jboss.weld.servlet.ServletContextService;
import org.jboss.weld.servlet.SessionHolder;
import org.jboss.weld.servlet.spi.HttpContextActivationFilter;
import org.jboss.weld.util.reflection.Reflections;

public class HttpContextLifecycle
implements Service {
    public static final String ASYNC_STARTED_ATTR_NAME = "org.jboss.weld.context.asyncStarted";
    private static final String HTTP_SESSION = "org.jboss.weld." + HttpSession.class.getName();
    private static final String INCLUDE_HEADER = "javax.servlet.include.request_uri";
    private static final String FORWARD_HEADER = "javax.servlet.forward.request_uri";
    private static final String REQUEST_DESTROYED = HttpContextLifecycle.class.getName() + ".request.destroyed";
    private static final String GUARD_PARAMETER_NAME = "org.jboss.weld.context.ignore.guard.marker";
    private static final Object GUARD_PARAMETER_VALUE = new Object();
    private HttpSessionDestructionContext sessionDestructionContextCache;
    private HttpSessionContext sessionContextCache;
    private HttpRequestContext requestContextCache;
    private volatile Boolean conversationActivationEnabled;
    private final boolean ignoreForwards;
    private final boolean ignoreIncludes;
    private final BeanManagerImpl beanManager;
    private final ConversationContextActivator conversationContextActivator;
    private final HttpContextActivationFilter contextActivationFilter;
    private final FastEvent<HttpServletRequest> requestInitializedEvent;
    private final FastEvent<HttpServletRequest> requestDestroyedEvent;
    private final FastEvent<HttpSession> sessionInitializedEvent;
    private final FastEvent<HttpSession> sessionDestroyedEvent;
    private final ServletApiAbstraction servletApi;
    private final ServletContextService servletContextService;
    private final Container container;
    private final BeanDeploymentModule module;
    private static final ThreadLocal<Counter> nestedInvocationGuard = new ThreadLocal();
    private final boolean nestedInvocationGuardEnabled;

    public HttpContextLifecycle(BeanManagerImpl beanManager, HttpContextActivationFilter contextActivationFilter, boolean ignoreForwards, boolean ignoreIncludes, boolean lazyConversationContext, boolean nestedInvocationGuardEnabled) {
        this.beanManager = beanManager;
        this.conversationContextActivator = new ConversationContextActivator(beanManager, lazyConversationContext);
        this.conversationActivationEnabled = null;
        this.ignoreForwards = ignoreForwards;
        this.ignoreIncludes = ignoreIncludes;
        this.contextActivationFilter = contextActivationFilter;
        this.requestInitializedEvent = FastEvent.of(HttpServletRequest.class, beanManager, InitializedLiteral.REQUEST);
        this.requestDestroyedEvent = FastEvent.of(HttpServletRequest.class, beanManager, DestroyedLiteral.REQUEST);
        this.sessionInitializedEvent = FastEvent.of(HttpSession.class, beanManager, InitializedLiteral.SESSION);
        this.sessionDestroyedEvent = FastEvent.of(HttpSession.class, beanManager, DestroyedLiteral.SESSION);
        this.servletApi = beanManager.getServices().get(ServletApiAbstraction.class);
        this.servletContextService = beanManager.getServices().get(ServletContextService.class);
        this.nestedInvocationGuardEnabled = nestedInvocationGuardEnabled;
        this.container = Container.instance(beanManager);
        BeanDeploymentModules beanDeploymentModules = beanManager.getServices().get(BeanDeploymentModules.class);
        this.module = beanDeploymentModules != null ? beanDeploymentModules.getModule(beanManager) : null;
    }

    private HttpSessionDestructionContext getSessionDestructionContext() {
        if (this.sessionDestructionContextCache == null) {
            this.sessionDestructionContextCache = (HttpSessionDestructionContext)this.beanManager.instance().select(HttpSessionDestructionContext.class, new Annotation[0]).get();
        }
        return this.sessionDestructionContextCache;
    }

    private HttpSessionContext getSessionContext() {
        if (this.sessionContextCache == null) {
            this.sessionContextCache = (HttpSessionContext)this.beanManager.instance().select(HttpSessionContext.class, new Annotation[0]).get();
        }
        return this.sessionContextCache;
    }

    public HttpRequestContext getRequestContext() {
        if (this.requestContextCache == null) {
            this.requestContextCache = (HttpRequestContext)this.beanManager.instance().select(HttpRequestContext.class, new Annotation[0]).get();
        }
        return this.requestContextCache;
    }

    public void contextInitialized(ServletContext ctx) {
        this.servletContextService.contextInitialized(ctx);
        this.fireEventForApplicationScope(ctx, InitializedLiteral.APPLICATION);
    }

    public void contextDestroyed(ServletContext ctx) {
        this.fireEventForApplicationScope(ctx, DestroyedLiteral.APPLICATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEventForApplicationScope(ServletContext ctx, Annotation qualifier) {
        if (this.module != null) {
            Container container = this.container;
            synchronized (container) {
                if (this.module.isWebModule()) {
                    this.module.fireEvent((Type)((Object)ServletContext.class), ctx, qualifier);
                } else {
                    EventMetadataImpl metadata = new EventMetadataImpl((Type)((Object)ServletContext.class), null, Collections.singleton(qualifier));
                    this.beanManager.getAccessibleLenientObserverNotifier().fireEvent((Type)((Object)ServletContext.class), (Object)ctx, metadata, qualifier);
                }
            }
        }
    }

    public void sessionCreated(HttpSession session) {
        SessionHolder.sessionCreated(session);
        this.conversationContextActivator.sessionCreated(session);
        this.sessionInitializedEvent.fire(session);
    }

    public void sessionDestroyed(HttpSession session) {
        this.deactivateSessionDestructionContext(session);
        boolean destroyed = this.getSessionContext().destroy(session);
        SessionHolder.clear();
        RequestScopedCache.endRequest();
        if (destroyed) {
            this.sessionDestroyedEvent.fire(session);
        } else if (this.getRequestContext() instanceof HttpRequestContextImpl) {
            HttpServletRequest request = ((HttpRequestContextImpl)Reflections.cast(this.getRequestContext())).getHttpServletRequest();
            request.setAttribute(HTTP_SESSION, (Object)session);
        }
    }

    private void deactivateSessionDestructionContext(HttpSession session) {
        HttpSessionDestructionContext context = this.getSessionDestructionContext();
        if (context.isActive()) {
            context.deactivate();
            context.dissociate(session);
        }
    }

    public void requestInitialized(HttpServletRequest request, ServletContext ctx) {
        if (this.nestedInvocationGuardEnabled) {
            Counter counter = nestedInvocationGuard.get();
            Object marker = request.getAttribute(GUARD_PARAMETER_NAME);
            if (counter != null && marker != null) {
                counter.value++;
                return;
            }
            if (counter != null && marker == null) {
                ServletLogger.LOG.guardLeak(counter.value);
            }
            nestedInvocationGuard.set(new Counter());
            request.setAttribute(GUARD_PARAMETER_NAME, GUARD_PARAMETER_VALUE);
        }
        if (this.ignoreForwards && this.isForwardedRequest(request)) {
            return;
        }
        if (this.ignoreIncludes && this.isIncludedRequest(request)) {
            return;
        }
        if (!this.contextActivationFilter.accepts(request)) {
            return;
        }
        ServletLogger.LOG.requestInitialized(request);
        SessionHolder.requestInitialized(request);
        this.getRequestContext().associate(request);
        this.getSessionContext().associate(request);
        if (this.conversationActivationEnabled.booleanValue()) {
            this.conversationContextActivator.associateConversationContext(request);
        }
        this.getRequestContext().activate();
        this.getSessionContext().activate();
        try {
            if (this.conversationActivationEnabled.booleanValue()) {
                this.conversationContextActivator.activateConversationContext(request);
            }
            this.requestInitializedEvent.fire(request);
        }
        catch (RuntimeException e) {
            try {
                this.requestDestroyed(request);
            }
            catch (Exception exception) {
                // empty catch block
            }
            request.setAttribute(REQUEST_DESTROYED, (Object)Boolean.TRUE);
            throw e;
        }
    }

    public void requestDestroyed(HttpServletRequest request) {
        if (this.isRequestDestroyed(request)) {
            return;
        }
        if (this.nestedInvocationGuardEnabled) {
            Counter counter = nestedInvocationGuard.get();
            if (counter != null) {
                counter.value--;
                if (counter.value > 0) {
                    return;
                }
                nestedInvocationGuard.remove();
                request.removeAttribute(GUARD_PARAMETER_NAME);
            } else {
                ServletLogger.LOG.guardNotSet();
                return;
            }
        }
        if (this.ignoreForwards && this.isForwardedRequest(request)) {
            return;
        }
        if (this.ignoreIncludes && this.isIncludedRequest(request)) {
            return;
        }
        if (!this.contextActivationFilter.accepts(request)) {
            return;
        }
        ServletLogger.LOG.requestDestroyed(request);
        try {
            this.conversationContextActivator.deactivateConversationContext(request);
            if (this.servletApi.isAsyncSupported() && this.servletApi.isAsyncStarted((ServletRequest)request)) {
                request.setAttribute(ASYNC_STARTED_ATTR_NAME, (Object)true);
            } else {
                this.getRequestContext().invalidate();
            }
            this.safelyDeactivate(this.getRequestContext(), request);
            this.requestDestroyedEvent.fire(request);
            this.safelyDeactivate(this.getSessionContext(), request);
            Object destroyedHttpSession = request.getAttribute(HTTP_SESSION);
            if (destroyedHttpSession != null) {
                this.sessionDestroyedEvent.fire((HttpSession)destroyedHttpSession);
            }
        }
        finally {
            this.safelyDissociate(this.getRequestContext(), request);
            this.safelyDissociate(this.getSessionContext(), request);
            this.conversationContextActivator.disassociateConversationContext(request);
            SessionHolder.clear();
        }
    }

    public boolean isConversationActivationSet() {
        return this.conversationActivationEnabled != null;
    }

    public void setConversationActivationEnabled(boolean conversationActivationEnabled) {
        this.conversationActivationEnabled = conversationActivationEnabled;
    }

    @Override
    public void cleanup() {
    }

    private boolean isIncludedRequest(HttpServletRequest request) {
        return request.getAttribute(INCLUDE_HEADER) != null;
    }

    private boolean isForwardedRequest(HttpServletRequest request) {
        return request.getAttribute(FORWARD_HEADER) != null;
    }

    private boolean isRequestDestroyed(HttpServletRequest request) {
        return request.getAttribute(REQUEST_DESTROYED) != null;
    }

    private <T> void safelyDissociate(BoundContext<T> context, T storage) {
        try {
            context.dissociate(storage);
        }
        catch (Exception e) {
            ServletLogger.LOG.unableToDissociateContext(context, storage);
            ServletLogger.LOG.catchingDebug(e);
        }
    }

    private void safelyDeactivate(ManagedContext context, HttpServletRequest request) {
        try {
            context.deactivate();
        }
        catch (Exception e) {
            ServletLogger.LOG.unableToDeactivateContext(context, request);
            ServletLogger.LOG.catchingDebug(e);
        }
    }

    private static class Counter {
        private int value = 1;

        private Counter() {
        }
    }
}

