/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.environment.ContainerInstance;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.junit.MockBean;
import org.jboss.weld.junit.MockEjbInjectionServices;
import org.jboss.weld.junit.MockInterceptor;
import org.jboss.weld.junit.MockJpaInjectionServices;
import org.jboss.weld.junit.MockResourceInjectionServices;
import org.jboss.weld.junit.WeldCDIExtension;

public abstract class AbstractWeldInitiator
implements Instance<Object>,
ContainerInstance {
    protected final Weld weld;
    protected final List<ToInject> instancesToInject = new ArrayList<ToInject>();
    protected final Set<Class<? extends Annotation>> scopesToActivate;
    protected final Set<Bean<?>> beans;
    protected final WeldCDIExtension extension;
    private final Map<String, Object> resources;
    private final Function<InjectionPoint, Object> ejbFactory;
    private final Function<InjectionPoint, Object> persistenceUnitFactory;
    private final Function<InjectionPoint, Object> persistenceContextFactory;
    protected volatile WeldContainer container;

    public static Weld createWeld() {
        return new Weld().disableDiscovery().property(ConfigurationKey.CONCURRENT_DEPLOYMENT.get(), (Object)false);
    }

    protected AbstractWeldInitiator(Weld weld, List<Object> instancesToInject, Set<Class<? extends Annotation>> scopesToActivate, Set<Bean<?>> beans, Map<String, Object> resources, Function<InjectionPoint, Object> ejbFactory, Function<InjectionPoint, Object> persistenceUnitFactory, Function<InjectionPoint, Object> persistenceContextFactory) {
        for (Object instance : instancesToInject) {
            this.instancesToInject.add(this.createToInject(instance));
        }
        this.scopesToActivate = scopesToActivate;
        this.beans = beans;
        this.weld = weld;
        boolean hasMockInterceptor = false;
        boolean dummyBeanAdded = false;
        if (this.hasScopesToActivate() || this.hasBeansToAdd()) {
            this.extension = new WeldCDIExtension(this.scopesToActivate, this.beans);
            for (Bean<?> bean : this.beans) {
                if (bean instanceof MockBean) {
                    MockBean mockBean = (MockBean)bean;
                    if (!mockBean.isAlternative() || !mockBean.isSelectForSyntheticBeanArchive()) continue;
                    this.weld.addAlternative(mockBean.getBeanClass());
                    if (dummyBeanAdded) continue;
                    this.weld.addBeanClass(Object.class);
                    dummyBeanAdded = true;
                    continue;
                }
                if (!(bean instanceof MockInterceptor) || !((MockInterceptor)bean).hasDefaultBeanClass()) continue;
                hasMockInterceptor = true;
            }
            if (hasMockInterceptor) {
                this.weld.addInterceptor(MockInterceptor.class);
            }
            this.weld.addExtension((Extension)this.extension);
        } else {
            this.extension = null;
        }
        this.resources = resources;
        this.ejbFactory = ejbFactory;
        this.persistenceContextFactory = persistenceContextFactory;
        this.persistenceUnitFactory = persistenceUnitFactory;
    }

    protected ToInject createToInject(Object instanceToInject) {
        return new ToInject(instanceToInject);
    }

    public AutoCloseable injectNonContextual(Object target) {
        ToInject toInject = new ToInject(target);
        toInject.inject();
        return toInject::release;
    }

    public Iterator<Object> iterator() {
        this.checkContainer();
        return this.container.iterator();
    }

    public Object get() {
        this.checkContainer();
        return this.container.get();
    }

    public WeldInstance<Object> select(Annotation ... qualifiers) {
        this.checkContainer();
        return this.container.select(qualifiers);
    }

    public <U> WeldInstance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        this.checkContainer();
        return this.container.select(subtype, qualifiers);
    }

    public <U> WeldInstance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        this.checkContainer();
        return this.container.select(subtype, qualifiers);
    }

    public boolean isUnsatisfied() {
        this.checkContainer();
        return this.container.isUnsatisfied();
    }

    public boolean isAmbiguous() {
        this.checkContainer();
        return this.container.isAmbiguous();
    }

    public void destroy(Object instance) {
        this.checkContainer();
        this.container.destroy(instance);
    }

    public Event<Object> event() {
        this.checkContainer();
        try {
            Method eventMethod = this.container.getClass().getMethod("event", new Class[0]);
            return (Event)eventMethod.invoke((Object)this.container, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Cannot invoke WeldContainer.event() method using reflection", e);
        }
    }

    public BeanManager getBeanManager() {
        this.checkContainer();
        return this.container.getBeanManager();
    }

    public String getId() {
        return this.container.getId();
    }

    public void shutdown() {
        this.container.shutdown();
    }

    public boolean isRunning() {
        return this.container != null && this.container.isRunning();
    }

    public WeldContainer container() {
        this.checkContainer();
        return this.container;
    }

    private void checkContainer() {
        if (this.container == null || !this.container.isRunning()) {
            throw new IllegalStateException("Weld container is not running");
        }
    }

    protected void injectInstances() {
        if (this.instancesToInject != null) {
            for (ToInject toInject : this.instancesToInject) {
                toInject.inject();
            }
        }
    }

    protected void releaseInstances() {
        if (this.instancesToInject != null) {
            for (ToInject toInject : this.instancesToInject) {
                toInject.release();
            }
        }
    }

    private boolean hasScopesToActivate() {
        return this.scopesToActivate != null && !this.scopesToActivate.isEmpty();
    }

    private boolean hasBeansToAdd() {
        return this.beans != null && !this.beans.isEmpty();
    }

    protected WeldContainer initWeldContainer(Weld weld) {
        if (!this.resources.isEmpty()) {
            weld.addServices(new Service[]{new MockResourceInjectionServices(this.resources)});
        }
        if (this.ejbFactory != null) {
            weld.addServices(new Service[]{new MockEjbInjectionServices(this.ejbFactory)});
        }
        if (this.persistenceContextFactory != null || this.persistenceUnitFactory != null) {
            weld.addServices(new Service[]{new MockJpaInjectionServices(this.persistenceUnitFactory, this.persistenceContextFactory)});
        }
        this.container = weld.initialize();
        if (this.extension != null) {
            this.extension.activateContexts();
        }
        this.injectInstances();
        return this.container;
    }

    protected void shutdownWeldContainer() {
        try {
            if (this.extension != null) {
                this.extension.deactivateContexts();
            }
            this.releaseInstances();
        }
        finally {
            if (this.container != null && this.container.isRunning()) {
                this.container.shutdown();
            }
        }
    }

    protected static abstract class AbstractBuilder<I extends AbstractWeldInitiator, T extends AbstractBuilder<I, T>> {
        protected final Weld weld;
        protected final List<Object> instancesToInject;
        protected final Set<Class<? extends Annotation>> scopesToActivate;
        protected final Set<Bean<?>> beans;
        protected final Map<String, Object> resources;
        private Function<InjectionPoint, Object> ejbFactory;
        private Function<InjectionPoint, Object> persistenceUnitFactory;
        private Function<InjectionPoint, Object> persistenceContextFactory;

        public AbstractBuilder(Weld weld) {
            this.weld = weld;
            this.instancesToInject = new ArrayList<Object>();
            this.scopesToActivate = new HashSet<Class<? extends Annotation>>();
            this.beans = new HashSet();
            this.resources = new HashMap<String, Object>();
        }

        @SafeVarargs
        public final T activate(Class<? extends Annotation> ... normalScopes) {
            for (Class<? extends Annotation> scope : normalScopes) {
                if (ApplicationScoped.class.equals(scope)) continue;
                if (!scope.isAnnotationPresent(NormalScope.class)) {
                    throw new IllegalArgumentException("Only annotations annotated with @NormalScope are supported!");
                }
                this.scopesToActivate.add(scope);
            }
            return this.self();
        }

        protected Function<InjectionPoint, Object> getEjbFactory() {
            return this.ejbFactory;
        }

        protected Function<InjectionPoint, Object> getPersistenceContextFactory() {
            return this.persistenceContextFactory;
        }

        protected Function<InjectionPoint, Object> getPersistenceUnitFactory() {
            return this.persistenceUnitFactory;
        }

        public T inject(Object instance) {
            this.instancesToInject.add(instance);
            return this.self();
        }

        public T addBeans(Bean<?> ... beans) {
            Collections.addAll(this.beans, beans);
            return this.self();
        }

        public T bindResource(String name, Object resource) {
            this.resources.put(name, resource);
            return this.self();
        }

        public T setEjbFactory(Function<InjectionPoint, Object> ejbFactory) {
            this.ejbFactory = ejbFactory;
            return this.self();
        }

        public T setPersistenceUnitFactory(Function<InjectionPoint, Object> persistenceUnitFactory) {
            this.persistenceUnitFactory = persistenceUnitFactory;
            return this.self();
        }

        public T setPersistenceContextFactory(Function<InjectionPoint, Object> persistenceContextFactory) {
            this.persistenceContextFactory = persistenceContextFactory;
            return this.self();
        }

        protected abstract T self();

        protected abstract I build(Weld var1, List<Object> var2, Set<Class<? extends Annotation>> var3, Set<Bean<?>> var4);

        public I build() {
            return this.build(this.weld, this.instancesToInject.isEmpty() ? Collections.emptyList() : new ArrayList<Object>(this.instancesToInject), this.scopesToActivate.isEmpty() ? Collections.emptySet() : new HashSet<Class<? extends Annotation>>(this.scopesToActivate), this.beans.isEmpty() ? Collections.emptySet() : new HashSet(this.beans));
        }
    }

    protected class ToInject {
        private final Object instance;
        private volatile CreationalContext<?> creationalContext;

        ToInject(Object instance) {
            this.instance = instance;
        }

        void inject() {
            BeanManager beanManager = AbstractWeldInitiator.this.container.getBeanManager();
            CreationalContext ctx = beanManager.createCreationalContext(null);
            InjectionTarget injectionTarget = beanManager.getInjectionTargetFactory(beanManager.createAnnotatedType(this.instance.getClass())).createInjectionTarget(null);
            injectionTarget.inject(this.instance, ctx);
            this.creationalContext = ctx;
        }

        void release() {
            if (this.creationalContext != null) {
                this.creationalContext.release();
            }
        }
    }
}

