/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.util.bean.SerializableForwardingBean;
import org.jboss.weld.util.collections.ImmutableSet;

public class MockInterceptor
implements Interceptor<MockInterceptorInstance> {
    private final Class<?> beanClass;
    private final InterceptionType type;
    private final InterceptionCallback callback;
    private final Set<Annotation> interceptorBindings;

    public static Builder withBindings(Annotation ... interceptorBindings) {
        return new Builder().bindings(interceptorBindings);
    }

    private MockInterceptor(Class<?> beanClass, InterceptionType type, InterceptionCallback callback, Set<Annotation> interceptorBindings) {
        this.beanClass = beanClass;
        this.type = type;
        this.callback = callback;
        this.interceptorBindings = interceptorBindings;
    }

    public Set<Annotation> getInterceptorBindings() {
        return ImmutableSet.copyOf(this.interceptorBindings);
    }

    public boolean intercepts(InterceptionType type) {
        return this.type.equals((Object)type);
    }

    public Object intercept(InterceptionType type, MockInterceptorInstance instance, InvocationContext ctx) throws Exception {
        return this.callback.invoke(ctx, instance.getInterceptedBean());
    }

    public MockInterceptorInstance create(CreationalContext<MockInterceptorInstance> creationalContext) {
        return new MockInterceptorInstance(this.getInterceptedBean(creationalContext), BeanManagerProxy.unwrap((BeanManager)CDI.current().getBeanManager()).getContextId());
    }

    public void destroy(MockInterceptorInstance instance, CreationalContext<MockInterceptorInstance> creationalContext) {
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        return Collections.singleton(Object.class);
    }

    public Set<Annotation> getQualifiers() {
        return Collections.emptySet();
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    boolean hasDefaultBeanClass() {
        return MockInterceptor.class.equals(this.beanClass);
    }

    private Bean<?> getInterceptedBean(CreationalContext<MockInterceptorInstance> ctx) {
        if (!ctx.getClass().getName().startsWith("org.jboss.weld")) {
            return null;
        }
        Bean interceptedBean = null;
        try {
            Contextual interceptedContextual;
            Class<?> ctxImplClazz = ctx.getClass().getName().startsWith("org.jboss.weld.contexts") ? MockInterceptor.class.getClassLoader().loadClass("org.jboss.weld.contexts.CreationalContextImpl") : MockInterceptor.class.getClassLoader().loadClass("org.jboss.weld.context.CreationalContextImpl");
            Object parentContext = ctxImplClazz.getMethod("getParentCreationalContext", new Class[0]).invoke(ctx, new Object[0]);
            if (parentContext != null && (interceptedContextual = (Contextual)ctxImplClazz.getMethod("getContextual", new Class[0]).invoke(parentContext, new Object[0])) instanceof Bean) {
                interceptedBean = (Bean)interceptedContextual;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return interceptedBean;
    }

    @FunctionalInterface
    public static interface InterceptionCallback {
        @SuppressFBWarnings(value={"THROWS_METHOD_THROWS_CLAUSE_BASIC_EXCEPTION"}, justification="Method follows expectations from interceptors specs")
        public Object invoke(InvocationContext var1, Bean<?> var2) throws Exception;
    }

    public static class Builder {
        private Set<Annotation> bindings = new HashSet<Annotation>();
        private InterceptionType type;
        private InterceptionCallback callback;
        private Class<?> beanClass;

        Builder bindings(Annotation ... bindings) {
            this.bindings.clear();
            Collections.addAll(this.bindings, bindings);
            return this;
        }

        public Builder type(InterceptionType type) {
            this.type = type;
            return this;
        }

        public Builder beanClass(Class<?> beanClass) {
            this.beanClass = beanClass;
            return this;
        }

        public Builder callback(InterceptionCallback callback) {
            this.callback = callback;
            return this;
        }

        public MockInterceptor aroundInvoke(InterceptionCallback callback) {
            return this.type(InterceptionType.AROUND_INVOKE).callback(callback).build();
        }

        public MockInterceptor aroundConstruct(InterceptionCallback callback) {
            return this.type(InterceptionType.AROUND_CONSTRUCT).callback(callback).build();
        }

        public MockInterceptor postConstruct(InterceptionCallback callback) {
            return this.type(InterceptionType.POST_CONSTRUCT).callback(callback).build();
        }

        public MockInterceptor preDestroy(InterceptionCallback callback) {
            return this.type(InterceptionType.PRE_DESTROY).callback(callback).build();
        }

        public MockInterceptor build() {
            if (this.type == null) {
                throw new IllegalStateException("Interception type not set");
            }
            if (this.callback == null) {
                throw new IllegalStateException("Interception callback not set");
            }
            if (this.bindings.isEmpty()) {
                throw new IllegalStateException("No interceptor bindings specified");
            }
            return new MockInterceptor(this.beanClass != null ? this.beanClass : MockInterceptor.class, this.type, this.callback, this.bindings);
        }
    }

    public static class MockInterceptorInstance
    implements Serializable {
        private static final long serialVersionUID = -1623826535751475203L;
        private final SerializableForwardingBean<?> interceptedBean;

        MockInterceptorInstance(Bean<?> interceptedBean, String contextId) {
            this.interceptedBean = interceptedBean != null ? SerializableForwardingBean.of((String)contextId, interceptedBean) : null;
        }

        public Bean<?> getInterceptedBean() {
            return this.interceptedBean;
        }
    }
}

