/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit;

import jakarta.annotation.Resource;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;
import org.jboss.weld.util.collections.ImmutableMap;

public class MockResourceInjectionServices
implements ResourceInjectionServices {
    private static final String RESOURCE_LOOKUP_PREFIX = "java:comp/env";
    private final Map<String, Object> resources;

    public MockResourceInjectionServices(Map<String, Object> resources) {
        this.resources = ImmutableMap.copyOf(resources);
    }

    private Object resolveResource(InjectionPoint injectionPoint) {
        Resource resource = this.getResourceAnnotation(injectionPoint);
        if (resource == null) {
            throw new IllegalArgumentException("No @Resource annotation found on " + String.valueOf(injectionPoint));
        }
        if (injectionPoint.getMember() instanceof Method && ((Method)injectionPoint.getMember()).getParameterTypes().length != 1) {
            throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) " + String.valueOf(injectionPoint));
        }
        String name = !resource.lookup().equals("") ? resource.lookup() : this.getResourceName(injectionPoint);
        return this.resources.get(name);
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(final InjectionPoint injectionPoint) {
        return new ResourceReferenceFactory<Object>(){

            public ResourceReference<Object> createResource() {
                return new SimpleResourceReference(MockResourceInjectionServices.this.resolveResource(injectionPoint));
            }
        };
    }

    public ResourceReferenceFactory<Object> registerResourceInjectionPoint(String jndiName, String mappedName) {
        throw new UnsupportedOperationException();
    }

    public void cleanup() {
    }

    private String getResourceName(InjectionPoint injectionPoint) {
        String propertyName;
        Resource resource = this.getResourceAnnotation(injectionPoint);
        String mappedName = resource.mappedName();
        if (!mappedName.equals("")) {
            return mappedName;
        }
        String name = resource.name();
        if (!name.equals("")) {
            return "java:comp/env/" + name;
        }
        if (injectionPoint.getMember() instanceof Field) {
            propertyName = injectionPoint.getMember().getName();
        } else if (injectionPoint.getMember() instanceof Method) {
            propertyName = MockResourceInjectionServices.getPropertyName((Method)injectionPoint.getMember());
            if (propertyName == null) {
                throw new IllegalArgumentException("Injection point represents a method which doesn't follow JavaBean conventions (unable to determine property name) " + String.valueOf(injectionPoint));
            }
        } else {
            throw new AssertionError((Object)("Unable to inject into " + String.valueOf(injectionPoint)));
        }
        String className = injectionPoint.getMember().getDeclaringClass().getName();
        return "java:comp/env/" + className + "/" + propertyName;
    }

    private Resource getResourceAnnotation(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        if (annotated instanceof AnnotatedParameter) {
            annotated = ((AnnotatedParameter)annotated).getDeclaringCallable();
        }
        return (Resource)annotated.getAnnotation(Resource.class);
    }

    private static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }
}

