/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit5;

import jakarta.enterprise.inject.spi.BeanManager;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.inject.WeldInstance;
import org.jboss.weld.junit5.ExplicitParamInjection;
import org.jboss.weld.junit5.ExtensionContextUtils;
import org.jboss.weld.junit5.WeldInitiator;
import org.jboss.weld.junit5.WeldJunitEnricher;
import org.jboss.weld.junit5.WeldSetup;
import org.jboss.weld.util.collections.ImmutableList;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class WeldJunit5Extension
implements AfterAllCallback,
BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    public static final String GLOBAL_EXPLICIT_PARAM_INJECTION = "org.jboss.weld.junit5.explicitParamInjection";

    private static void storeExplicitParamResolutionInformation(ExtensionContext ec) {
        boolean globalSettings = Boolean.parseBoolean(System.getProperty(GLOBAL_EXPLICIT_PARAM_INJECTION, "false"));
        if (globalSettings) {
            ExtensionContextUtils.setExplicitInjectionInfoToStore(ec, true);
            return;
        }
        for (Annotation annotation : ec.getRequiredTestClass().getAnnotations()) {
            if (!annotation.annotationType().equals(ExplicitParamInjection.class)) continue;
            ExtensionContextUtils.setExplicitInjectionInfoToStore(ec, true);
            break;
        }
    }

    public void afterAll(ExtensionContext context) {
        WeldInitiator initiator;
        if (this.determineTestLifecycle(context).equals((Object)TestInstance.Lifecycle.PER_CLASS) && (initiator = ExtensionContextUtils.getInitiatorFromStore(context)) != null) {
            initiator.shutdownWeld();
        }
    }

    public void beforeAll(ExtensionContext context) {
        if (ExtensionContextUtils.getEnrichersFromStore(context) == null) {
            ImmutableList.Builder enrichers = ImmutableList.builder();
            ServiceLoader.load(WeldJunitEnricher.class).forEach(arg_0 -> ((ImmutableList.Builder)enrichers).add(arg_0));
            ExtensionContextUtils.setEnrichersToStore(context, enrichers.build());
        }
        this.startWeldContainerIfAppropriate(TestInstance.Lifecycle.PER_CLASS, context);
    }

    public void afterEach(ExtensionContext context) {
        WeldInitiator initiator;
        if (this.determineTestLifecycle(context).equals((Object)TestInstance.Lifecycle.PER_METHOD) && (initiator = ExtensionContextUtils.getInitiatorFromStore(context)) != null) {
            initiator.shutdownWeld();
        }
    }

    protected void weldInit(ExtensionContext context, Weld weld, WeldInitiator.Builder weldInitiatorBuilder) {
        weld.addPackage(false, context.getRequiredTestClass());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (ExtensionContextUtils.getContainerFromStore(extensionContext) != null) {
            List<Annotation> qualifiers = this.resolveQualifiers(parameterContext, ExtensionContextUtils.getContainerFromStore(extensionContext).getBeanManager());
            return ExtensionContextUtils.getContainerFromStore(extensionContext).select(parameterContext.getParameter().getType(), qualifiers.toArray(new Annotation[qualifiers.size()])).get();
        }
        return null;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (ExtensionContextUtils.getContainerFromStore(extensionContext) == null || !(parameterContext.getDeclaringExecutable() instanceof Method)) {
            return false;
        }
        List<Annotation> qualifiers = this.resolveQualifiers(parameterContext, ExtensionContextUtils.getContainerFromStore(extensionContext).getBeanManager());
        if ((ExtensionContextUtils.getExplicitInjectionInfoFromStore(extensionContext).booleanValue() || this.methodRequiresExplicitParamInjection(parameterContext)) && qualifiers.isEmpty()) {
            return false;
        }
        WeldInstance select = ExtensionContextUtils.getContainerFromStore(extensionContext).select(parameterContext.getParameter().getType(), qualifiers.toArray(new Annotation[qualifiers.size()]));
        if (!select.isResolvable()) {
            throw new ParameterResolutionException(String.format("Weld has failed to resolve test parameter [%s] in method [%s].%n%s dependency has type %s and qualifiers %s.", parameterContext.getParameter(), parameterContext.getDeclaringExecutable().toGenericString(), select.isAmbiguous() ? "Ambiguous" : "Unsatisfied", parameterContext.getParameter().getType().getName(), qualifiers));
        }
        return true;
    }

    private List<Annotation> resolveQualifiers(ParameterContext pc, BeanManager bm) {
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        if (pc.getParameter().getAnnotations().length == 0) {
            return Collections.emptyList();
        }
        for (Annotation annotation : pc.getParameter().getAnnotations()) {
            if (!bm.isQualifier(annotation.annotationType())) continue;
            qualifiers.add(annotation);
        }
        return qualifiers;
    }

    private boolean methodRequiresExplicitParamInjection(ParameterContext pc) {
        for (Annotation annotation : pc.getDeclaringExecutable().getAnnotations()) {
            if (!annotation.annotationType().equals(ExplicitParamInjection.class)) continue;
            return true;
        }
        return false;
    }

    private TestInstance.Lifecycle determineTestLifecycle(ExtensionContext ec) {
        TestInstance annotation = ec.getRequiredTestClass().getAnnotation(TestInstance.class);
        if (annotation != null) {
            return annotation.value();
        }
        return TestInstance.Lifecycle.PER_METHOD;
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.startWeldContainerIfAppropriate(TestInstance.Lifecycle.PER_METHOD, extensionContext);
    }

    private void startWeldContainerIfAppropriate(TestInstance.Lifecycle expectedLifecycle, ExtensionContext context) {
        if (this.determineTestLifecycle(context).equals((Object)expectedLifecycle)) {
            Object testInstance = context.getRequiredTestInstance();
            WeldJunit5Extension.storeExplicitParamResolutionInformation(context);
            ArrayList allTestInstances = new ArrayList(context.getRequiredTestInstances().getAllInstances());
            Collections.reverse(allTestInstances);
            WeldInitiator initiator = allTestInstances.stream().map(this::findInitiatorInInstance).filter(Objects::nonNull).findFirst().orElseGet(() -> this.getDefaultInitiator(context, testInstance));
            ExtensionContextUtils.setInitiatorToStore(context, initiator);
            initiator.addObjectsToInjectInto(new HashSet<Object>(allTestInstances));
            ExtensionContextUtils.setContainerToStore(context, initiator.initWeld(testInstance));
        }
    }

    private WeldInitiator findInitiatorInInstance(Object testInstance) {
        ArrayList<Field> foundInitiatorFields = new ArrayList<Field>();
        WeldInitiator initiator = null;
        for (Class<?> clazz = testInstance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                Object fieldInstance;
                if (!field.isAnnotationPresent(WeldSetup.class)) continue;
                try {
                    fieldInstance = field.get(testInstance);
                }
                catch (IllegalAccessException e) {
                    AccessController.doPrivileged(() -> {
                        field.setAccessible(true);
                        return null;
                    });
                    try {
                        fieldInstance = field.get(testInstance);
                    }
                    catch (IllegalAccessException e2) {
                        throw new AssertionError();
                    }
                }
                if (fieldInstance instanceof WeldInitiator) {
                    initiator = (WeldInitiator)((Object)fieldInstance);
                    foundInitiatorFields.add(field);
                    continue;
                }
                throw new IllegalStateException("@WeldSetup annotation should only be used on a field with a WeldInitiator value but was found on field " + field.getName() + "with a " + (Serializable)(fieldInstance == null ? "null" : fieldInstance.getClass()) + " value which is declared in class " + field.getDeclaringClass());
            }
        }
        if (foundInitiatorFields.isEmpty()) {
            return null;
        }
        this.validateInitiator(foundInitiatorFields);
        if (foundInitiatorFields.size() > 1) {
            String msg = foundInitiatorFields.stream().map(f -> "Field '" + f.getName() + "' with type " + f.getType() + " which is declared in " + f.getDeclaringClass()).collect(Collectors.joining("\n", "Multiple @WeldSetup annotated fields found, only one is allowed! Fields found:\n", ""));
            throw new IllegalStateException(msg);
        }
        return initiator;
    }

    private WeldInitiator getDefaultInitiator(ExtensionContext context, Object testInstance) {
        Weld weld = WeldInitiator.createWeld();
        WeldInitiator.Builder builder = WeldInitiator.from(weld);
        this.weldInit(context, weld, builder);
        for (WeldJunitEnricher enricher : ExtensionContextUtils.getEnrichersFromStore(context)) {
            String property = System.getProperty(enricher.getClass().getName());
            if (property != null && !Boolean.parseBoolean(property)) continue;
            enricher.enrich(testInstance, context, weld, builder);
        }
        return (WeldInitiator)builder.build();
    }

    protected void validateInitiator(List<Field> foundInitiatorFields) {
    }
}

