/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.weld.lite.extension.translator.ExtensionInvoker;
import org.jboss.weld.lite.extension.translator.ExtensionMethodParameterType;
import org.jboss.weld.lite.extension.translator.ExtensionPhase;
import org.jboss.weld.lite.extension.translator.MessagesImpl;
import org.jboss.weld.lite.extension.translator.SharedErrors;

abstract class ExtensionPhaseBase {
    private final ExtensionPhase phase;
    final BeanManager beanManager;
    final ExtensionInvoker util;
    final SharedErrors errors;

    ExtensionPhaseBase(ExtensionPhase phase, BeanManager beanManager, ExtensionInvoker util, SharedErrors errors) {
        this.phase = phase;
        this.beanManager = beanManager;
        this.util = util;
        this.errors = errors;
    }

    final void run() {
        try {
            List<Method> extensionMethods = this.util.findExtensionMethods(this.phase.annotation);
            for (Method method : extensionMethods) {
                this.runExtensionMethod(method);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void runExtensionMethod(Method method) throws ReflectiveOperationException {
        int numParameters = method.getParameterCount();
        ArrayList<ExtensionMethodParameterType> parameters = new ArrayList<ExtensionMethodParameterType>(numParameters);
        for (int i = 0; i < numParameters; ++i) {
            Class<?> parameterType = method.getParameterTypes()[i];
            ExtensionMethodParameterType parameter = ExtensionMethodParameterType.of(parameterType);
            parameters.add(parameter);
            parameter.verifyAvailable(this.phase, method);
        }
        ArrayList<Object> arguments = new ArrayList<Object>(numParameters);
        for (ExtensionMethodParameterType parameter : parameters) {
            Object argument = this.argumentForExtensionMethod(parameter, method);
            arguments.add(argument);
        }
        this.util.callExtensionMethod(method, arguments);
    }

    Object argumentForExtensionMethod(ExtensionMethodParameterType type, Method method) {
        if (type == ExtensionMethodParameterType.MESSAGES) {
            return new MessagesImpl(method, this.errors);
        }
        throw new IllegalArgumentException("internal error, " + type + " parameter declared at " + method.getDeclaringClass().getSimpleName() + "." + method.getName());
    }
}

