/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.build.compatible.spi.Parameters;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticBeanCreator;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticBeanDisposer;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticObserver;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.jboss.weld.lite.extension.translator.BeanManagerAccess;
import org.jboss.weld.lite.extension.translator.ExtensionInvoker;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseDiscovery;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseEnhancement;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseEnhancementAction;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseRegistration;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseRegistrationAction;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseSynthesis;
import org.jboss.weld.lite.extension.translator.ExtensionPhaseValidation;
import org.jboss.weld.lite.extension.translator.MetaAnnotationsImpl;
import org.jboss.weld.lite.extension.translator.ParametersImpl;
import org.jboss.weld.lite.extension.translator.SharedErrors;
import org.jboss.weld.lite.extension.translator.SyntheticBeanBuilderImpl;
import org.jboss.weld.lite.extension.translator.SyntheticObserverBuilderImpl;

public class LiteExtensionTranslator
implements Extension {
    private final ExtensionInvoker util = new ExtensionInvoker();
    private final SharedErrors errors = new SharedErrors();
    private final List<Class<? extends AlterableContext>> contextsToRegister = new ArrayList<Class<? extends AlterableContext>>();
    private final List<ExtensionPhaseEnhancementAction> enhancementActions = new ArrayList<ExtensionPhaseEnhancementAction>();
    private final List<ExtensionPhaseRegistrationAction> registrationActions = new ArrayList<ExtensionPhaseRegistrationAction>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discovery(@Priority(value=0x7FFFFFFF) @Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        try {
            BeanManagerAccess.set(bm);
            ArrayList stereotypes = new ArrayList();
            ArrayList<MetaAnnotationsImpl.ContextData> contexts = new ArrayList<MetaAnnotationsImpl.ContextData>();
            new ExtensionPhaseDiscovery(bm, this.util, this.errors, bbd, stereotypes, contexts).run();
            for (MetaAnnotationsImpl.StereotypeConfigurator stereotypeConfigurator : stereotypes) {
                bbd.addStereotype(stereotypeConfigurator.annotation, stereotypeConfigurator.annotations.toArray(new Annotation[0]));
            }
            for (MetaAnnotationsImpl.ContextData contextData : contexts) {
                boolean isPassivating;
                boolean isNormal;
                Class scopeAnnotation = contextData.scopeAnnotation;
                if (scopeAnnotation == null) {
                    try {
                        scopeAnnotation = contextData.contextClass.newInstance().getScope();
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (contextData.isNormal != null) {
                    isNormal = contextData.isNormal;
                    isPassivating = false;
                } else {
                    NormalScope normalScope = scopeAnnotation.getAnnotation(NormalScope.class);
                    if (normalScope != null) {
                        isNormal = true;
                        isPassivating = normalScope.passivating();
                    } else {
                        isNormal = false;
                        isPassivating = false;
                    }
                }
                bbd.addScope(scopeAnnotation, isNormal, isPassivating);
                Class<? extends AlterableContext> contextClass = contextData.contextClass;
                this.contextsToRegister.add(contextClass);
            }
            new ExtensionPhaseEnhancement(bm, this.util, this.errors, this.enhancementActions).run();
        }
        finally {
            BeanManagerAccess.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enhancement(@Priority(value=0x7FFFFFFF) @Observes ProcessAnnotatedType<?> pat, BeanManager bm) {
        try {
            BeanManagerAccess.set(bm);
            for (ExtensionPhaseEnhancementAction enhancementAction : this.enhancementActions) {
                enhancementAction.run(pat);
            }
        }
        finally {
            BeanManagerAccess.remove();
        }
    }

    public void registration(@Priority(value=0x7FFFFFFF) @Observes AfterTypeDiscovery atd, BeanManager bm) {
        try {
            BeanManagerAccess.set(bm);
            new ExtensionPhaseRegistration(bm, this.util, this.errors, this.registrationActions).run();
        }
        finally {
            BeanManagerAccess.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectBeans(@Priority(value=0x7FFFFFFF) @Observes ProcessBean<?> pb, BeanManager bm) {
        try {
            BeanManagerAccess.set(bm);
            for (ExtensionPhaseRegistrationAction registrationAction : this.registrationActions) {
                registrationAction.run(pb);
            }
        }
        finally {
            BeanManagerAccess.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectObservers(@Priority(value=0x7FFFFFFF) @Observes ProcessObserverMethod<?, ?> pom, BeanManager bm) {
        try {
            BeanManagerAccess.set(bm);
            for (ExtensionPhaseRegistrationAction registrationAction : this.registrationActions) {
                registrationAction.run(pom);
            }
        }
        finally {
            BeanManagerAccess.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synthesis(@Priority(value=0x7FFFFFFF) @Observes AfterBeanDiscovery abd, BeanManager bm) throws IllegalAccessException, InstantiationException {
        try {
            BeanConfigurator configurator;
            BeanManagerAccess.set(bm);
            for (Class<? extends AlterableContext> contextClass : this.contextsToRegister) {
                abd.addContext((Context)contextClass.newInstance());
            }
            ArrayList syntheticBeans = new ArrayList();
            ArrayList syntheticObservers = new ArrayList();
            new ExtensionPhaseSynthesis(bm, this.util, this.errors, syntheticBeans, syntheticObservers).run();
            for (SyntheticBeanBuilderImpl syntheticBeanBuilderImpl : syntheticBeans) {
                configurator = abd.addBean();
                configurator.beanClass(syntheticBeanBuilderImpl.implementationClass);
                configurator.types(syntheticBeanBuilderImpl.types);
                configurator.qualifiers(syntheticBeanBuilderImpl.qualifiers);
                if (syntheticBeanBuilderImpl.scope != null) {
                    configurator.scope(syntheticBeanBuilderImpl.scope);
                }
                configurator.alternative(syntheticBeanBuilderImpl.isAlternative);
                configurator.priority(syntheticBeanBuilderImpl.priority);
                configurator.name(syntheticBeanBuilderImpl.name);
                configurator.stereotypes(syntheticBeanBuilderImpl.stereotypes);
                configurator.produceWith(lookup -> {
                    try {
                        SyntheticBeanCreator creator = syntheticBean.creatorClass.newInstance();
                        return creator.create(lookup, (Parameters)new ParametersImpl(syntheticBean.params));
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                });
                if (syntheticBeanBuilderImpl.disposerClass == null) continue;
                configurator.disposeWith((object, lookup) -> {
                    try {
                        SyntheticBeanDisposer disposer = syntheticBean.disposerClass.newInstance();
                        disposer.dispose(object, lookup, (Parameters)new ParametersImpl(syntheticBean.params));
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            for (SyntheticObserverBuilderImpl syntheticObserverBuilderImpl : syntheticObservers) {
                configurator = abd.addObserverMethod();
                configurator.beanClass(syntheticObserverBuilderImpl.declaringClass);
                configurator.observedType(syntheticObserverBuilderImpl.eventType);
                configurator.qualifiers(syntheticObserverBuilderImpl.qualifiers);
                configurator.priority(syntheticObserverBuilderImpl.priority);
                configurator.async(syntheticObserverBuilderImpl.isAsync);
                configurator.reception(syntheticObserverBuilderImpl.reception);
                configurator.transactionPhase(syntheticObserverBuilderImpl.transactionPhase);
                configurator.notifyWith(eventContext -> {
                    SyntheticObserver observer = syntheticObserver.observerClass.newInstance();
                    observer.observe(eventContext, (Parameters)new ParametersImpl(syntheticObserver.params));
                });
            }
        }
        finally {
            BeanManagerAccess.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validation(@Priority(value=0x7FFFFFFF) @Observes AfterDeploymentValidation adv, BeanManager bm) {
        try {
            BeanManagerAccess.set(bm);
            new ExtensionPhaseValidation(bm, this.util, this.errors).run();
            for (Throwable error : this.errors.list) {
                adv.addDeploymentProblem(error);
            }
        }
        finally {
            this.util.clear();
            this.errors.list.clear();
            this.contextsToRegister.clear();
            this.enhancementActions.clear();
            this.registrationActions.clear();
            BeanManagerAccess.remove();
        }
    }
}

