/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.Messages;
import jakarta.enterprise.inject.build.compatible.spi.ObserverInfo;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.lang.model.AnnotationTarget;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import org.jboss.weld.lite.extension.translator.SharedErrors;

class MessagesImpl
implements Messages {
    private final String AT = " at ";
    private final SharedErrors errors;
    private final Logger logger;

    MessagesImpl(Method method, SharedErrors errors) {
        this.errors = errors;
        this.logger = Logger.getLogger(method.getDeclaringClass().getName());
    }

    public void info(String message) {
        this.logger.info(message);
    }

    public void info(String message, AnnotationTarget relatedTo) {
        this.logger.info(message + " at " + relatedTo);
    }

    public void info(String message, BeanInfo relatedTo) {
        this.logger.info(message + " at " + relatedTo);
    }

    public void info(String message, ObserverInfo relatedTo) {
        this.logger.info(message + " at " + relatedTo);
    }

    public void warn(String message) {
        this.logger.warning(message);
    }

    public void warn(String message, AnnotationTarget relatedTo) {
        this.logger.warning(message + " at " + relatedTo);
    }

    public void warn(String message, BeanInfo relatedTo) {
        this.logger.warning(message + " at " + relatedTo);
    }

    public void warn(String message, ObserverInfo relatedTo) {
        this.logger.warning(message + " at " + relatedTo);
    }

    public void error(String message) {
        this.logger.severe(message);
        this.errors.list.add((Throwable)new DeploymentException(message));
    }

    public void error(String message, AnnotationTarget relatedTo) {
        this.logger.severe(message + " at " + relatedTo);
        this.errors.list.add((Throwable)new DeploymentException(message + " at " + relatedTo));
    }

    public void error(String message, BeanInfo relatedTo) {
        this.logger.severe(message + " at " + relatedTo);
        this.errors.list.add((Throwable)new DeploymentException(message + " at " + relatedTo));
    }

    public void error(String message, ObserverInfo relatedTo) {
        this.logger.severe(message + " at " + relatedTo);
        this.errors.list.add((Throwable)new DeploymentException(message + " at " + relatedTo));
    }

    public void error(Exception exception) {
        this.errors.list.add(exception);
    }
}

