/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.annotation.Priority;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.ClassConfig;
import jakarta.enterprise.inject.build.compatible.spi.FieldConfig;
import jakarta.enterprise.inject.build.compatible.spi.Messages;
import jakarta.enterprise.inject.build.compatible.spi.MetaAnnotations;
import jakarta.enterprise.inject.build.compatible.spi.MethodConfig;
import jakarta.enterprise.inject.build.compatible.spi.ObserverInfo;
import jakarta.enterprise.inject.build.compatible.spi.ScannedClasses;
import jakarta.enterprise.inject.build.compatible.spi.SkipIfPortableExtensionPresent;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.inject.build.compatible.spi.Types;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.SecurityActions;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;

class ExtensionInvoker {
    private static final int DEFAULT_PRIORITY = 2500;
    private final Map<String, Class<?>> extensionClasses = new HashMap();
    private final Map<Class<?>, Object> extensionClassInstances = new HashMap();

    ExtensionInvoker(Collection<Class<? extends BuildCompatibleExtension>> extensions) {
        for (Class<? extends BuildCompatibleExtension> extensionClass : extensions) {
            SkipIfPortableExtensionPresent skip = extensionClass.getAnnotation(SkipIfPortableExtensionPresent.class);
            if (skip != null) continue;
            try {
                BuildCompatibleExtension extensionInstance = SecurityActions.getConstructor(extensionClass).newInstance(new Object[0]);
                this.extensionClasses.put(extensionClass.getName(), extensionClass);
                this.extensionClassInstances.put(extensionClass, extensionInstance);
            }
            catch (ReflectiveOperationException e) {
                throw LiteExtensionTranslatorLogger.LOG.unableToInstantiateObject(extensionClass, e.toString());
            }
        }
    }

    List<Method> findExtensionMethods(Class<? extends Annotation> annotation) {
        return this.extensionClasses.values().stream().flatMap(it -> Arrays.stream(it.getDeclaredMethods())).filter(it -> it.getAnnotation(annotation) != null).sorted((m1, m2) -> {
            int p2;
            if (m1.equals(m2)) {
                return 0;
            }
            int p1 = this.getExtensionMethodPriority((Method)m1);
            return p1 < (p2 = this.getExtensionMethodPriority((Method)m2)) ? -1 : 1;
        }).collect(Collectors.toList());
    }

    private int getExtensionMethodPriority(Method method) {
        Priority priority = method.getAnnotation(Priority.class);
        if (priority != null) {
            return priority.value();
        }
        return 2500;
    }

    void callExtensionMethod(Method method, List<Object> arguments) throws ReflectiveOperationException {
        Class[] parameterTypes = new Class[arguments.size()];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object argument = arguments.get(i);
            Class<?> argumentClass = argument.getClass();
            if (ClassInfo.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = ClassInfo.class;
                continue;
            }
            if (MethodInfo.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = MethodInfo.class;
                continue;
            }
            if (FieldInfo.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = FieldInfo.class;
                continue;
            }
            if (ScannedClasses.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = ScannedClasses.class;
                continue;
            }
            if (MetaAnnotations.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = MetaAnnotations.class;
                continue;
            }
            if (ClassConfig.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = ClassConfig.class;
                continue;
            }
            if (MethodConfig.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = MethodConfig.class;
                continue;
            }
            if (FieldConfig.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = FieldConfig.class;
                continue;
            }
            if (BeanInfo.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = BeanInfo.class;
                continue;
            }
            if (ObserverInfo.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = ObserverInfo.class;
                continue;
            }
            if (SyntheticComponents.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = SyntheticComponents.class;
                continue;
            }
            if (Messages.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = Messages.class;
                continue;
            }
            if (Types.class.isAssignableFrom(argumentClass)) {
                parameterTypes[i] = Types.class;
                continue;
            }
            throw LiteExtensionTranslatorLogger.LOG.unexpectedMethodArgument(argument);
        }
        Class<?> extensionClass = this.extensionClasses.get(method.getDeclaringClass().getName());
        Object extensionClassInstance = this.extensionClassInstances.get(extensionClass);
        method.invoke(extensionClassInstance, arguments.toArray());
    }

    void clear() {
        this.extensionClasses.clear();
        this.extensionClassInstances.clear();
    }
}

