/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.weld.context.SerializableContextual;
import org.jboss.weld.ejb.spi.InterceptorBindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorBindingsAdapter
implements InterceptorBindings {
    private InterceptionModel<Class<?>, SerializableContextual<Interceptor<?>, ?>> interceptionModel;

    public InterceptorBindingsAdapter(InterceptionModel<Class<?>, SerializableContextual<Interceptor<?>, ?>> interceptionModel) {
        if (interceptionModel == null) {
            throw new IllegalArgumentException("Interception model must not be null");
        }
        this.interceptionModel = interceptionModel;
    }

    @Override
    public Collection<Interceptor<?>> getAllInterceptors() {
        Set contextualSet = this.interceptionModel.getAllInterceptors();
        return this.toInterceptorList(contextualSet);
    }

    @Override
    public List<Interceptor<?>> getMethodInterceptors(javax.enterprise.inject.spi.InterceptionType interceptionType, Method method) {
        if (interceptionType == null) {
            throw new IllegalArgumentException("InterceptionType must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("Method must not be null");
        }
        InterceptionType internalInterceptionType = InterceptionType.valueOf((String)interceptionType.name());
        if (internalInterceptionType.isLifecycleCallback()) {
            throw new IllegalArgumentException("Interception type must not be lifecycle, but it is " + interceptionType.name());
        }
        return this.toInterceptorList(this.interceptionModel.getInterceptors(internalInterceptionType, method));
    }

    @Override
    public List<Interceptor<?>> getLifecycleInterceptors(javax.enterprise.inject.spi.InterceptionType interceptionType) {
        if (interceptionType == null) {
            throw new IllegalArgumentException("InterceptionType must not be null");
        }
        InterceptionType internalInterceptionType = InterceptionType.valueOf((String)interceptionType.name());
        if (!internalInterceptionType.isLifecycleCallback()) {
            throw new IllegalArgumentException("Interception type must be lifecycle, but it is " + interceptionType.name());
        }
        return this.toInterceptorList(this.interceptionModel.getInterceptors(internalInterceptionType, null));
    }

    private List<Interceptor<?>> toInterceptorList(Collection<SerializableContextual<Interceptor<?>, ?>> contextualSet) {
        ArrayList interceptors = new ArrayList();
        for (SerializableContextual<Interceptor<?>, ?> serializableContextual : contextualSet) {
            interceptors.add(serializableContextual.get());
        }
        return interceptors;
    }
}

