/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.log.Log;
import org.jboss.weld.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentInstancesStore
implements Serializable {
    private static final long serialVersionUID = -2349574791148336833L;
    private static Log log = Logging.getLog(DependentInstancesStore.class);
    private List<ContextualInstance<?>> dependentInstances = Collections.synchronizedList(new ArrayList());

    public <T> void addDependentInstance(ContextualInstance<T> contextualInstance) {
        log.trace((Object)"Registered dependent instance #0", contextualInstance);
        this.dependentInstances.add(contextualInstance);
    }

    public void destroyDependentInstances() {
        log.trace((Object)"Destroying dependent instances", new Object[0]);
        for (ContextualInstance<?> injectedInstance : this.dependentInstances) {
            DependentInstancesStore.destroy(injectedInstance);
        }
    }

    private static <T> void destroy(ContextualInstance<T> beanInstance) {
        beanInstance.getContextual().destroy(beanInstance.getInstance(), beanInstance.getCreationalContext());
    }

    public String toString() {
        return "Dependent Instances: " + this.dependentInstances;
    }
}

