/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.decorator.Decorates;
import javax.decorator.Decorator;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.Interceptor;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.model.InterceptionTypeRegistry;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.injection.spi.EjbInjectionServices;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceInjectionServices;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.log.Log;
import org.jboss.weld.log.Logging;
import org.jboss.weld.metadata.cache.BindingTypeModel;
import org.jboss.weld.metadata.cache.InterceptorBindingModel;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.persistence.PersistenceApiAbstraction;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Beans {
    private static final Log log = Logging.getLog(Beans.class);

    public static boolean isPassivatingScope(Bean<?> bean, BeanManagerImpl manager) {
        if (bean instanceof SessionBean) {
            return ((SessionBean)bean).getEjbDescriptor().isStateful();
        }
        return manager.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isPassivating();
    }

    public static boolean isPassivationCapableBean(Bean<?> bean) {
        if (bean instanceof SessionBean) {
            return ((SessionBean)bean).getEjbDescriptor().isStateful();
        }
        if (bean instanceof AbstractProducerBean) {
            return Reflections.isSerializable(((AbstractProducerBean)bean).getType());
        }
        return Reflections.isSerializable(bean.getBeanClass());
    }

    public static boolean isBeanProxyable(Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyable();
        }
        return Proxies.isTypesProxyable(bean.getTypes());
    }

    public static List<Set<FieldInjectionPoint<?, ?>>> getFieldInjectionPoints(Bean<?> declaringBean, WeldClass<?> type) {
        ArrayList injectableFieldsList = new ArrayList();
        WeldClass<?> t = type;
        while (!t.getJavaClass().equals(Object.class)) {
            HashSet fields = new HashSet();
            injectableFieldsList.add(0, fields);
            for (WeldField<?, ?> annotatedField : t.getDeclaredAnnotatedWeldFields(Inject.class)) {
                if (annotatedField.isStatic()) continue;
                Beans.addFieldInjectionPoint(annotatedField, fields, declaringBean);
            }
            for (WeldField<?, ?> annotatedField : t.getAnnotatedWeldFields(Decorates.class)) {
                if (annotatedField.isStatic()) continue;
                Beans.addFieldInjectionPoint(annotatedField, fields, declaringBean);
            }
            t = t.getWeldSuperclass();
        }
        return injectableFieldsList;
    }

    public static Set<FieldInjectionPoint<?, ?>> getFieldInjectionPoints(Bean<?> declaringBean, List<? extends Set<? extends FieldInjectionPoint<?, ?>>> fieldInjectionPoints) {
        HashSet injectionPoints = new HashSet();
        for (Set<FieldInjectionPoint<?, ?>> set : fieldInjectionPoints) {
            injectionPoints.addAll(set);
        }
        return injectionPoints;
    }

    public static WeldMethod<?, ?> getPostConstruct(WeldClass<?> type) {
        Set<WeldMethod<?, ?>> postConstructMethods = type.getAnnotatedWeldMethods(PostConstruct.class);
        log.trace((Object)("Found " + postConstructMethods + " constructors annotated with @Initializer for " + type), new Object[0]);
        if (postConstructMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one post construct method annotated with @PostConstruct for " + type);
        }
        if (postConstructMethods.size() == 1) {
            WeldMethod<?, ?> postConstruct = postConstructMethods.iterator().next();
            log.trace((Object)("Exactly one post construct method (" + postConstruct + ") for " + type), new Object[0]);
            return postConstruct;
        }
        return null;
    }

    public static WeldMethod<?, ?> getPreDestroy(WeldClass<?> type) {
        Set<WeldMethod<?, ?>> preDestroyMethods = type.getAnnotatedWeldMethods(PreDestroy.class);
        log.trace((Object)("Found " + preDestroyMethods + " constructors annotated with @Initializer for " + type), new Object[0]);
        if (preDestroyMethods.size() > 1) {
            throw new DefinitionException("Cannot have more than one pre destroy method annotated with @PreDestroy for " + type);
        }
        if (preDestroyMethods.size() == 1) {
            WeldMethod<?, ?> preDestroy = preDestroyMethods.iterator().next();
            log.trace((Object)("Exactly one post construct method (" + preDestroy + ") for " + type), new Object[0]);
            return preDestroy;
        }
        return null;
    }

    public static List<WeldMethod<?, ?>> getInterceptableBusinessMethods(WeldClass<?> type) {
        ArrayList annotatedMethods = new ArrayList();
        for (WeldMethod<?, ?> annotatedMethod : type.getWeldMethods()) {
            InterceptionType interceptionType;
            int modifiers = annotatedMethod.getJavaMember().getModifiers();
            boolean businessMethod = !annotatedMethod.isStatic() && (Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers)) && !annotatedMethod.isAnnotationPresent(Inject.class);
            if (!businessMethod) continue;
            Iterator i$ = InterceptionTypeRegistry.getSupportedInterceptionTypes().iterator();
            while (i$.hasNext() && (businessMethod = !annotatedMethod.isAnnotationPresent(InterceptionTypeRegistry.getAnnotationClass((InterceptionType)(interceptionType = (InterceptionType)i$.next()))))) {
            }
            if (!businessMethod) continue;
            annotatedMethods.add(annotatedMethod);
        }
        return annotatedMethods;
    }

    public static Set<WeldInjectionPoint<?, ?>> getEjbInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(EjbInjectionServices.class)) {
            Class<? extends Annotation> ejbAnnotationType = manager.getServices().get(EJBApiAbstraction.class).EJB_ANNOTATION_CLASS;
            HashSet ejbInjectionPoints = new HashSet();
            for (WeldField<?, ?> field : type.getAnnotatedWeldFields(ejbAnnotationType)) {
                ejbInjectionPoints.add(FieldInjectionPoint.of(declaringBean, field));
            }
            return ejbInjectionPoints;
        }
        return Collections.emptySet();
    }

    public static Set<WeldInjectionPoint<?, ?>> getPersistenceContextInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(JpaInjectionServices.class)) {
            HashSet jpaInjectionPoints = new HashSet();
            Class<? extends Annotation> persistenceContextAnnotationType = manager.getServices().get(PersistenceApiAbstraction.class).PERSISTENCE_CONTEXT_ANNOTATION_CLASS;
            for (WeldField<?, ?> field : type.getAnnotatedWeldFields(persistenceContextAnnotationType)) {
                jpaInjectionPoints.add(FieldInjectionPoint.of(declaringBean, field));
            }
            return jpaInjectionPoints;
        }
        return Collections.emptySet();
    }

    public static Set<WeldInjectionPoint<?, ?>> getPersistenceUnitInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(JpaInjectionServices.class)) {
            HashSet jpaInjectionPoints = new HashSet();
            Class<? extends Annotation> persistenceUnitAnnotationType = manager.getServices().get(PersistenceApiAbstraction.class).PERSISTENCE_UNIT_ANNOTATION_CLASS;
            for (WeldField<?, ?> field : type.getAnnotatedWeldFields(persistenceUnitAnnotationType)) {
                jpaInjectionPoints.add(FieldInjectionPoint.of(declaringBean, field));
            }
            return jpaInjectionPoints;
        }
        return Collections.emptySet();
    }

    public static Set<WeldInjectionPoint<?, ?>> getResourceInjectionPoints(Bean<?> declaringBean, WeldClass<?> type, BeanManagerImpl manager) {
        if (manager.getServices().contains(ResourceInjectionServices.class)) {
            Class<? extends Annotation> resourceAnnotationType = manager.getServices().get(EJBApiAbstraction.class).RESOURCE_ANNOTATION_CLASS;
            HashSet resourceInjectionPoints = new HashSet();
            for (WeldField<?, ?> field : type.getAnnotatedWeldFields(resourceAnnotationType)) {
                resourceInjectionPoints.add(FieldInjectionPoint.of(declaringBean, field));
            }
            return resourceInjectionPoints;
        }
        return Collections.emptySet();
    }

    public static List<Set<MethodInjectionPoint<?, ?>>> getInitializerMethods(Bean<?> declaringBean, WeldClass<?> type) {
        ArrayList initializerMethodsList = new ArrayList();
        SetMultimap<MethodSignature, Package> seenMethods = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<Package>>(){

            @Override
            public Set<Package> get() {
                return new HashSet<Package>();
            }
        });
        WeldClass<?> t = type;
        while (!t.getJavaClass().equals(Object.class)) {
            HashSet initializerMethods = new HashSet();
            initializerMethodsList.add(0, initializerMethods);
            for (WeldMethod<?, ?> method : t.getDeclaredWeldMethods()) {
                if (method.isAnnotationPresent(Inject.class) && !method.isStatic()) {
                    if (method.getAnnotation(Produces.class) != null) {
                        throw new DefinitionException("Initializer method " + method.toString() + " cannot be annotated @Produces on " + type);
                    }
                    if (method.getAnnotatedWBParameters(Disposes.class).size() > 0) {
                        throw new DefinitionException("Initializer method " + method.toString() + " cannot have parameters annotated @Disposes on " + type);
                    }
                    if (method.getAnnotatedWBParameters(Observes.class).size() > 0) {
                        throw new DefinitionException("Initializer method " + method.toString() + " cannot be annotated @Observes on " + type);
                    }
                    if (!Beans.isOverridden(method, seenMethods)) {
                        MethodInjectionPoint<?, ?> initializerMethod = MethodInjectionPoint.of(declaringBean, method);
                        initializerMethods.add(initializerMethod);
                    }
                }
                seenMethods.put(method.getSignature(), method.getPackage());
            }
            t = t.getWeldSuperclass();
        }
        return initializerMethodsList;
    }

    private static boolean isOverridden(WeldMethod<?, ?> method, Multimap<MethodSignature, Package> seenMethods) {
        if (method.isPrivate()) {
            return false;
        }
        if (method.isPackagePrivate() && seenMethods.containsKey(method.getSignature())) {
            return seenMethods.get(method.getSignature()).contains(method.getPackage());
        }
        return seenMethods.containsKey(method.getSignature());
    }

    public static Set<ParameterInjectionPoint<?, ?>> getParameterInjectionPoints(Bean<?> declaringBean, WeldConstructor<?> constructor) {
        HashSet injectionPoints = new HashSet();
        for (WeldParameter parameter : constructor.getWBParameters()) {
            injectionPoints.add(ParameterInjectionPoint.of(declaringBean, parameter));
        }
        return injectionPoints;
    }

    public static Set<ParameterInjectionPoint<?, ?>> getParameterInjectionPoints(Bean<?> declaringBean, List<Set<MethodInjectionPoint<?, ?>>> methodInjectionPoints) {
        HashSet injectionPoints = new HashSet();
        for (Set<MethodInjectionPoint<?, ?>> i : methodInjectionPoints) {
            for (MethodInjectionPoint<?, ?> method : i) {
                for (ParameterInjectionPoint<?, ?> parameter : method.getWBParameters()) {
                    injectionPoints.add(ParameterInjectionPoint.of(declaringBean, parameter));
                }
            }
        }
        return injectionPoints;
    }

    private static void addFieldInjectionPoint(WeldField<?, ?> annotatedField, Set<FieldInjectionPoint<?, ?>> injectableFields, Bean<?> declaringBean) {
        if (!annotatedField.isAnnotationPresent(Produces.class)) {
            if (annotatedField.isFinal()) {
                throw new DefinitionException("Don't place binding annotations on final fields " + annotatedField);
            }
            FieldInjectionPoint<?, ?> fieldInjectionPoint = FieldInjectionPoint.of(declaringBean, annotatedField);
            injectableFields.add(fieldInjectionPoint);
        }
    }

    public static boolean containsAllBindings(Set<Annotation> bindings1, Set<Annotation> bindings2, BeanManagerImpl manager) {
        for (Annotation binding : bindings1) {
            BindingTypeModel<? extends Annotation> bindingType = manager.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(binding.annotationType());
            boolean matchFound = false;
            for (Annotation otherBinding : bindings2) {
                if (!bindingType.isEqual(binding, otherBinding)) continue;
                matchFound = true;
            }
            if (matchFound) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAllInterceptionBindings(Set<Annotation> expectedBindings, Set<Annotation> existingBindings, BeanManagerImpl manager) {
        for (Annotation binding : expectedBindings) {
            InterceptorBindingModel bindingType = manager.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(binding.annotationType());
            boolean matchFound = false;
            for (Annotation otherBinding : existingBindings) {
                if (!bindingType.isEqual(binding, otherBinding)) continue;
                matchFound = true;
            }
            if (matchFound) continue;
            return false;
        }
        return true;
    }

    public static <T extends Bean<?>> Set<T> retainEnabledPolicies(Set<T> beans, Collection<Class<?>> enabledPolicyClasses, Collection<Class<? extends Annotation>> enabledPolicySterotypes) {
        if (beans.size() == 0) {
            return beans;
        }
        HashSet<Bean> enabledBeans = new HashSet<Bean>();
        for (Bean bean : beans) {
            if (!Beans.isBeanEnabled(bean, enabledPolicyClasses, enabledPolicySterotypes)) continue;
            enabledBeans.add(bean);
        }
        return enabledBeans;
    }

    public static boolean isBeanEnabled(Bean<?> bean, Collection<Class<?>> enabledPolicyClasses, Collection<Class<? extends Annotation>> enabledPolicySterotypes) {
        if (bean.isAlternative()) {
            if (enabledPolicyClasses.contains(bean.getBeanClass())) {
                return true;
            }
            for (Class<Annotation> stereotype : bean.getStereotypes()) {
                if (!enabledPolicySterotypes.contains(stereotype)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static <X> boolean isPolicyPresent(Set<Bean<? extends X>> beans) {
        for (Bean<X> bean : beans) {
            if (!bean.isAlternative()) continue;
            return true;
        }
        return false;
    }

    public static <X> boolean isSpecialized(Bean<? extends X> bean, Set<Bean<? extends X>> beans, Map<Contextual<?>, Contextual<?>> specializedBeans) {
        return specializedBeans.containsKey(bean) && beans.contains(specializedBeans.get(bean));
    }

    public static <T> ConstructorInjectionPoint<T> getBeanConstructor(Bean<T> declaringBean, WeldClass<T> type) {
        ConstructorInjectionPoint<T> constructor = null;
        Set<WeldConstructor<T>> initializerAnnotatedConstructors = type.getAnnotatedWeldConstructors(Inject.class);
        log.trace((Object)("Found " + initializerAnnotatedConstructors + " constructors annotated with @Initializer for " + type), new Object[0]);
        if (initializerAnnotatedConstructors.size() > 1) {
            if (initializerAnnotatedConstructors.size() > 1) {
                throw new DefinitionException("Cannot have more than one constructor annotated with @Initializer for " + type);
            }
        } else if (initializerAnnotatedConstructors.size() == 1) {
            constructor = ConstructorInjectionPoint.of(declaringBean, initializerAnnotatedConstructors.iterator().next());
            log.trace((Object)("Exactly one constructor (" + constructor + ") annotated with @Initializer defined, using it as the bean constructor for " + type), new Object[0]);
        } else if (type.getNoArgsWeldConstructor() != null) {
            constructor = ConstructorInjectionPoint.of(declaringBean, type.getNoArgsWeldConstructor());
            log.trace((Object)("Exactly one constructor (" + constructor + ") defined, using it as the bean constructor for " + type), new Object[0]);
        }
        if (constructor == null) {
            throw new DefinitionException("Cannot determine constructor to use for " + type);
        }
        return constructor;
    }

    public static <T> void injectEEFields(T beanInstance, BeanManagerImpl manager, Iterable<WeldInjectionPoint<?, ?>> ejbInjectionPoints, Iterable<WeldInjectionPoint<?, ?>> persistenceContextInjectionPoints, Iterable<WeldInjectionPoint<?, ?>> persistenceUnitInjectionPoints, Iterable<WeldInjectionPoint<?, ?>> resourceInjectionPoints) {
        EjbInjectionServices ejbServices = manager.getServices().get(EjbInjectionServices.class);
        JpaInjectionServices jpaServices = manager.getServices().get(JpaInjectionServices.class);
        ResourceInjectionServices resourceServices = manager.getServices().get(ResourceInjectionServices.class);
        if (ejbServices != null) {
            for (WeldInjectionPoint<?, ?> injectionPoint : ejbInjectionPoints) {
                Object ejbInstance = ejbServices.resolveEjb(injectionPoint);
                injectionPoint.inject(beanInstance, ejbInstance);
            }
        }
        if (jpaServices != null) {
            for (WeldInjectionPoint<?, ?> injectionPoint : persistenceContextInjectionPoints) {
                EntityManager pcInstance = jpaServices.resolvePersistenceContext(injectionPoint);
                injectionPoint.inject(beanInstance, pcInstance);
            }
            for (WeldInjectionPoint<?, ?> injectionPoint : persistenceUnitInjectionPoints) {
                EntityManagerFactory puInstance = jpaServices.resolvePersistenceUnit(injectionPoint);
                injectionPoint.inject(beanInstance, puInstance);
            }
        }
        if (resourceServices != null) {
            for (WeldInjectionPoint<?, ?> injectionPoint : resourceInjectionPoints) {
                Object resourceInstance = resourceServices.resolveResource(injectionPoint);
                injectionPoint.inject(beanInstance, resourceInstance);
            }
        }
    }

    public static Type getDeclaredBeanType(Class<? extends Bean> clazz) {
        Type[] actualTypeArguments = Reflections.getActualTypeArguments(clazz);
        if (actualTypeArguments.length == 1) {
            return actualTypeArguments[0];
        }
        return null;
    }

    public static <T> void injectBoundFields(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<? extends FieldInjectionPoint<?, ?>> injectableFields) {
        for (FieldInjectionPoint<T, T> fieldInjectionPoint : injectableFields) {
            fieldInjectionPoint.inject(instance, manager, creationalContext);
        }
    }

    public static <T> void injectFieldsAndInitializers(T instance, CreationalContext<T> ctx, BeanManagerImpl beanManager, List<? extends Iterable<? extends FieldInjectionPoint<?, ?>>> injectableFields, List<? extends Iterable<? extends MethodInjectionPoint<?, ?>>> initializerMethods) {
        if (injectableFields.size() != initializerMethods.size()) {
            throw new IllegalArgumentException("injectableFields and initializerMethods must have the same size. InjectableFields: " + injectableFields + "; InitializerMethods: " + initializerMethods);
        }
        for (int i = 0; i < injectableFields.size(); ++i) {
            Beans.injectBoundFields(instance, ctx, beanManager, injectableFields.get(i));
            Beans.callInitializers(instance, ctx, beanManager, initializerMethods.get(i));
        }
    }

    public static <T> void callInitializers(T instance, CreationalContext<T> creationalContext, BeanManagerImpl manager, Iterable<? extends MethodInjectionPoint<?, ?>> initializerMethods) {
        for (MethodInjectionPoint<T, T> methodInjectionPoint : initializerMethods) {
            methodInjectionPoint.invoke(instance, manager, creationalContext, CreationException.class);
        }
    }

    public static <T> boolean isInterceptor(WeldClass<T> annotatedItem) {
        return annotatedItem.isAnnotationPresent(Interceptor.class);
    }

    public static <T> boolean isDecorator(WeldClass<T> annotatedItem) {
        return annotatedItem.isAnnotationPresent(Decorator.class);
    }
}

