/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Names {
    private static Pattern CAPITAL_LETTERS = Pattern.compile("\\p{Upper}{1}\\p{Lower}*");

    public static String scopeTypeToString(Class<? extends Annotation> scopeType) {
        StringBuilder result = new StringBuilder();
        if (scopeType != null) {
            String scopeName = scopeType.getSimpleName();
            Matcher matcher = CAPITAL_LETTERS.matcher(scopeName);
            int i = 0;
            while (matcher.find()) {
                String name = matcher.group();
                if (i > 0) {
                    name = name.toLowerCase();
                }
                result.append(name).append(" ");
                ++i;
            }
        }
        return result.toString();
    }

    public static int count(Iterable<?> iterable) {
        int count = 0;
        Iterator<?> i = iterable.iterator();
        while (i.hasNext()) {
            ++count;
        }
        return count;
    }

    private static String listToString(List<String> list, String delimiter) {
        StringBuilder buffer = new StringBuilder();
        for (String item : list) {
            buffer.append(item);
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private static List<String> parseModifiers(int modifier) {
        ArrayList<String> modifiers = new ArrayList<String>();
        if (Modifier.isPrivate(modifier)) {
            modifiers.add("private");
        }
        if (Modifier.isProtected(modifier)) {
            modifiers.add("protected");
        }
        if (Modifier.isPublic(modifier)) {
            modifiers.add("public");
        }
        if (Modifier.isAbstract(modifier)) {
            modifiers.add("abstract");
        }
        if (Modifier.isFinal(modifier)) {
            modifiers.add("final");
        }
        if (Modifier.isNative(modifier)) {
            modifiers.add("native");
        }
        if (Modifier.isStatic(modifier)) {
            modifiers.add("static");
        }
        if (Modifier.isStrict(modifier)) {
            modifiers.add("strict");
        }
        if (Modifier.isSynchronized(modifier)) {
            modifiers.add("synchronized");
        }
        if (Modifier.isTransient(modifier)) {
            modifiers.add("transient");
        }
        if (Modifier.isVolatile(modifier)) {
            modifiers.add("volatile");
        }
        if (Modifier.isInterface(modifier)) {
            modifiers.add("interface");
        }
        return modifiers;
    }

    private static String annotationsToString(Annotation[] annotations) {
        StringBuilder buffer = new StringBuilder();
        for (Annotation annotation : annotations) {
            buffer.append("@" + annotation.annotationType().getSimpleName());
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public static String fieldToString(Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return "  Field " + Names.annotationsToString(field.getAnnotations()) + Names.listToString(Names.parseModifiers(field.getModifiers()), " ") + field.getName();
    }

    public static String methodToString(Method method) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return "  Method " + method.getReturnType().getSimpleName() + " " + Names.annotationsToString(method.getAnnotations()) + Names.listToString(Names.parseModifiers(method.getModifiers()), " ") + method.getName() + "(" + Names.parametersToString(method.getParameterTypes(), method.getParameterAnnotations(), false) + ");\n";
    }

    public static String annotationToString(Annotation annotation) {
        return "Annotation " + Names.annotationsToString(annotation.annotationType().getAnnotations()) + annotation.annotationType().getSimpleName();
    }

    public static String constructorToString(Constructor<?> constructor) {
        return "  Constructor " + Names.annotationsToString(constructor.getAnnotations()) + Names.listToString(Names.parseModifiers(constructor.getModifiers()), " ") + constructor.getDeclaringClass().getSimpleName() + "(" + Names.parametersToString(constructor.getParameterTypes(), constructor.getParameterAnnotations(), true) + ");\n";
    }

    private static String parametersToString(Class<?>[] parameterTypes, Annotation[][] annotations, boolean constructor) {
        int start;
        StringBuilder buffer = new StringBuilder();
        for (int i = start = constructor ? 1 : 0; i < parameterTypes.length; ++i) {
            if (i > start) {
                buffer.append(", ");
            }
            buffer.append(Names.annotationsToString(annotations[i]) + Names.typeToString(parameterTypes[i]));
        }
        return buffer.toString();
    }

    private static String typeToString(Class<?> clazz) {
        return Names.annotationsToString(clazz.getAnnotations()) + clazz.getSimpleName();
    }

    public static String classToString(Class<?> clazz) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Class " + Names.typeToString(clazz) + "\n");
        for (Field field : clazz.getFields()) {
            buffer.append(Names.fieldToString(field));
        }
        for (AccessibleObject accessibleObject : clazz.getConstructors()) {
            buffer.append(Names.constructorToString(accessibleObject));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            buffer.append(Names.methodToString((Method)accessibleObject));
        }
        return buffer.toString();
    }

    public static String typesToString(Set<? extends Type> types) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        buffer.append("[");
        for (Type type : types) {
            if (i > 0) {
                buffer.append(", ");
            }
            if (type instanceof Class) {
                buffer.append(((Class)type).getSimpleName());
            } else {
                buffer.append(type.toString());
            }
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static String annotationsToString(Set<Annotation> annotations) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        buffer.append("[");
        for (Annotation annotation : annotations) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append("@").append(annotation.annotationType().getSimpleName());
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }
}

