/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.UnproxyableResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.inject.Qualifier;
import org.jboss.interceptor.registry.InterceptorRegistry;
import org.jboss.weld.Container;
import org.jboss.weld.DeploymentException;
import org.jboss.weld.SimpleInjectionTarget;
import org.jboss.weld.Validator;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bean.proxy.ClientProxyProvider;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.events.AbstractProcessInjectionTarget;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.context.WeldCreationalContext;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.el.Namespace;
import org.jboss.weld.el.WeldELResolver;
import org.jboss.weld.el.WeldExpressionFactory;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.ScopeModel;
import org.jboss.weld.resolution.NameBasedResolver;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableFactory;
import org.jboss.weld.resolution.ResolvableWeldClass;
import org.jboss.weld.resolution.TypeSafeBeanResolver;
import org.jboss.weld.resolution.TypeSafeDecoratorResolver;
import org.jboss.weld.resolution.TypeSafeInterceptorResolver;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManagerImpl
implements WeldManager,
Serializable {
    private static final long serialVersionUID = 3021562879133838561L;
    public static final InjectionPoint DUMMY_INJECTION_POINT = new InjectionPoint(){

        @Override
        public boolean isTransient() {
            return true;
        }

        @Override
        public boolean isDelegate() {
            return false;
        }

        @Override
        public Type getType() {
            return InjectionPoint.class;
        }

        @Override
        public Set<Annotation> getQualifiers() {
            return Collections.emptySet();
        }

        @Override
        public Member getMember() {
            return null;
        }

        @Override
        public Bean<?> getBean() {
            return null;
        }

        @Override
        public Annotated getAnnotated() {
            return null;
        }
    };
    private final transient ServiceRegistry services;
    private final transient ListMultimap<Class<? extends Annotation>, Context> contexts;
    private final transient ClientProxyProvider clientProxyProvider;
    private final transient Map<EjbDescriptor<?>, SessionBean<?>> enterpriseBeans;
    private final transient Map<Contextual<?>, Contextual<?>> specializedBeans;
    private transient Collection<Class<?>> enabledPolicyClasses;
    private transient Collection<Class<? extends Annotation>> enabledPolicyStereotypes;
    private transient List<Class<?>> enabledDecoratorClasses;
    private transient List<Class<?>> enabledInterceptorClasses;
    private final transient Set<CurrentActivity> currentActivities;
    private final transient TypeSafeBeanResolver<Bean<?>> beanResolver;
    private final transient TypeSafeResolver<? extends Resolvable, Decorator<?>> decoratorResolver;
    private final transient TypeSafeResolver<? extends Resolvable, Interceptor<?>> interceptorResolver;
    private final transient TypeSafeResolver<? extends Resolvable, ObserverMethod<?>> observerResolver;
    private final transient NameBasedResolver nameBasedResolver;
    private final transient ELResolver weldELResolver;
    private transient Namespace rootNamespace;
    private final transient List<Bean<?>> beans;
    private final transient List<Bean<?>> transitiveBeans;
    private final transient List<Decorator<?>> decorators;
    private final transient List<Interceptor<?>> interceptors;
    private final transient List<String> namespaces;
    private final transient List<ObserverMethod<?>> observers;
    private final transient HashSet<BeanManagerImpl> accessibleManagers;
    private final transient Set<BeanManagerImpl> childActivities;
    private final AtomicInteger childIds;
    private final String id;
    private final transient ThreadLocal<Stack<InjectionPoint>> currentInjectionPoint;
    private final transient InterceptorRegistry<Class<?>, SerializableContextual<Interceptor<?>, ?>> boundInterceptorsRegistry = new InterceptorRegistry();
    private final transient InterceptorRegistry<Class<?>, Class<?>> declaredInterceptorsRegistry = new InterceptorRegistry();

    public static BeanManagerImpl newRootManager(String id, ServiceRegistry serviceRegistry) {
        ListMultimap<Class<? extends Annotation>, Context> contexts = Multimaps.newListMultimap(new ConcurrentHashMap(), new Supplier<List<Context>>(){

            @Override
            public List<Context> get() {
                return new CopyOnWriteArrayList<Context>();
            }
        });
        return new BeanManagerImpl(serviceRegistry, new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList<String>(), new ConcurrentHashMap(), new ClientProxyProvider(), contexts, new CopyOnWriteArraySet<CurrentActivity>(), new HashMap(), new ArrayList(), new ArrayList<Class<? extends Annotation>>(), new ArrayList(), new ArrayList(), id, new AtomicInteger());
    }

    public static BeanManagerImpl newManager(BeanManagerImpl rootManager, String id, ServiceRegistry services) {
        return new BeanManagerImpl(services, new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList(), new CopyOnWriteArrayList<String>(), rootManager.getEnterpriseBeans(), rootManager.getClientProxyProvider(), rootManager.getContexts(), new CopyOnWriteArraySet<CurrentActivity>(), new HashMap(), new ArrayList(), new ArrayList<Class<? extends Annotation>>(), new ArrayList(), new ArrayList(), id, new AtomicInteger());
    }

    public static BeanManagerImpl newChildActivityManager(BeanManagerImpl parentManager) {
        CopyOnWriteArrayList beans = new CopyOnWriteArrayList();
        beans.addAll(parentManager.getBeans());
        CopyOnWriteArrayList transitiveBeans = new CopyOnWriteArrayList();
        beans.addAll(parentManager.getTransitiveBeans());
        CopyOnWriteArrayList registeredObservers = new CopyOnWriteArrayList();
        registeredObservers.addAll(parentManager.getObservers());
        CopyOnWriteArrayList<String> namespaces = new CopyOnWriteArrayList<String>();
        namespaces.addAll(parentManager.getNamespaces());
        return new BeanManagerImpl(parentManager.getServices(), beans, transitiveBeans, parentManager.getDecorators(), parentManager.getInterceptors(), registeredObservers, namespaces, parentManager.getEnterpriseBeans(), parentManager.getClientProxyProvider(), parentManager.getContexts(), parentManager.getCurrentActivities(), parentManager.getSpecializedBeans(), parentManager.getEnabledPolicyClasses(), parentManager.getEnabledPolicyStereotypes(), parentManager.getEnabledDecoratorClasses(), parentManager.getEnabledInterceptorClasses(), "" + parentManager.getChildIds().incrementAndGet(), parentManager.getChildIds());
    }

    private BeanManagerImpl(ServiceRegistry serviceRegistry, List<Bean<?>> beans, List<Bean<?>> transitiveBeans, List<Decorator<?>> decorators, List<Interceptor<?>> interceptors, List<ObserverMethod<?>> observers, List<String> namespaces, Map<EjbDescriptor<?>, SessionBean<?>> enterpriseBeans, ClientProxyProvider clientProxyProvider, ListMultimap<Class<? extends Annotation>, Context> contexts, Set<CurrentActivity> currentActivities, Map<Contextual<?>, Contextual<?>> specializedBeans, Collection<Class<?>> enabledPolicyClasses, Collection<Class<? extends Annotation>> enabledPolicyStereotypes, List<Class<?>> enabledDecoratorClasses, List<Class<?>> enabledInterceptorClasses, String id, AtomicInteger childIds) {
        this.services = serviceRegistry;
        this.beans = beans;
        this.transitiveBeans = transitiveBeans;
        this.decorators = decorators;
        this.interceptors = interceptors;
        this.enterpriseBeans = enterpriseBeans;
        this.clientProxyProvider = clientProxyProvider;
        this.contexts = contexts;
        this.currentActivities = currentActivities;
        this.specializedBeans = specializedBeans;
        this.observers = observers;
        this.enabledPolicyClasses = enabledPolicyClasses;
        this.enabledPolicyStereotypes = enabledPolicyStereotypes;
        this.setEnabledDecoratorClasses(enabledDecoratorClasses);
        this.setEnabledInterceptorClasses(enabledInterceptorClasses);
        this.namespaces = namespaces;
        this.id = id;
        this.childIds = new AtomicInteger();
        this.accessibleManagers = new HashSet();
        Transform.BeanTransform beanTransform = new Transform.BeanTransform(this);
        this.beanResolver = new TypeSafeBeanResolver(this, this.createDynamicAccessibleIterable(beanTransform));
        this.decoratorResolver = new TypeSafeDecoratorResolver(this, this.createDynamicAccessibleIterable(Transform.DECORATOR_BEAN));
        this.interceptorResolver = new TypeSafeInterceptorResolver(this, this.createDynamicAccessibleIterable(Transform.INTERCEPTOR_BEAN));
        this.observerResolver = new TypeSafeObserverResolver(this, this.createDynamicAccessibleIterable(Transform.EVENT_OBSERVER));
        this.nameBasedResolver = new NameBasedResolver(this, this.createDynamicAccessibleIterable(beanTransform));
        this.weldELResolver = new WeldELResolver(this);
        this.childActivities = new CopyOnWriteArraySet<BeanManagerImpl>();
        this.currentInjectionPoint = new ThreadLocal<Stack<InjectionPoint>>(){

            @Override
            protected Stack<InjectionPoint> initialValue() {
                return new Stack<InjectionPoint>();
            }
        };
    }

    private <T> Set<Iterable<T>> buildAccessibleClosure(Collection<BeanManagerImpl> hierarchy, Transform<T> transform) {
        HashSet<Iterable<T>> result = new HashSet<Iterable<T>>();
        hierarchy.add(this);
        result.add(transform.transform(this));
        for (BeanManagerImpl beanManager : this.accessibleManagers) {
            if (hierarchy.contains(beanManager)) continue;
            result.addAll(beanManager.buildAccessibleClosure(new ArrayList<BeanManagerImpl>(hierarchy), transform));
        }
        return result;
    }

    private <T> Iterable<T> createDynamicAccessibleIterable(final Transform<T> transform) {
        return new Iterable<T>(){
            private Function<Iterable<T>, Iterator<T>> function = new Function<Iterable<T>, Iterator<T>>(){

                @Override
                public Iterator<T> apply(Iterable<T> iterable) {
                    return iterable.iterator();
                }
            };

            @Override
            public Iterator<T> iterator() {
                Set iterable = BeanManagerImpl.this.buildAccessibleClosure(new ArrayList(), transform);
                return Iterators.concat(Iterators.transform(iterable.iterator(), this.function));
            }
        };
    }

    private <T> Iterable<T> createStaticAccessibleIterable(Transform<T> transform) {
        Set<Iterable<T>> iterable = this.buildAccessibleClosure(new ArrayList<BeanManagerImpl>(), transform);
        return Iterables.concat(iterable);
    }

    public void addAccessibleBeanManager(BeanManagerImpl accessibleBeanManager) {
        this.accessibleManagers.add(accessibleBeanManager);
        this.beanResolver.clear();
    }

    public void addBean(Bean<?> bean) {
        if (this.beans.contains(bean)) {
            return;
        }
        if (bean.getClass().equals(SessionBean.class)) {
            SessionBean enterpriseBean = (SessionBean)bean;
            this.enterpriseBeans.put(enterpriseBean.getEjbDescriptor(), enterpriseBean);
        }
        if (bean instanceof PassivationCapable) {
            Container.instance().deploymentServices().get(ContextualStore.class).putIfAbsent(bean);
        }
        this.registerBeanNamespace(bean);
        for (BeanManagerImpl childActivity : this.childActivities) {
            childActivity.addBean(bean);
        }
        if (bean instanceof ExtensionBean || !(bean instanceof NewBean) && !(bean instanceof AbstractBuiltInBean)) {
            this.transitiveBeans.add(bean);
        }
        this.beans.add(bean);
        this.beanResolver.clear();
    }

    public void addDecorator(Decorator<?> bean) {
        this.decorators.add(bean);
        this.getServices().get(ContextualStore.class).putIfAbsent(bean);
        this.decoratorResolver.clear();
    }

    @Override
    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... bindings) {
        Observers.checkEventObjectType(event);
        return this.resolveObserverMethods(event.getClass(), bindings);
    }

    public void addInterceptor(Interceptor<?> bean) {
        this.interceptors.add(bean);
        this.getServices().get(ContextualStore.class).putIfAbsent(bean);
        this.interceptorResolver.clear();
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(Type eventType, Annotation ... bindings) {
        this.checkBindingTypes(Arrays.asList(bindings));
        HashSet<Annotation> bindingAnnotations = new HashSet<Annotation>(Arrays.asList(bindings));
        bindingAnnotations.add(new AnyLiteral());
        HashSet<ObserverMethod<T>> observers = new HashSet<ObserverMethod<T>>();
        Set<ObserverMethod<?>> eventObservers = this.observerResolver.resolve(ResolvableFactory.of(new Reflections.HierarchyDiscovery(eventType).getTypeClosure(), bindingAnnotations, null));
        for (ObserverMethod<?> observer : eventObservers) {
            observers.add(observer);
        }
        return observers;
    }

    private void checkBindingTypes(Collection<Annotation> bindings) {
        HashSet<Annotation> bindingAnnotations = new HashSet<Annotation>(bindings);
        for (Annotation annotation : bindings) {
            if (this.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(annotation.annotationType()).isValid()) continue;
            throw new IllegalArgumentException("Not a binding type " + annotation);
        }
        if (bindingAnnotations.size() < bindings.size()) {
            throw new IllegalArgumentException("Duplicate binding types: " + bindings);
        }
    }

    public Collection<Class<?>> getEnabledPolicyClasses() {
        return Collections.unmodifiableCollection(this.enabledPolicyClasses);
    }

    public Collection<Class<? extends Annotation>> getEnabledPolicyStereotypes() {
        return Collections.unmodifiableCollection(this.enabledPolicyStereotypes);
    }

    public boolean isBeanEnabled(Bean<?> bean) {
        return Beans.isBeanEnabled(bean, this.getEnabledPolicyClasses(), this.getEnabledPolicyStereotypes());
    }

    public List<Class<?>> getEnabledDecoratorClasses() {
        return Collections.unmodifiableList(this.enabledDecoratorClasses);
    }

    public List<Class<?>> getEnabledInterceptorClasses() {
        return Collections.unmodifiableList(this.enabledInterceptorClasses);
    }

    public void setEnabledPolicyClasses(Collection<Class<?>> enabledPolicyClasses) {
        this.enabledPolicyClasses = enabledPolicyClasses;
    }

    public void setEnabledPolicyStereotypes(Collection<Class<? extends Annotation>> enabledPolicySterotypes) {
        this.enabledPolicyStereotypes = enabledPolicySterotypes;
    }

    public void setEnabledDecoratorClasses(List<Class<?>> enabledDecoratorClasses) {
        this.enabledDecoratorClasses = enabledDecoratorClasses;
    }

    public void setEnabledInterceptorClasses(List<Class<?>> enabledInterceptorClasses) {
        this.enabledInterceptorClasses = enabledInterceptorClasses;
    }

    @Override
    public Set<Bean<?>> getBeans(Type beanType, Annotation ... bindings) {
        return this.getBeans(ResolvableWeldClass.of(beanType, bindings, this), bindings);
    }

    public Set<Bean<?>> getBeans(WeldAnnotated<?, ?> element, Annotation ... bindings) {
        for (Annotation annotation : element.getAnnotations()) {
            if (this.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(annotation.annotationType()).isValid()) continue;
            throw new IllegalArgumentException("Not a binding type " + annotation);
        }
        if (bindings != null && bindings.length > element.getMetaAnnotations(Qualifier.class).size()) {
            throw new IllegalArgumentException("Duplicate bindings (" + Arrays.asList(bindings) + ") type passed " + element.toString());
        }
        return this.beanResolver.resolve(ResolvableFactory.of(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Bean<?>> getInjectableBeans(InjectionPoint injectionPoint) {
        boolean registerInjectionPoint = !injectionPoint.getType().equals(InjectionPoint.class);
        try {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().push(injectionPoint);
            }
            Set<Bean<?>> beans = this.getBeans(ResolvableWeldClass.of(injectionPoint.getType(), injectionPoint.getQualifiers().toArray(new Annotation[0]), this), new Annotation[0]);
            HashSet injectableBeans = new HashSet();
            for (Bean<?> bean : beans) {
                if (bean instanceof Decorator || bean instanceof Interceptor) continue;
                injectableBeans.add(bean);
            }
            HashSet hashSet = injectableBeans;
            return hashSet;
        }
        finally {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().pop();
            }
        }
    }

    protected void registerBeanNamespace(Bean<?> bean) {
        if (bean.getName() != null && bean.getName().indexOf(46) > 0) {
            this.namespaces.add(bean.getName().substring(0, bean.getName().lastIndexOf(46)));
        }
    }

    public Map<EjbDescriptor<?>, SessionBean<?>> getEnterpriseBeans() {
        return this.enterpriseBeans;
    }

    public List<Bean<?>> getBeans() {
        return Collections.unmodifiableList(this.beans);
    }

    private List<Bean<?>> getTransitiveBeans() {
        return Collections.unmodifiableList(this.transitiveBeans);
    }

    public List<Decorator<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    public List<Interceptor<?>> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    public Iterable<Bean<?>> getAccessibleBeans() {
        return this.createDynamicAccessibleIterable(new Transform.BeanTransform(this));
    }

    public void addContext(Context context) {
        this.contexts.put(context.getScope(), context);
    }

    public void addObserver(ObserverMethod<?> observer) {
        this.observers.add(observer);
        for (BeanManagerImpl childActivity : this.childActivities) {
            childActivity.addObserver(observer);
        }
    }

    @Override
    public void fireEvent(Object event, Annotation ... qualifiers) {
        this.fireEvent(event.getClass(), event, qualifiers);
    }

    public void fireEvent(Type eventType, Object event, Annotation ... qualifiers) {
        Observers.checkEventObjectType(event);
        this.notifyObservers(event, this.resolveObserverMethods(eventType, qualifiers));
    }

    private <T> void notifyObservers(T event, Set<ObserverMethod<? super T>> observers) {
        for (ObserverMethod<T> observer : observers) {
            observer.notify(event);
        }
    }

    @Override
    public Context getContext(Class<? extends Annotation> scopeType) {
        ArrayList<Context> activeContexts = new ArrayList<Context>();
        for (Context context : this.contexts.get(scopeType)) {
            if (!context.isActive()) continue;
            activeContexts.add(context);
        }
        if (activeContexts.isEmpty()) {
            throw new ContextNotActiveException("No active contexts for scope type " + scopeType.getName());
        }
        if (activeContexts.size() > 1) {
            throw new IllegalStateException("More than one context active for scope type " + scopeType.getName());
        }
        return (Context)activeContexts.iterator().next();
    }

    public Object getReference(Bean<?> bean, CreationalContext<?> creationalContext) {
        bean = this.getMostSpecializedBean(bean);
        if (creationalContext instanceof WeldCreationalContext) {
            creationalContext = ((WeldCreationalContext)creationalContext).getCreationalContext(bean);
        }
        if (this.isProxyRequired(bean)) {
            if (creationalContext != null || this.getContext(bean.getScope()).get(bean) != null) {
                return this.clientProxyProvider.getClientProxy(this, bean);
            }
            return null;
        }
        return this.getContext(bean.getScope()).get(bean, creationalContext);
    }

    private boolean isProxyRequired(Bean<?> bean) {
        if (this.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isNormal()) {
            return true;
        }
        if (bean instanceof RIBean) {
            return ((RIBean)bean).isProxyRequired();
        }
        return false;
    }

    @Override
    public Object getReference(Bean<?> bean, Type beanType, CreationalContext<?> creationalContext) {
        if (!Reflections.isAssignableFrom(bean.getTypes(), beanType)) {
            throw new IllegalArgumentException("The given beanType is not a type " + beanType + " of the bean " + bean);
        }
        return this.getReference(bean, creationalContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getReference(InjectionPoint injectionPoint, Bean<?> resolvedBean, CreationalContext<?> creationalContext) {
        boolean registerInjectionPoint = injectionPoint != null && !injectionPoint.getType().equals(InjectionPoint.class);
        try {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().push(injectionPoint);
            }
            if (this.getServices().get(MetaAnnotationStore.class).getScopeModel(resolvedBean.getScope()).isNormal() && !Proxies.isTypeProxyable(injectionPoint.getType())) {
                throw new UnproxyableResolutionException("Attempting to inject an unproxyable normal scoped bean " + resolvedBean + " into " + injectionPoint);
            }
            if (creationalContext instanceof WeldCreationalContext) {
                WeldCreationalContext wbCreationalContext = (WeldCreationalContext)creationalContext;
                if (wbCreationalContext.containsIncompleteInstance(resolvedBean)) {
                    Object obj = wbCreationalContext.getIncompleteInstance(resolvedBean);
                    return obj;
                }
                Object object = this.getReference(resolvedBean, wbCreationalContext);
                return object;
            }
            Object object = this.getReference(resolvedBean, creationalContext);
            return object;
        }
        finally {
            if (registerInjectionPoint) {
                this.currentInjectionPoint.get().pop();
            }
        }
    }

    @Override
    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> creationalContext) {
        WeldAnnotated element = ResolvableWeldClass.of(injectionPoint.getType(), injectionPoint.getQualifiers().toArray(new Annotation[0]), this);
        Bean resolvedBean = this.getBean(element, element.getBindingsAsArray());
        return this.getReference(injectionPoint, resolvedBean, creationalContext);
    }

    @Deprecated
    public <T> T getInstanceByType(Class<T> beanType, Annotation ... bindings) {
        Object reference;
        Set beans = this.getBeans(beanType, bindings);
        Bean bean = this.resolve(beans);
        if (bean == null) {
            throw new UnsatisfiedResolutionException("Unable to resolve any beans. Class: " + beanType + "; Qualifiers: " + Arrays.toString(bindings));
        }
        Object instance = reference = this.getReference(bean, beanType, this.createCreationalContext((Contextual)bean));
        return (T)instance;
    }

    public <T> Bean<T> getBean(WeldAnnotated<T, ?> element, Annotation ... bindings) {
        Bean bean = this.resolve(this.getBeans(element, bindings));
        if (bean == null) {
            throw new UnsatisfiedResolutionException(element + "Unable to resolve any Managed Beans");
        }
        boolean normalScoped = this.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isNormal();
        if (normalScoped && !Beans.isBeanProxyable(bean)) {
            throw new UnproxyableResolutionException("Normal scoped bean " + bean + " is not proxyable");
        }
        return bean;
    }

    @Override
    public Set<Bean<?>> getBeans(String name) {
        return this.nameBasedResolver.resolve(name);
    }

    @Override
    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... bindings) {
        this.checkResolveDecoratorsArguments(types, Arrays.asList(bindings));
        return new ArrayList(this.decoratorResolver.resolve(ResolvableFactory.of(types, null, bindings)));
    }

    public List<Decorator<?>> resolveDecorators(Set<Type> types, Set<Annotation> bindings) {
        this.checkResolveDecoratorsArguments(types, bindings);
        return new ArrayList(this.decoratorResolver.resolve(ResolvableFactory.of(types, bindings, null)));
    }

    private void checkResolveDecoratorsArguments(Set<Type> types, Collection<Annotation> bindings) {
        if (types.isEmpty()) {
            throw new IllegalArgumentException("No decorator types were specified in the set");
        }
        this.checkBindingTypes(bindings);
    }

    @Override
    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        if (interceptorBindings.length == 0) {
            throw new IllegalArgumentException("Interceptor bindings list cannot be empty");
        }
        HashSet<Class<? extends Annotation>> uniqueInterceptorBindings = new HashSet<Class<? extends Annotation>>();
        for (Annotation interceptorBinding : interceptorBindings) {
            if (uniqueInterceptorBindings.contains(interceptorBinding.annotationType())) {
                throw new IllegalArgumentException("Duplicate interceptor binding type: " + interceptorBinding.annotationType());
            }
            if (!this.isInterceptorBinding(interceptorBinding.annotationType())) {
                throw new IllegalArgumentException("Trying to resolve interceptors with non-binding type: " + interceptorBinding.annotationType());
            }
            uniqueInterceptorBindings.add(interceptorBinding.annotationType());
        }
        return new ArrayList(this.interceptorResolver.resolve(ResolvableFactory.of(type, interceptorBindings)));
    }

    public TypeSafeBeanResolver<Bean<?>> getBeanResolver() {
        return this.beanResolver;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Manager\n");
        buffer.append("Enabled policies: " + this.getEnabledPolicyClasses() + " " + this.getEnabledPolicyStereotypes() + "\n");
        buffer.append("Registered contexts: " + this.contexts.keySet() + "\n");
        buffer.append("Registered beans: " + this.getBeans().size() + "\n");
        buffer.append("Specialized beans: " + this.specializedBeans.size() + "\n");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof BeanManagerImpl) {
            BeanManagerImpl that = (BeanManagerImpl)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public BeanManagerImpl createActivity() {
        BeanManagerImpl childActivity = BeanManagerImpl.newChildActivityManager(this);
        this.childActivities.add(childActivity);
        Container.instance().addActivity(childActivity);
        return childActivity;
    }

    @Override
    public BeanManagerImpl setCurrent(Class<? extends Annotation> scopeType) {
        if (!this.getServices().get(MetaAnnotationStore.class).getScopeModel(scopeType).isNormal()) {
            throw new IllegalArgumentException("Scope must be a normal scope type " + scopeType);
        }
        this.currentActivities.add(new CurrentActivity(this.getContext(scopeType), this));
        return this;
    }

    public BeanManagerImpl getCurrent() {
        ArrayList<CurrentActivity> activeCurrentActivities = new ArrayList<CurrentActivity>();
        for (CurrentActivity currentActivity : this.currentActivities) {
            if (!currentActivity.getContext().isActive()) continue;
            activeCurrentActivities.add(currentActivity);
        }
        if (activeCurrentActivities.size() == 0) {
            return this;
        }
        if (activeCurrentActivities.size() == 1) {
            return ((CurrentActivity)activeCurrentActivities.get(0)).getManager();
        }
        throw new IllegalStateException("More than one current activity for an active context " + this.currentActivities);
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    public InjectionPoint getCurrentInjectionPoint() {
        if (!this.currentInjectionPoint.get().empty()) {
            return this.currentInjectionPoint.get().peek();
        }
        return null;
    }

    public InjectionPoint replaceOrPushCurrentInjectionPoint(InjectionPoint injectionPoint) {
        InjectionPoint originalInjectionPoint = null;
        if (!this.currentInjectionPoint.get().empty()) {
            originalInjectionPoint = this.currentInjectionPoint.get().pop();
        }
        this.currentInjectionPoint.get().push(injectionPoint);
        return originalInjectionPoint;
    }

    public void pushDummyInjectionPoint() {
        this.currentInjectionPoint.get().push(DUMMY_INJECTION_POINT);
    }

    public void popDummyInjectionPoint() {
        if (!this.currentInjectionPoint.get().isEmpty() && DUMMY_INJECTION_POINT.equals(this.currentInjectionPoint.get().peek())) {
            this.currentInjectionPoint.get().pop();
        }
    }

    public Map<Contextual<?>, Contextual<?>> getSpecializedBeans() {
        return this.specializedBeans;
    }

    protected Object readResolve() {
        return Container.instance().activityManager(this.id);
    }

    protected ClientProxyProvider getClientProxyProvider() {
        return this.clientProxyProvider;
    }

    protected ListMultimap<Class<? extends Annotation>, Context> getContexts() {
        return this.contexts;
    }

    protected List<String> getNamespaces() {
        return this.namespaces;
    }

    public Iterable<String> getAccessibleNamespaces() {
        return this.createDynamicAccessibleIterable(Transform.NAMESPACE);
    }

    private Set<CurrentActivity> getCurrentActivities() {
        return this.currentActivities;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public AtomicInteger getChildIds() {
        return this.childIds;
    }

    public List<ObserverMethod<?>> getObservers() {
        return this.observers;
    }

    public Namespace getRootNamespace() {
        if (this.rootNamespace == null) {
            this.rootNamespace = new Namespace(this.createDynamicAccessibleIterable(Transform.NAMESPACE));
        }
        return this.rootNamespace;
    }

    @Override
    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        return new SimpleInjectionTarget<T>(this.getServices().get(ClassTransformer.class).loadClass(type), this);
    }

    @Override
    public <T> InjectionTarget<T> createInjectionTarget(EjbDescriptor<T> descriptor) {
        return ((AbstractClassBean)this.getBean((EjbDescriptor)descriptor)).getInjectionTarget();
    }

    public <X> Bean<? extends X> getMostSpecializedBean(Bean<X> bean) {
        Contextual<Object> key = bean;
        while (this.specializedBeans.containsKey(key)) {
            if (key == null) {
                System.out.println("null key " + bean);
            }
            key = this.specializedBeans.get(key);
        }
        return key;
    }

    @Override
    public void validate(InjectionPoint ij) {
        try {
            this.getServices().get(Validator.class).validateInjectionPoint(ij, this);
        }
        catch (DeploymentException e) {
            throw new InjectionException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> bindingType) {
        if (this.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(bindingType).isValid()) {
            return this.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(bindingType).getMetaAnnotations();
        }
        throw new IllegalArgumentException("Not a interception binding :" + bindingType);
    }

    @Override
    public Bean<?> getPassivationCapableBean(String id) {
        return (Bean)this.getServices().get(ContextualStore.class).getContextual(id);
    }

    @Override
    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        if (this.getServices().get(MetaAnnotationStore.class).getStereotype(stereotype).isValid()) {
            return this.getServices().get(MetaAnnotationStore.class).getStereotype(stereotype).getMetaAnnotations();
        }
        throw new IllegalArgumentException("Not a stereotype " + stereotype);
    }

    @Override
    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getBindingTypeModel(annotationType).isValid();
    }

    @Override
    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(annotationType).isValid();
    }

    @Override
    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        ScopeModel<? extends Annotation> scope = this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType);
        return scope.isValid() && scope.isNormal();
    }

    @Override
    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        ScopeModel<? extends Annotation> scope = this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType);
        return scope.isValid() && scope.isPassivating();
    }

    @Override
    public boolean isScope(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getScopeModel(annotationType).isValid();
    }

    @Override
    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return this.getServices().get(MetaAnnotationStore.class).getStereotype(annotationType).isValid();
    }

    @Override
    public ELResolver getELResolver() {
        return this.weldELResolver;
    }

    @Override
    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        return new WeldExpressionFactory(expressionFactory);
    }

    public <T> WeldCreationalContext<T> createCreationalContext(Contextual<T> contextual) {
        return new CreationalContextImpl<T>(contextual);
    }

    @Override
    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        return this.getServices().get(ClassTransformer.class).loadClass(type);
    }

    @Override
    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        Set<Bean<X>> resolvedBeans = this.beanResolver.resolve(beans);
        if (resolvedBeans.size() == 0) {
            return null;
        }
        if (resolvedBeans.size() == 1) {
            return resolvedBeans.iterator().next();
        }
        throw new AmbiguousResolutionException("Cannot resolve an ambiguous dependency between " + beans);
    }

    @Override
    public <T> EjbDescriptor<T> getEjbDescriptor(String beanName) {
        return this.getServices().get(EjbDescriptors.class).get(beanName);
    }

    public <T> SessionBean<T> getBean(EjbDescriptor<T> descriptor) {
        return this.getEnterpriseBeans().get(descriptor);
    }

    public void cleanup() {
        this.services.cleanup();
        this.currentInjectionPoint.remove();
        this.accessibleManagers.clear();
        this.beanResolver.clear();
        this.beans.clear();
        this.childActivities.clear();
        this.clientProxyProvider.clear();
        this.contexts.clear();
        this.currentActivities.clear();
        this.decoratorResolver.clear();
        this.decorators.clear();
        this.enabledDecoratorClasses.clear();
        this.enabledInterceptorClasses.clear();
        this.enabledPolicyClasses.clear();
        this.enabledPolicyStereotypes.clear();
        this.enterpriseBeans.clear();
        this.interceptorResolver.clear();
        this.interceptors.clear();
        this.nameBasedResolver.clear();
        this.namespaces.clear();
        this.observerResolver.clear();
        this.observers.clear();
        this.specializedBeans.clear();
    }

    public InterceptorRegistry<Class<?>, SerializableContextual<Interceptor<?>, ?>> getCdiInterceptorsRegistry() {
        return this.boundInterceptorsRegistry;
    }

    public InterceptorRegistry<Class<?>, Class<?>> getClassDeclaredInterceptorsRegistry() {
        return this.declaredInterceptorsRegistry;
    }

    @Override
    public <X> InjectionTarget<X> fireProcessInjectionTarget(AnnotatedType<X> annotatedType) {
        return AbstractProcessInjectionTarget.fire(this, annotatedType, this.createInjectionTarget(annotatedType));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Transform<T> {
        public static final Transform<Decorator<?>> DECORATOR_BEAN = new Transform<Decorator<?>>(){

            @Override
            public Iterable<Decorator<?>> transform(BeanManagerImpl beanManager) {
                return beanManager.getDecorators();
            }
        };
        public static final Transform<Interceptor<?>> INTERCEPTOR_BEAN = new Transform<Interceptor<?>>(){

            @Override
            public Iterable<Interceptor<?>> transform(BeanManagerImpl beanManager) {
                return beanManager.getInterceptors();
            }
        };
        public static final Transform<ObserverMethod<?>> EVENT_OBSERVER = new Transform<ObserverMethod<?>>(){

            @Override
            public Iterable<ObserverMethod<?>> transform(BeanManagerImpl beanManager) {
                return beanManager.getObservers();
            }
        };
        public static final Transform<String> NAMESPACE = new Transform<String>(){

            @Override
            public Iterable<String> transform(BeanManagerImpl beanManager) {
                return beanManager.getNamespaces();
            }
        };

        public Iterable<T> transform(BeanManagerImpl var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class BeanTransform
        implements Transform<Bean<?>> {
            private final BeanManagerImpl declaringBeanManager;

            public BeanTransform(BeanManagerImpl declaringBeanManager) {
                this.declaringBeanManager = declaringBeanManager;
            }

            @Override
            public Iterable<Bean<?>> transform(BeanManagerImpl beanManager) {
                if (beanManager.equals(this.declaringBeanManager)) {
                    return beanManager.getBeans();
                }
                return beanManager.getTransitiveBeans();
            }
        }
    }

    private static class CurrentActivity {
        private final Context context;
        private final BeanManagerImpl manager;

        public CurrentActivity(Context context, BeanManagerImpl manager) {
            this.context = context;
            this.manager = manager;
        }

        public Context getContext() {
            return this.context;
        }

        public BeanManagerImpl getManager() {
            return this.manager;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CurrentActivity) {
                return this.getContext().equals(((CurrentActivity)obj).getContext());
            }
            return false;
        }

        public int hashCode() {
            return this.getContext().hashCode();
        }

        public String toString() {
            return this.getContext() + " -> " + this.getManager();
        }
    }
}

