/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Scope;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.interceptor.model.InterceptionModelBuilder;
import org.jboss.interceptor.model.InterceptorClassMetadataImpl;
import org.jboss.interceptor.util.InterceptionUtils;
import org.jboss.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.DeploymentException;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.proxy.DecoratorProxyMethodHandler;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.context.SerializableContextualImpl;
import org.jboss.weld.context.SerializableContextualInstanceImpl;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.messages.BeanMessages;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.serialization.spi.helpers.SerializableContextualInstance;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.Reflections;
import org.jboss.weld.util.Strings;
import org.jboss.weld.util.log.Categories;
import org.jboss.weld.util.log.LoggerFactory;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Categories.BEAN);
    protected WeldClass<T> annotatedItem;
    private List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;
    private List<Decorator<?>> decorators;
    private Class<T> proxyClassForDecorators;
    private final ThreadLocal<Integer> decoratorStackPosition;
    private WeldMethod<?, ?> postConstruct;
    private WeldMethod<?, ?> preDestroy;
    private InjectionTarget<T> injectionTarget;

    protected AbstractClassBean(WeldClass<T> type, String idSuffix, BeanManagerImpl manager) {
        super(idSuffix, manager);
        this.annotatedItem = type;
        this.decoratorStackPosition = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
        this.initStereotypes();
        this.initPolicy();
        this.initInitializerMethods();
        this.initInjectableFields();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        super.initialize(environment);
        this.checkBeanImplementation();
        this.initDecorators();
        this.checkType();
        this.initProxyClassForDecoratedBean();
        if (this.isInterceptionCandidate()) {
            this.initCdiBoundInterceptors();
            this.initDirectlyDefinedInterceptors();
        }
    }

    protected void checkType() {
    }

    protected void initDecorators() {
        this.decorators = this.getManager().resolveDecorators(this.getTypes(), this.getQualifiers());
    }

    public boolean hasDecorators() {
        return this.decorators != null && this.decorators.size() > 0;
    }

    protected void initProxyClassForDecoratedBean() {
        if (this.hasDecorators()) {
            Class proxyClass;
            LinkedHashSet<Type> types = new LinkedHashSet<Type>(this.getTypes());
            types.add((Type)((Object)TargetInstanceProxy.class));
            ProxyFactory proxyFactory = Proxies.getProxyFactory(types);
            this.proxyClassForDecorators = proxyClass = proxyFactory.createClass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T applyDecorators(T instance, CreationalContext<T> creationalContext, InjectionPoint originalInjectionPoint) {
        ArrayList<SerializableContextualInstance<DecoratorImpl<Object>, Object>> decoratorInstances = new ArrayList<SerializableContextualInstance<DecoratorImpl<Object>, Object>>();
        WeldInjectionPoint<?, ?> ip = originalInjectionPoint;
        boolean outside = this.decoratorStackPosition.get() == 0;
        try {
            int i = this.decoratorStackPosition.get();
            while (i < this.decorators.size()) {
                Decorator<?> decorator = this.decorators.get(i);
                if (decorator instanceof DecoratorImpl) {
                    this.decoratorStackPosition.set(++i);
                    DecoratorImpl decoratorBean = (DecoratorImpl)decorator;
                    Object decoratorInstance = this.getManager().getReference(ip, decorator, creationalContext);
                    decoratorInstances.add(new SerializableContextualInstanceImpl<DecoratorImpl, Object>(decoratorBean, decoratorInstance, null));
                    ip = decoratorBean.getDelegateInjectionPoint();
                    continue;
                }
                throw new IllegalStateException("Cannot operate on non container provided decorator " + decorator);
            }
        }
        finally {
            if (outside) {
                this.decoratorStackPosition.remove();
            }
        }
        try {
            T proxy = this.proxyClassForDecorators.newInstance();
            ((ProxyObject)proxy).setHandler(new DecoratorProxyMethodHandler(decoratorInstances, instance));
            return proxy;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not instantiate decorator proxy for " + this.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not access bean correctly when creating decorator proxy for " + this.toString(), e);
        }
    }

    public List<Decorator<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    protected void initType() {
        this.type = this.getAnnotatedItem().getJavaClass();
    }

    protected void initInjectableFields() {
        this.injectableFields = Beans.getFieldInjectionPoints(this, this.annotatedItem);
        this.addInjectionPoints(Beans.getFieldInjectionPoints(this, this.injectableFields));
    }

    protected void initInitializerMethods() {
        this.initializerMethods = Beans.getInitializerMethods(this, this.getAnnotatedItem());
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.initializerMethods));
    }

    @Override
    protected void initScopeType() {
        for (WeldClass<?> clazz = this.getAnnotatedItem(); clazz != null; clazz = clazz.getWeldSuperclass()) {
            HashSet<Annotation> scopeTypes = new HashSet<Annotation>();
            scopeTypes.addAll(clazz.getDeclaredMetaAnnotations(Scope.class));
            scopeTypes.addAll(clazz.getDeclaredMetaAnnotations(NormalScope.class));
            if (scopeTypes.size() == 1) {
                if (!this.getAnnotatedItem().isAnnotationPresent(((Annotation)scopeTypes.iterator().next()).annotationType())) break;
                this.scopeType = ((Annotation)scopeTypes.iterator().next()).annotationType();
                log.trace((Enum)BeanMessages.USING_SCOPE, new Object[]{this.scopeType, this});
                break;
            }
            if (scopeTypes.size() <= 1) continue;
            throw new DefinitionException("At most one scope may be specified on " + this.getAnnotatedItem());
        }
        if (this.scopeType == null) {
            this.initScopeTypeFromStereotype();
        }
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace((Enum)BeanMessages.USING_DEFAULT_SCOPE, new Object[]{this});
        }
    }

    protected void checkBeanImplementation() {
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (this.getAnnotatedItem().getWeldSuperclass() == null || this.getAnnotatedItem().getWeldSuperclass().getJavaClass().equals(Object.class)) {
            throw new DefinitionException("Specializing bean must extend another bean " + this.toString());
        }
    }

    public WeldClass<T> getAnnotatedItem() {
        return this.annotatedItem;
    }

    @Override
    protected String getDefaultName() {
        String name = Strings.decapitalize(this.getAnnotatedItem().getSimpleName());
        return name;
    }

    public List<? extends Set<? extends MethodInjectionPoint<?, ?>>> getInitializerMethods() {
        return this.initializerMethods;
    }

    public List<? extends Set<FieldInjectionPoint<?, ?>>> getInjectableFields() {
        return this.injectableFields;
    }

    protected void initPostConstruct() {
        this.postConstruct = Beans.getPostConstruct(this.getAnnotatedItem());
    }

    protected void initPreDestroy() {
        this.preDestroy = Beans.getPreDestroy(this.getAnnotatedItem());
    }

    public WeldMethod<?, ?> getPostConstruct() {
        return this.postConstruct;
    }

    public WeldMethod<?, ?> getPreDestroy() {
        return this.preDestroy;
    }

    protected abstract boolean isInterceptionCandidate();

    protected static Set<Annotation> flattenInterceptorBindings(BeanManagerImpl manager, Set<Annotation> annotations) {
        HashSet<Annotation> foundInterceptionBindingTypes = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            if (!manager.isInterceptorBinding(annotation.annotationType())) continue;
            foundInterceptionBindingTypes.add(annotation);
            foundInterceptionBindingTypes.addAll(manager.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(annotation.annotationType()).getInheritedInterceptionBindingTypes());
        }
        return foundInterceptionBindingTypes;
    }

    protected void initCdiBoundInterceptors() {
        if (this.manager.getCdiInterceptorsRegistry().getInterceptionModel(this.getType()) == null) {
            InterceptionModelBuilder builder = InterceptionModelBuilder.newBuilderFor(this.getType(), SerializableContextual.class);
            Set<Annotation> classBindingAnnotations = AbstractClassBean.flattenInterceptorBindings(this.manager, this.getAnnotatedItem().getAnnotations());
            for (Class<Annotation> annotation : this.getStereotypes()) {
                classBindingAnnotations.addAll(AbstractClassBean.flattenInterceptorBindings(this.manager, this.manager.getStereotypeDefinition(annotation)));
            }
            if (classBindingAnnotations.size() > 0) {
                if (Beans.findInterceptorBindingConflicts(this.manager, classBindingAnnotations)) {
                    throw new DeploymentException("Conflicting interceptor bindings found on " + this.getType());
                }
                Annotation[] classBindingAnnotationsArray = classBindingAnnotations.toArray(new Annotation[0]);
                List<Interceptor<?>> resolvedPostConstructInterceptors = this.manager.resolveInterceptors(InterceptionType.POST_CONSTRUCT, classBindingAnnotationsArray);
                builder.interceptPostConstruct().with(AbstractClassBean.toSerializableContextualArray(resolvedPostConstructInterceptors));
                List<Interceptor<?>> resolvedPreDestroyInterceptors = this.manager.resolveInterceptors(InterceptionType.PRE_DESTROY, classBindingAnnotationsArray);
                builder.interceptPreDestroy().with(AbstractClassBean.toSerializableContextualArray(resolvedPreDestroyInterceptors));
                List<Interceptor<?>> resolvedPrePassivateInterceptors = this.manager.resolveInterceptors(InterceptionType.PRE_PASSIVATE, classBindingAnnotationsArray);
                builder.interceptPrePassivate().with(AbstractClassBean.toSerializableContextualArray(resolvedPrePassivateInterceptors));
                List<Interceptor<?>> resolvedPostActivateInterceptors = this.manager.resolveInterceptors(InterceptionType.POST_ACTIVATE, classBindingAnnotationsArray);
                builder.interceptPostActivate().with(AbstractClassBean.toSerializableContextualArray(resolvedPostActivateInterceptors));
            }
            List<WeldMethod<?, ?>> businessMethods = Beans.getInterceptableMethods(this.getAnnotatedItem());
            for (WeldMethod<?, ?> method : businessMethods) {
                List<Interceptor<?>> methodBoundInterceptors;
                HashSet<Annotation> methodBindingAnnotations = new HashSet<Annotation>(classBindingAnnotations);
                methodBindingAnnotations.addAll(AbstractClassBean.flattenInterceptorBindings(this.manager, method.getAnnotations()));
                if (methodBindingAnnotations.size() <= 0) continue;
                if (Beans.findInterceptorBindingConflicts(this.manager, classBindingAnnotations)) {
                    throw new DeploymentException("Conflicting interceptor bindings found on " + this.getType() + "." + method.getName() + "()");
                }
                if (method.isAnnotationPresent(this.manager.getServices().get(EJBApiAbstraction.class).TIMEOUT_ANNOTATION_CLASS)) {
                    methodBoundInterceptors = this.manager.resolveInterceptors(InterceptionType.AROUND_TIMEOUT, methodBindingAnnotations.toArray(new Annotation[0]));
                    builder.interceptAroundTimeout(method.getJavaMember()).with(AbstractClassBean.toSerializableContextualArray(methodBoundInterceptors));
                    continue;
                }
                methodBoundInterceptors = this.manager.resolveInterceptors(InterceptionType.AROUND_INVOKE, methodBindingAnnotations.toArray(new Annotation[0]));
                builder.interceptAroundInvoke(method.getJavaMember()).with(AbstractClassBean.toSerializableContextualArray(methodBoundInterceptors));
            }
            InterceptionModel serializableContextualInterceptionModel = builder.build();
            if (serializableContextualInterceptionModel.getAllInterceptors().size() > 0) {
                this.manager.getCdiInterceptorsRegistry().registerInterceptionModel(this.getType(), serializableContextualInterceptionModel);
            }
        }
    }

    public void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    public InjectionTarget<T> getInjectionTarget() {
        return this.injectionTarget;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getInjectionTarget().getInjectionPoints();
    }

    protected void defaultPreDestroy(T instance) {
        WeldMethod<?, ?> preDestroy = this.getPreDestroy();
        if (preDestroy != null) {
            try {
                preDestroy.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + preDestroy + " on " + instance, e);
            }
        }
    }

    protected void defaultPostConstruct(T instance) {
        WeldMethod<?, ?> postConstruct = this.getPostConstruct();
        if (postConstruct != null) {
            try {
                postConstruct.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to invoke " + postConstruct + " on " + instance, e);
            }
        }
    }

    private static SerializableContextual[] toSerializableContextualArray(List<Interceptor<?>> interceptors) {
        ArrayList serializableContextuals = new ArrayList();
        for (Interceptor<?> interceptor : interceptors) {
            serializableContextuals.add(new SerializableContextualImpl(interceptor));
        }
        return serializableContextuals.toArray(new SerializableContextual[0]);
    }

    public boolean hasCdiBoundInterceptors() {
        if (this.manager.getCdiInterceptorsRegistry().getInterceptionModel(this.getType()) != null) {
            return this.manager.getCdiInterceptorsRegistry().getInterceptionModel(this.getType()).getAllInterceptors().size() > 0;
        }
        return false;
    }

    public boolean hasDirectlyDefinedInterceptors() {
        if (this.manager.getClassDeclaredInterceptorsRegistry().getInterceptionModel(this.getType()) != null) {
            return this.manager.getClassDeclaredInterceptorsRegistry().getInterceptionModel(this.getType()).getAllInterceptors().size() > 0;
        }
        return false;
    }

    protected void initDirectlyDefinedInterceptors() {
        if (this.manager.getClassDeclaredInterceptorsRegistry().getInterceptionModel(this.getType()) == null && InterceptionUtils.supportsEjb3InterceptorDeclaration()) {
            InterceptionModelBuilder builder = InterceptionModelBuilder.newBuilderFor(this.getType(), Class.class);
            Class<?>[] classDeclaredInterceptors = null;
            if (this.getAnnotatedItem().isAnnotationPresent(InterceptionUtils.getInterceptorsAnnotationClass())) {
                Annotation interceptorsAnnotation = this.getType().getAnnotation(InterceptionUtils.getInterceptorsAnnotationClass());
                classDeclaredInterceptors = Reflections.extractValues(interceptorsAnnotation);
            }
            if (classDeclaredInterceptors != null) {
                builder.interceptAll().with(classDeclaredInterceptors);
            }
            List<WeldMethod<?, ?>> businessMethods = Beans.getInterceptableMethods(this.getAnnotatedItem());
            for (WeldMethod<?, ?> method : businessMethods) {
                boolean excludeClassInterceptors = method.isAnnotationPresent(InterceptionUtils.getExcludeClassInterceptorsAnnotationClass());
                Class<?>[] methodDeclaredInterceptors = null;
                if (method.isAnnotationPresent(InterceptionUtils.getInterceptorsAnnotationClass())) {
                    methodDeclaredInterceptors = Reflections.extractValues(method.getAnnotation(InterceptionUtils.getInterceptorsAnnotationClass()));
                }
                if (excludeClassInterceptors) {
                    builder.ignoreGlobalInterceptors(method.getJavaMember());
                }
                if (methodDeclaredInterceptors == null) continue;
                if (method.isAnnotationPresent(this.manager.getServices().get(EJBApiAbstraction.class).TIMEOUT_ANNOTATION_CLASS)) {
                    builder.interceptAroundTimeout(method.getJavaMember()).with(methodDeclaredInterceptors);
                    continue;
                }
                builder.interceptAroundInvoke(method.getJavaMember()).with(methodDeclaredInterceptors);
            }
            InterceptionModel interceptionModel = builder.build();
            if (interceptionModel.getAllInterceptors().size() > 0 || new InterceptorClassMetadataImpl(this.getType()).isInterceptor()) {
                this.manager.getClassDeclaredInterceptorsRegistry().registerInterceptionModel(this.getType(), builder.build());
            }
        }
    }
}

