/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import javax.inject.Scope;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractReceiverBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.introspector.WeldMember;
import org.jboss.weld.messages.BeanMessages;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Names;
import org.jboss.weld.util.Reflections;
import org.jboss.weld.util.log.Categories;
import org.jboss.weld.util.log.LoggerFactory;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProducerBean<X, T, S extends Member>
extends AbstractReceiverBean<X, T, S> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Categories.BEAN);
    private Producer<T> producer;

    public AbstractProducerBean(String idSuffix, AbstractClassBean<X> declaringBean, BeanManagerImpl manager) {
        super(idSuffix, declaringBean, manager);
    }

    @Override
    public abstract WeldMember<T, X, S> getAnnotatedItem();

    @Override
    public Class<?> getBeanClass() {
        return this.getDeclaringBean().getBeanClass();
    }

    @Override
    protected void initTypes() {
        if (this.getType().isArray() || this.getType().isPrimitive()) {
            HashSet<Class<Object>> types = new HashSet<Class<Object>>();
            types.add(this.getType());
            types.add(Object.class);
            this.types = types;
        } else {
            super.initTypes();
        }
    }

    protected void initType() {
        try {
            this.type = this.getAnnotatedItem().getJavaClass();
        }
        catch (ClassCastException e) {
            Type type = Beans.getDeclaredBeanType(this.getClass());
            throw new RuntimeException(" Cannot cast producer type " + this.getAnnotatedItem().getJavaClass() + " to bean type " + (type == null ? " unknown " : type), e);
        }
    }

    protected void checkProducerReturnType() {
        if (this.getAnnotatedItem().getBaseType() instanceof TypeVariable) {
            throw new DefinitionException("Return type must be concrete " + this.getAnnotatedItem().getBaseType());
        }
        if (this.getAnnotatedItem().getBaseType() instanceof WildcardType) {
            throw new DefinitionException("Return type must be concrete " + this.getAnnotatedItem().getBaseType());
        }
        for (Type type : this.getAnnotatedItem().getActualTypeArguments()) {
            if (type instanceof Class) continue;
            throw new DefinitionException("Producer type cannot be parameterized with type parameter or wildcard:\n" + this.getAnnotatedItem());
        }
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.getDeclaringBean().initialize(environment);
        super.initialize(environment);
        this.checkProducerReturnType();
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getProducer().getInjectionPoints();
    }

    protected void checkReturnValue(T instance) {
        if (instance == null && !this.isDependent()) {
            throw new IllegalProductException("Cannot return null from a non-dependent producer method");
        }
        if (instance != null) {
            boolean passivating = this.manager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isPassivating();
            if (passivating && !Reflections.isSerializable(instance.getClass())) {
                throw new IllegalProductException("Producers cannot declare passivating scope and return a non-serializable class");
            }
            InjectionPoint injectionPoint = this.manager.getCurrentInjectionPoint();
            if (injectionPoint == null) {
                return;
            }
            if (!Reflections.isSerializable(instance.getClass()) && Beans.isPassivationCapableBean(injectionPoint.getBean())) {
                if (injectionPoint.getMember() instanceof Field) {
                    if (!Reflections.isTransient(injectionPoint.getMember()) && instance != null && !Reflections.isSerializable(instance.getClass())) {
                        throw new IllegalProductException("Producers cannot produce non-serializable instances for injection into non-transient fields of passivating beans\n\nProducer: " + this.toString() + "\nInjection Point: " + injectionPoint.toString());
                    }
                } else if (injectionPoint.getMember() instanceof Method) {
                    Method method = (Method)injectionPoint.getMember();
                    if (method.isAnnotationPresent(Inject.class)) {
                        throw new IllegalProductException("Producers cannot produce non-serializable instances for injection into parameters of intializers of beans declaring passivating scope. Bean " + this.toString() + " being injected into " + injectionPoint.toString());
                    }
                    if (method.isAnnotationPresent(Produces.class)) {
                        throw new IllegalProductException("Producers cannot produce non-serializable instances for injection into parameters of producer methods declaring passivating scope. Bean " + this.toString() + " being injected into " + injectionPoint.toString());
                    }
                } else if (injectionPoint.getMember() instanceof Constructor) {
                    throw new IllegalProductException("Producers cannot produce non-serializable instances for injection into parameters of constructors of beans declaring passivating scope. Bean " + this.toString() + " being injected into " + injectionPoint.toString());
                }
            }
        }
    }

    @Override
    protected void initScopeType() {
        HashSet<Annotation> scopeAnnotations = new HashSet<Annotation>();
        scopeAnnotations.addAll(this.getAnnotatedItem().getMetaAnnotations(Scope.class));
        scopeAnnotations.addAll(this.getAnnotatedItem().getMetaAnnotations(NormalScope.class));
        if (scopeAnnotations.size() > 1) {
            throw new DefinitionException("At most one scope may be specified");
        }
        if (scopeAnnotations.size() == 1) {
            this.scopeType = ((Annotation)scopeAnnotations.iterator().next()).annotationType();
            log.trace((Enum)BeanMessages.USING_SCOPE, new Object[]{this.scopeType, this});
            return;
        }
        this.initScopeTypeFromStereotype();
        if (this.scopeType == null) {
            this.scopeType = Dependent.class;
            log.trace((Enum)BeanMessages.USING_DEFAULT_SCOPE, new Object[]{this});
        }
    }

    @Override
    protected void initSerializable() {
    }

    @Override
    public boolean isSerializable() {
        return true;
    }

    public void setProducer(Producer<T> producer) {
        this.producer = producer;
    }

    public Producer<T> getProducer() {
        return this.producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create(CreationalContext<T> creationalContext) {
        try {
            T instance = this.getProducer().produce(creationalContext);
            this.checkReturnValue(instance);
            T t = instance;
            return t;
        }
        finally {
            if (this.getDeclaringBean().isDependent()) {
                creationalContext.release();
            }
        }
    }

    @Override
    public String getDescription() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Annotated " + Names.scopeTypeToString(this.getScope()));
        if (this.getName() == null) {
            buffer.append("unnamed producer bean");
        } else {
            buffer.append("simple producer bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getBeanClass().getName() + "] for class type [" + this.getType().getName() + "] API types " + this.getTypes() + ", binding types " + this.getQualifiers());
        return buffer.toString();
    }
}

