/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.DefinitionException;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerMethod<X, T>
extends AbstractProducerBean<X, T, Method> {
    private MethodInjectionPoint<T, X> method;
    private DisposalMethod<X, ?> disposalMethodBean;
    private ProducerMethod<?, ?> specializedBean;
    private final String id;

    public static <X, T> ProducerMethod<X, T> of(WeldMethod<T, X> method, AbstractClassBean<X> declaringBean, BeanManagerImpl manager) {
        return new ProducerMethod<X, T>(method, declaringBean, manager);
    }

    protected ProducerMethod(WeldMethod<T, X> method, AbstractClassBean<X> declaringBean, BeanManagerImpl manager) {
        super(ProducerMethod.class.getSimpleName() + "-" + declaringBean.getAnnotatedItem().getName() + "." + method.getSignature().toString(), declaringBean, manager);
        this.method = MethodInjectionPoint.of(this, method);
        this.initType();
        this.initTypes();
        this.initBindings();
        this.id = BEAN_ID_PREFIX + this.getClass().getSimpleName() + "-" + declaringBean.getAnnotatedItem().getName() + this.getAnnotatedItem().getSignature().toString();
        this.initStereotypes();
        this.initPolicy();
        this.initProducerMethodInjectableParameters();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.checkProducerMethod();
            this.initDisposalMethod(environment);
            this.setProducer(new Producer<T>(){

                @Override
                public void dispose(T instance) {
                    if (ProducerMethod.this.disposalMethodBean != null) {
                        ProducerMethod.this.disposalMethodBean.invokeDisposeMethod(instance);
                    }
                }

                @Override
                public Set<InjectionPoint> getInjectionPoints() {
                    return ProducerMethod.this.getAnnotatedInjectionPoints();
                }

                @Override
                public T produce(CreationalContext<T> creationalContext) {
                    Object receiver = ProducerMethod.this.getReceiver(creationalContext);
                    if (receiver != null) {
                        return ProducerMethod.this.method.invokeOnInstance(receiver, ProducerMethod.this.manager, creationalContext, CreationException.class);
                    }
                    return ProducerMethod.this.method.invoke(receiver, ProducerMethod.this.manager, creationalContext, CreationException.class);
                }
            });
        }
    }

    protected void initProducerMethodInjectableParameters() {
        for (ParameterInjectionPoint<?, X> parameter : this.method.getWBParameters()) {
            this.addInjectionPoint(ParameterInjectionPoint.of(this, parameter));
        }
    }

    protected void checkProducerMethod() {
        if (this.getAnnotatedItem().getAnnotatedWBParameters(Observes.class).size() > 0) {
            throw new DefinitionException("Producer method cannot have parameter annotated @Observes");
        }
        if (this.getAnnotatedItem().getAnnotatedWBParameters(Disposes.class).size() > 0) {
            throw new DefinitionException("Producer method cannot have parameter annotated @Disposes");
        }
        if (this.getDeclaringBean() instanceof SessionBean) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.getDeclaringBean().getTypes()) {
                if (!(type instanceof Class)) continue;
                Class clazz = (Class)type;
                try {
                    clazz.getDeclaredMethod(this.getAnnotatedItem().getName(), this.getAnnotatedItem().getParameterTypesAsArray());
                    methodDeclaredOnTypes = true;
                }
                catch (NoSuchMethodException nsme) {}
            }
            if (!methodDeclaredOnTypes) {
                throw new DefinitionException("Producer method " + this.toString() + " must be declared on a business interface of " + this.getDeclaringBean());
            }
        }
    }

    protected void initDisposalMethod(BeanDeployerEnvironment environment) {
        Set disposalBeans = environment.resolveDisposalBeans(this.getTypes(), this.getQualifiers(), this.getDeclaringBean());
        if (disposalBeans.size() == 1) {
            this.disposalMethodBean = disposalBeans.iterator().next();
        } else if (disposalBeans.size() > 1) {
            throw new DefinitionException("Cannot declare multiple disposal methods for this producer method. Producer method: " + this + ". Disposal methods: " + disposalBeans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            this.getProducer().dispose(instance);
        }
        finally {
            if (this.getDeclaringBean().isDependent()) {
                creationalContext.release();
            }
        }
    }

    @Override
    public WeldMethod<T, X> getAnnotatedItem() {
        return this.method;
    }

    @Override
    protected String getDefaultName() {
        return this.method.getPropertyName();
    }

    public DisposalMethod<X, ?> getDisposalMethod() {
        return this.disposalMethodBean;
    }

    @Override
    public String getDescription() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Names.scopeTypeToString(this.getScope()));
        if (this.getName() == null) {
            buffer.append("unnamed producer method bean");
        } else {
            buffer.append("simple producer method bean '" + this.getName() + "'");
        }
        buffer.append(" [" + this.getBeanClass().getName() + "] for class type [" + this.getType().getName() + "] API types " + this.getTypes() + ", binding types " + this.getQualifiers());
        return buffer.toString();
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        if (this.getDeclaringBean().getAnnotatedItem().getWeldSuperclass().getDeclaredWeldMethod(this.getAnnotatedItem().getAnnotatedMethod()) == null) {
            throw new DefinitionException("Specialized producer method does not override a method on the direct superclass");
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        WeldMethod<?, ?> superClassMethod = this.getDeclaringBean().getAnnotatedItem().getWeldSuperclass().getWeldMethod(this.getAnnotatedItem().getAnnotatedMethod());
        if (environment.getProducerMethod(superClassMethod) == null) {
            throw new IllegalStateException(this.toString() + " does not specialize a bean");
        }
        this.specializedBean = environment.getProducerMethod(superClassMethod);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }
}

