/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import org.jboss.weld.BeanManagerImpl;
import org.jboss.weld.bean.builtin.DefaultValidatorBean;
import org.jboss.weld.bean.builtin.DefaultValidatorFactoryBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bean.builtin.InjectionPointBean;
import org.jboss.weld.bean.builtin.ManagerBean;
import org.jboss.weld.bean.builtin.PrincipalBean;
import org.jboss.weld.bean.builtin.UserTransactionBean;
import org.jboss.weld.bean.builtin.facade.EventBean;
import org.jboss.weld.bean.builtin.facade.InstanceBean;
import org.jboss.weld.bootstrap.BeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.ExtensionBeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.SimpleServiceRegistry;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.conversation.ConversationImpl;
import org.jboss.weld.conversation.JavaSEConversationTerminator;
import org.jboss.weld.conversation.NumericConversationIdGenerator;
import org.jboss.weld.conversation.ServletConversationManager;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.messages.BootstrapMessages;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.security.spi.SecurityServices;
import org.jboss.weld.servlet.HttpSessionManager;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.log.Categories;
import org.jboss.weld.util.log.LoggerFactory;
import org.jboss.weld.validation.spi.ValidationServices;
import org.jboss.weld.xml.BeansXmlParser;
import org.slf4j.cal10n.LocLogger;

public class BeanDeployment {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Categories.BOOTSTRAP);
    private final BeanDeploymentArchive beanDeploymentArchive;
    private final BeanManagerImpl beanManager;
    private final ExtensionBeanDeployerEnvironment extensionBeanDeployerEnvironment;
    private final BeanDeployer beanDeployer;
    private final Deployment deployment;

    public BeanDeployment(BeanDeploymentArchive beanDeploymentArchive, BeanManagerImpl deploymentManager, Deployment deployment, ExtensionBeanDeployerEnvironment extensionBeanDeployerEnvironment, ServiceRegistry deploymentServices) {
        this.extensionBeanDeployerEnvironment = extensionBeanDeployerEnvironment;
        this.deployment = deployment;
        this.beanDeploymentArchive = beanDeploymentArchive;
        EjbDescriptors ejbDescriptors = new EjbDescriptors();
        beanDeploymentArchive.getServices().add(EjbDescriptors.class, ejbDescriptors);
        SimpleServiceRegistry services = new SimpleServiceRegistry();
        services.addAll(deploymentServices.entrySet());
        services.addAll(beanDeploymentArchive.getServices().entrySet());
        this.beanManager = BeanManagerImpl.newManager(deploymentManager, beanDeploymentArchive.getId(), services);
        if (this.beanManager.getServices().contains(EjbServices.class)) {
            ejbDescriptors.addAll(beanDeploymentArchive.getEjbs());
        }
        this.beanDeployer = new BeanDeployer(this.beanManager, deploymentManager, ejbDescriptors);
        this.parseBeansXml();
    }

    public BeanManagerImpl getBeanManager() {
        return this.beanManager;
    }

    public BeanDeployer getBeanDeployer() {
        return this.beanDeployer;
    }

    public BeanDeploymentArchive getBeanDeploymentArchive() {
        return this.beanDeploymentArchive;
    }

    private void parseBeansXml() {
        BeansXmlParser parser = new BeansXmlParser(this.beanManager.getServices().get(ResourceLoader.class), this.getBeanDeploymentArchive().getBeansXml());
        parser.parse();
        if (parser.getEnabledPolicyClasses() != null) {
            this.beanManager.setEnabledPolicyClasses(parser.getEnabledPolicyClasses());
        }
        if (parser.getEnabledPolicyStereotypes() != null) {
            this.beanManager.setEnabledPolicyStereotypes(parser.getEnabledPolicyStereotypes());
        }
        if (parser.getEnabledDecoratorClasses() != null) {
            this.beanManager.setEnabledDecoratorClasses(parser.getEnabledDecoratorClasses());
        }
        if (parser.getEnabledInterceptorClasses() != null) {
            this.beanManager.setEnabledInterceptorClasses(parser.getEnabledInterceptorClasses());
        }
        log.debug((Enum)BootstrapMessages.ENABLED_POLICIES, new Object[]{this.beanManager, this.beanManager.getEnabledPolicyClasses(), this.beanManager.getEnabledPolicyStereotypes()});
        log.debug((Enum)BootstrapMessages.ENABLED_DECORATORS, new Object[]{this.beanManager, this.beanManager.getEnabledDecoratorClasses()});
        log.debug((Enum)BootstrapMessages.ENABLED_INTERCEPTORS, new Object[]{this.beanManager, this.beanManager.getEnabledInterceptorClasses()});
    }

    public void deployBeans(Environment environment) {
        for (ExtensionBean extensionBean : this.extensionBeanDeployerEnvironment.getBeans()) {
            BeanDeploymentArchive classBeanDeploymentArchive = this.deployment.loadBeanDeploymentArchive(extensionBean.getBeanClass());
            if (classBeanDeploymentArchive == null) {
                throw new IllegalStateException("deployment.loadBeanDeploymentArchive() returned null for " + extensionBean.getBeanClass());
            }
            if (!classBeanDeploymentArchive.equals(this.beanDeploymentArchive)) continue;
            this.beanDeployer.getManager().addBean(extensionBean);
        }
        for (ObserverMethodImpl observerMethodImpl : this.extensionBeanDeployerEnvironment.getObservers()) {
            if (!this.deployment.loadBeanDeploymentArchive(observerMethodImpl.getBeanClass()).equals(this.beanDeploymentArchive)) continue;
            this.beanDeployer.getManager().addObserver(observerMethodImpl);
        }
        this.beanDeployer.addClasses(this.beanDeploymentArchive.getBeanClasses());
        ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new ManagerBean(this.beanManager));
        ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new InjectionPointBean(this.beanManager));
        ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new EventBean(this.beanManager));
        ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new InstanceBean(this.beanManager));
        if (!environment.equals(Environments.SE)) {
            this.beanDeployer.addClass(ConversationImpl.class);
            this.beanDeployer.addClass(ServletConversationManager.class);
            this.beanDeployer.addClass(JavaSEConversationTerminator.class);
            this.beanDeployer.addClass(NumericConversationIdGenerator.class);
            this.beanDeployer.addClass(HttpSessionManager.class);
        }
        if (this.beanManager.getServices().contains(TransactionServices.class)) {
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new UserTransactionBean(this.beanManager));
        }
        if (this.beanManager.getServices().contains(SecurityServices.class)) {
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new PrincipalBean(this.beanManager));
        }
        if (this.beanManager.getServices().contains(ValidationServices.class)) {
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new DefaultValidatorBean(this.beanManager));
            ((BeanDeployerEnvironment)this.beanDeployer.getEnvironment()).addBuiltInBean(new DefaultValidatorFactoryBean(this.beanManager));
        }
        this.beanDeployer.createBeans().deploy();
    }
}

