/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.messages.ContextMessages;
import org.jboss.weld.util.log.Categories;
import org.jboss.weld.util.log.LoggerFactory;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentInstancesStore
implements Serializable {
    private static final long serialVersionUID = -2349574791148336833L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Categories.CONTEXT);
    private List<ContextualInstance<?>> dependentInstances = Collections.synchronizedList(new ArrayList());

    public <T> void addDependentInstance(ContextualInstance<T> contextualInstance) {
        log.trace((Enum)ContextMessages.DEPENDENT_INSTANCE_ATTACHED, new Object[]{contextualInstance});
        this.dependentInstances.add(contextualInstance);
    }

    public void destroyDependentInstances() {
        for (ContextualInstance<?> injectedInstance : this.dependentInstances) {
            DependentInstancesStore.destroy(injectedInstance);
        }
    }

    private static <T> void destroy(ContextualInstance<T> beanInstance) {
        beanInstance.getContextual().destroy(beanInstance.getInstance(), beanInstance.getCreationalContext());
    }

    public String toString() {
        return "Dependent Instances: " + this.dependentInstances;
    }
}

