/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.messages.ContextMessages;
import org.jboss.weld.util.Names;
import org.jboss.weld.util.collections.EnumerationList;
import org.jboss.weld.util.log.Categories;
import org.jboss.weld.util.log.LoggerFactory;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributeBackedBeanStore
implements BeanStore {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Categories.CONTEXT);

    @Override
    public <T> ContextualInstance<T> get(String id) {
        String key = this.getNamingScheme().getKey(id);
        ContextualInstance instance = (ContextualInstance)this.getAttribute(key);
        log.trace((Enum)ContextMessages.CONTEXTUAL_INSTANCE_FOUND, new Object[]{id, instance, this});
        return instance;
    }

    @Override
    public void clear() {
        for (String attributeName : this.getFilteredAttributeNames()) {
            this.removeAttribute(attributeName);
        }
        log.trace((Enum)ContextMessages.CONTEXT_CLEARED, new Object[]{this});
    }

    @Override
    public Collection<String> getContextualIds() {
        ArrayList<String> contextuals = new ArrayList<String>();
        NamingScheme namingScheme = this.getNamingScheme();
        for (String attributeName : this.getFilteredAttributeNames()) {
            String id = namingScheme.getId(attributeName);
            contextuals.add(id);
        }
        return contextuals;
    }

    private List<String> getFilteredAttributeNames() {
        ArrayList<String> attributeNames = new ArrayList<String>();
        NamingScheme namingScheme = this.getNamingScheme();
        for (String attributeName : new EnumerationList<String>(this.getAttributeNames())) {
            if (!namingScheme.acceptKey(attributeName)) continue;
            attributeNames.add(attributeName);
        }
        return attributeNames;
    }

    @Override
    public <T> void put(String id, ContextualInstance<T> beanInstance) {
        String key = this.getNamingScheme().getKey(id);
        this.setAttribute(key, beanInstance);
        log.trace((Enum)ContextMessages.CONTEXTUAL_INSTANCE_ADDED, new Object[]{beanInstance.getContextual(), key, this});
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void removeAttribute(String var1);

    protected abstract Enumeration<String> getAttributeNames();

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract NamingScheme getNamingScheme();

    public String toString() {
        return "holding " + Names.count(this.getContextualIds()) + " instances";
    }
}

