/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.conversation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.enterprise.context.Conversation;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.weld.Container;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.api.BeanStore;
import org.jboss.weld.conversation.ConversationConcurrentAccessTimeout;
import org.jboss.weld.conversation.ConversationEntry;
import org.jboss.weld.conversation.ConversationImpl;
import org.jboss.weld.conversation.ConversationManager;
import org.jboss.weld.conversation.ConversationTerminator;
import org.jboss.weld.messages.ConversationMessages;
import org.jboss.weld.util.log.Categories;
import org.jboss.weld.util.log.LoggerFactory;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConversationManager
implements ConversationManager {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Categories.CONVERSATION);
    @Inject
    private ConversationTerminator conversationTerminator;
    @Inject
    @Any
    private ConversationImpl currentConversation;
    @ConversationConcurrentAccessTimeout
    private long concurrentAccessTimeout;
    private Map<String, ConversationEntry> longRunningConversations = new ConcurrentHashMap<String, ConversationEntry>();

    @Override
    public void beginOrRestoreConversation(String cid) {
        if (cid == null) {
            log.trace((Enum)ConversationMessages.NO_CONVERSATION_TO_RESTORE, new Object[0]);
            return;
        }
        if (!this.longRunningConversations.containsKey(cid)) {
            log.warn((Enum)ConversationMessages.UNABLE_TO_RESTORE_CONVERSATION, new Object[]{cid, "id not known"});
            return;
        }
        ConversationEntry resumedConversationEntry = this.longRunningConversations.get(cid);
        try {
            if (!resumedConversationEntry.lock(this.concurrentAccessTimeout)) {
                return;
            }
        }
        catch (InterruptedException e) {
            log.debug((Enum)ConversationMessages.CONVERSATION_LOCK_UNAVAILABLE, new Object[0]);
            Thread.currentThread().interrupt();
            return;
        }
        if (!resumedConversationEntry.cancelTermination()) {
            resumedConversationEntry.unlock();
        } else {
            String oldConversation = this.currentConversation.toString();
            this.currentConversation.switchTo(resumedConversationEntry.getConversation());
            log.trace((Enum)ConversationMessages.CONVERSATION_SWITCHED, new Object[]{oldConversation, this.currentConversation});
        }
    }

    @Override
    public void cleanupConversation() {
        ConversationEntry longRunningConversation;
        log.trace((Enum)ConversationMessages.CLEANING_UP_CONVERSATION, new Object[]{this.currentConversation});
        String cid = this.currentConversation.getUnderlyingId();
        if (!this.currentConversation.isTransient()) {
            Future<?> terminationHandle = this.scheduleForTermination(cid, this.currentConversation.getTimeout());
            longRunningConversation = this.longRunningConversations.get(cid);
            if (longRunningConversation != null) {
                longRunningConversation.unlock();
                longRunningConversation.reScheduleTermination(terminationHandle);
            } else {
                ConversationEntry conversationEntry = ConversationEntry.of(this.getBeanStore(cid), this.currentConversation, terminationHandle);
                this.longRunningConversations.put(cid, conversationEntry);
            }
            log.trace((Enum)ConversationMessages.CONVERSATION_TERMINATION_SCHEDULED, new Object[]{this.currentConversation});
            log.trace((Enum)ConversationMessages.LRC_COUNT, new Object[]{this.longRunningConversations.size()});
        } else {
            log.trace((Enum)ConversationMessages.DESTROY_TRANSIENT_COVERSATION, new Object[]{this.currentConversation});
            ConversationEntry longRunningConversation2 = this.longRunningConversations.remove(cid);
            if (longRunningConversation2 != null) {
                longRunningConversation2.cancelTermination();
                longRunningConversation2.unlock();
            }
            ConversationContext conversationContext = Container.instance().deploymentServices().get(ContextLifecycle.class).getConversationContext();
            conversationContext.destroy();
        }
        String originalCid = this.currentConversation.getOriginalId();
        ConversationEntry conversationEntry = longRunningConversation = originalCid == null ? null : this.longRunningConversations.get(originalCid);
        if (longRunningConversation != null) {
            longRunningConversation.unlock();
            longRunningConversation.reScheduleTermination(this.scheduleForTermination(originalCid, this.currentConversation.getTimeout()));
        }
    }

    private Future<?> scheduleForTermination(String cid, long timeout) {
        TerminationTask terminationTask = new TerminationTask(cid);
        return this.conversationTerminator.scheduleForTermination(terminationTask, timeout);
    }

    @Override
    public void destroyAllConversations() {
        log.debug((Enum)ConversationMessages.DESTROY_ALL_LRC, new Object[]{"session ended"});
        log.trace((Enum)ConversationMessages.LRC_COUNT, new Object[]{this.longRunningConversations.size()});
        for (ConversationEntry conversationEntry : this.longRunningConversations.values()) {
            log.debug((Enum)ConversationMessages.DESTROY_LRC, new Object[]{conversationEntry, "session ended"});
            conversationEntry.destroy();
        }
        this.longRunningConversations.clear();
    }

    @Override
    public Set<Conversation> getLongRunningConversations() {
        HashSet<ConversationImpl> conversations = new HashSet<ConversationImpl>();
        for (ConversationEntry conversationEntry : this.longRunningConversations.values()) {
            conversations.add(conversationEntry.getConversation());
        }
        return Collections.unmodifiableSet(conversations);
    }

    public abstract BeanStore getBeanStore(String var1);

    private class TerminationTask
    implements Runnable {
        private String cid;

        public TerminationTask(String cid) {
            this.cid = cid;
        }

        public void run() {
            log.debug((Enum)ConversationMessages.DESTROY_LRC, new Object[]{this.cid, "conversation timed out"});
            ((ConversationEntry)AbstractConversationManager.this.longRunningConversations.remove(this.cid)).destroy();
            log.trace((Enum)ConversationMessages.LRC_COUNT, new Object[]{AbstractConversationManager.this.longRunningConversations.size()});
        }
    }
}

