/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import org.jboss.weld.event.DeferredEventNotification;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.messages.EventMessages;
import org.jboss.weld.util.log.Categories;
import org.jboss.weld.util.log.LoggerFactory;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsynchronousTransactionalEventNotification<T>
extends DeferredEventNotification<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Categories.EVENT);
    private static final XLogger xLog = LoggerFactory.loggerFactory().getXLogger(Categories.EVENT);

    public AsynchronousTransactionalEventNotification(T event, ObserverMethodImpl<T, ?> observer) {
        super(event, observer);
    }

    @Override
    public void run() {
        try {
            log.trace((Enum)EventMessages.ASYNC_TX_FIRE, new Object[]{this.event, this.observer});
            this.observer.sendEventAsynchronously(this.event);
        }
        catch (Exception e) {
            log.error((Enum)EventMessages.ASYNC_OBSERVER_FAILURE, new Object[]{this.event});
            xLog.throwing(XLogger.Level.DEBUG, (Throwable)e);
        }
    }
}

