/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import org.jboss.weld.Container;
import org.jboss.weld.bootstrap.api.Lifecycle;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.weld.event.ObserverMethodImpl;
import org.jboss.weld.messages.EventMessages;
import org.jboss.weld.util.log.Categories;
import org.jboss.weld.util.log.LoggerFactory;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeferredEventNotification<T>
implements Runnable {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Categories.EVENT);
    private static final XLogger xLog = LoggerFactory.loggerFactory().getXLogger(Categories.EVENT);
    protected final ObserverMethodImpl<T, ?> observer;
    protected final T event;

    public DeferredEventNotification(T event, ObserverMethodImpl<T, ?> observer) {
        this.observer = observer;
        this.event = event;
    }

    @Override
    public void run() {
        try {
            log.debug((Enum)EventMessages.ASYNC_FIRE, new Object[]{this.event, this.observer});
            new RunInRequest(){

                protected void execute() {
                    DeferredEventNotification.this.observer.sendEvent(DeferredEventNotification.this.event);
                }
            }.run();
        }
        catch (Exception e) {
            log.error((Enum)EventMessages.ASYNC_OBSERVER_FAILURE, new Object[]{this.event});
            xLog.throwing(XLogger.Level.DEBUG, (Throwable)e);
        }
    }

    public String toString() {
        return "Deferred event [" + this.event + "] for [" + this.observer + "]";
    }

    private static abstract class RunInRequest {
        private RunInRequest() {
        }

        protected abstract void execute();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Lifecycle lifecycle = Container.instance().deploymentServices().get(ContextLifecycle.class);
            boolean requestActive = lifecycle.isRequestActive();
            ConcurrentHashMapBeanStore requestBeanStore = new ConcurrentHashMapBeanStore();
            try {
                if (!requestActive) {
                    lifecycle.beginRequest("async invocation", requestBeanStore);
                }
                this.execute();
            }
            finally {
                if (!requestActive) {
                    lifecycle.endRequest("async invocation", requestBeanStore);
                }
            }
        }
    }
}

