/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.introspector.AnnotationStore;
import org.jboss.weld.introspector.ConstructorSignature;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.jlr.AbstractWeldAnnotated;
import org.jboss.weld.introspector.jlr.WeldConstructorImpl;
import org.jboss.weld.introspector.jlr.WeldFieldImpl;
import org.jboss.weld.introspector.jlr.WeldMethodImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Names;
import org.jboss.weld.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldClassImpl<T>
extends AbstractWeldAnnotated<T, Class<T>>
implements WeldClass<T> {
    private final WeldClass<?> superclass;
    private final String name;
    private final String _simpleName;
    private final boolean _public;
    private final boolean _private;
    private final boolean _packagePrivate;
    private final Package _package;
    private static List<Class<?>> NO_ARGUMENTS = Collections.emptyList();
    private final Set<WeldField<?, ?>> fields;
    private final SetMultimap<Class<? extends Annotation>, WeldField<?, ?>> annotatedFields;
    private final SetMultimap<Class<? extends Annotation>, WeldField<?, ?>> metaAnnotatedFields;
    private final Set<WeldField<?, ?>> declaredFields;
    private final Map<String, WeldField<?, ?>> declaredFieldsByName;
    private final SetMultimap<Class<? extends Annotation>, WeldField<?, T>> declaredAnnotatedFields;
    private final SetMultimap<Class<? extends Annotation>, WeldField<?, ?>> declaredMetaAnnotatedFields;
    private final Set<WeldMethod<?, ?>> methods;
    private final Map<MethodSignature, WeldMethod<?, ?>> declaredMethodsBySignature;
    private final Map<MethodSignature, WeldMethod<?, ?>> methodsBySignature;
    private final SetMultimap<Class<? extends Annotation>, WeldMethod<?, ?>> annotatedMethods;
    private final SetMultimap<Class<? extends Annotation>, WeldMethod<?, ?>> methodsByAnnotatedParameters;
    private final Set<WeldMethod<?, ?>> declaredMethods;
    private final SetMultimap<Class<? extends Annotation>, WeldMethod<?, T>> declaredAnnotatedMethods;
    private final SetMultimap<Class<? extends Annotation>, WeldMethod<?, T>> declaredMethodsByAnnotatedParameters;
    private final Set<WeldConstructor<T>> constructors;
    private final Map<ConstructorSignature, WeldConstructor<?>> declaredConstructorsBySignature;
    private final SetMultimap<Class<? extends Annotation>, WeldConstructor<T>> annotatedConstructors;
    private final Map<List<Class<?>>, WeldConstructor<T>> constructorsByArgumentMap;
    private final SetMultimap<Class<? extends Annotation>, WeldConstructor<?>> constructorsByAnnotatedParameters;
    private final String toString;
    private final boolean _nonStaticMemberClass;
    private final boolean _abstract;
    private final boolean _enum;

    public static <T> WeldClass<T> of(Class<T> clazz, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(clazz.getAnnotations(), clazz.getDeclaredAnnotations(), classTransformer.getTypeStore());
        return new WeldClassImpl<T>(clazz, clazz, null, annotationStore, classTransformer);
    }

    public static <T> WeldClass<T> of(AnnotatedType<T> annotatedType, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(annotatedType.getAnnotations(), annotatedType.getAnnotations(), classTransformer.getTypeStore());
        return new WeldClassImpl<T>(annotatedType.getJavaClass(), annotatedType.getBaseType(), annotatedType, annotationStore, classTransformer);
    }

    public static <T> WeldClass<T> of(Class<T> rawType, Type type, ClassTransformer classTransformer) {
        AnnotationStore annotationStore = AnnotationStore.of(rawType.getAnnotations(), rawType.getDeclaredAnnotations(), classTransformer.getTypeStore());
        return new WeldClassImpl<T>(rawType, type, null, annotationStore, classTransformer);
    }

    /*
     * WARNING - void declaration
     */
    protected WeldClassImpl(Class<T> rawType, Type type, AnnotatedType<T> annotatedType, AnnotationStore annotationStore, ClassTransformer classTransformer) {
        super(annotationStore, rawType, type);
        this.toString = "class " + Names.classToString(rawType);
        this.name = rawType.getName();
        this._simpleName = rawType.getSimpleName();
        this.superclass = rawType.getSuperclass() != null ? classTransformer.loadClass(rawType.getSuperclass()) : null;
        this._public = Modifier.isFinal(rawType.getModifiers());
        this._private = Modifier.isPrivate(rawType.getModifiers());
        this._packagePrivate = Reflections.isPackagePrivate(rawType.getModifiers());
        this._package = rawType.getPackage();
        this.fields = new HashSet();
        this.annotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WeldField<?, ?>>>(){

            @Override
            public Set<WeldField<?, ?>> get() {
                return new HashSet();
            }
        });
        this.metaAnnotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WeldField<?, ?>>>(){

            @Override
            public Set<WeldField<?, ?>> get() {
                return new HashSet();
            }
        });
        this.declaredFields = new HashSet();
        this.declaredFieldsByName = new HashMap();
        this.declaredAnnotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WeldField<?, T>>>(){

            @Override
            public Set<WeldField<?, T>> get() {
                return new HashSet();
            }
        });
        this.declaredMetaAnnotatedFields = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WeldField<?, ?>>>(){

            @Override
            public Set<WeldField<?, ?>> get() {
                return new HashSet();
            }
        });
        this._nonStaticMemberClass = Reflections.isNonStaticInnerClass(rawType);
        this._abstract = Reflections.isAbstract(rawType);
        this._enum = rawType.isEnum();
        HashMap<Field, AnnotatedField<T>> annotatedTypeFields = new HashMap<Field, AnnotatedField<T>>();
        if (annotatedType != null) {
            for (AnnotatedField<T> annotatedField : annotatedType.getFields()) {
                annotatedTypeFields.put(annotatedField.getJavaMember(), annotatedField);
            }
        }
        for (Class<T> c = rawType; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                WeldFieldImpl annotatedField = null;
                annotatedField = annotatedTypeFields.containsKey(field) ? WeldFieldImpl.of((AnnotatedField)annotatedTypeFields.get(field), this.getDeclaringWBClass(field, classTransformer), classTransformer) : WeldFieldImpl.of(field, this.getDeclaringWBClass(field, classTransformer), classTransformer);
                this.fields.add(annotatedField);
                if (c == rawType) {
                    this.declaredFields.add(annotatedField);
                    this.declaredFieldsByName.put(annotatedField.getName(), annotatedField);
                }
                for (Annotation annotation : annotatedField.getAnnotations()) {
                    this.annotatedFields.put(annotation.annotationType(), annotatedField);
                    if (c == rawType) {
                        this.declaredAnnotatedFields.put(annotation.annotationType(), annotatedField);
                    }
                    for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                        this.metaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                        if (c != rawType) continue;
                        this.declaredMetaAnnotatedFields.put(metaAnnotation.annotationType(), annotatedField);
                    }
                }
            }
        }
        this.constructors = new HashSet<WeldConstructor<T>>();
        this.constructorsByArgumentMap = new HashMap();
        this.annotatedConstructors = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WeldConstructor<T>>>(){

            @Override
            public Set<WeldConstructor<T>> get() {
                return new HashSet();
            }
        });
        this.constructorsByAnnotatedParameters = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WeldConstructor<?>>>(){

            @Override
            public Set<WeldConstructor<?>> get() {
                return new HashSet();
            }
        });
        HashMap<Constructor<T>, AnnotatedConstructor<T>> annotatedTypeConstructors = new HashMap<Constructor<T>, AnnotatedConstructor<T>>();
        if (annotatedType != null) {
            for (AnnotatedConstructor<T> annotated : annotatedType.getConstructors()) {
                annotatedTypeConstructors.put(annotated.getJavaMember(), annotated);
            }
        }
        this.declaredConstructorsBySignature = new HashMap();
        for (AccessibleObject accessibleObject : rawType.getDeclaredConstructors()) {
            WeldConstructor annotatedConstructor = null;
            if (annotatedTypeConstructors.containsKey(accessibleObject)) {
                WeldClass declaringClass = this.getDeclaringWBClass((Member)((Object)accessibleObject), classTransformer);
                annotatedConstructor = WeldConstructorImpl.of((AnnotatedConstructor)annotatedTypeConstructors.get(accessibleObject), declaringClass, classTransformer);
            } else {
                AccessibleObject c = accessibleObject;
                annotatedConstructor = WeldConstructorImpl.of(c, this.getDeclaringWBClass((Member)((Object)c), classTransformer), classTransformer);
            }
            if (!accessibleObject.isAccessible()) {
                ((Constructor)accessibleObject).setAccessible(true);
            }
            this.constructors.add(annotatedConstructor);
            this.constructorsByArgumentMap.put(Arrays.asList(((Constructor)accessibleObject).getParameterTypes()), annotatedConstructor);
            this.declaredConstructorsBySignature.put(annotatedConstructor.getSignature(), annotatedConstructor);
            for (Annotation annotation : annotatedConstructor.getAnnotations()) {
                if (!this.annotatedConstructors.containsKey(annotation.annotationType())) {
                    this.annotatedConstructors.putAll(annotation.annotationType(), new HashSet());
                }
                this.annotatedConstructors.get(annotation.annotationType()).add(annotatedConstructor);
            }
            for (Class clazz : WeldConstructor.MAPPED_PARAMETER_ANNOTATIONS) {
                if (annotatedConstructor.getAnnotatedWBParameters(clazz).size() <= 0) continue;
                this.constructorsByAnnotatedParameters.put(clazz, annotatedConstructor);
            }
        }
        this.methods = new HashSet();
        this.annotatedMethods = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WeldMethod<?, ?>>>(){

            @Override
            public Set<WeldMethod<?, ?>> get() {
                return new HashSet();
            }
        });
        this.methodsByAnnotatedParameters = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WeldMethod<?, ?>>>(){

            @Override
            public Set<WeldMethod<?, ?>> get() {
                return new HashSet();
            }
        });
        this.declaredMethods = new HashSet();
        this.declaredAnnotatedMethods = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WeldMethod<?, T>>>(){

            @Override
            public Set<WeldMethod<?, T>> get() {
                return new HashSet();
            }
        });
        this.declaredMethodsByAnnotatedParameters = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<WeldMethod<?, T>>>(){

            @Override
            public Set<WeldMethod<?, T>> get() {
                return new HashSet();
            }
        });
        this.declaredMethodsBySignature = new HashMap();
        this.methodsBySignature = new HashMap();
        HashMap<Method, AnnotatedMethod<T>> annotatedTypeMethods = new HashMap<Method, AnnotatedMethod<T>>();
        if (annotatedType != null) {
            for (AnnotatedMethod<T> annotated : annotatedType.getMethods()) {
                annotatedTypeMethods.put(annotated.getJavaMember(), annotated);
            }
        }
        for (Class<T> c = rawType; c != Object.class && c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                void var14_34;
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                Object var14_31 = null;
                if (annotatedTypeMethods.containsKey(method)) {
                    WeldMethodImpl weldMethodImpl = WeldMethodImpl.of((AnnotatedMethod)annotatedTypeMethods.get(method), this, classTransformer);
                } else {
                    WeldMethodImpl weldMethodImpl = WeldMethodImpl.of(method, this.getDeclaringWBClass(method, classTransformer), classTransformer);
                }
                this.methods.add((WeldMethod<?, ?>)var14_34);
                this.methodsBySignature.put(var14_34.getSignature(), (WeldMethod<?, ?>)var14_34);
                if (c == rawType) {
                    this.declaredMethods.add((WeldMethod<?, ?>)var14_34);
                    this.declaredMethodsBySignature.put(var14_34.getSignature(), (WeldMethod<?, ?>)var14_34);
                }
                for (Annotation annotation : var14_34.getAnnotations()) {
                    this.annotatedMethods.put((Class<Annotation>)annotation.annotationType(), (WeldMethod<?, ?>)var14_34);
                    if (c != rawType) continue;
                    this.declaredAnnotatedMethods.put((Class<Annotation>)annotation.annotationType(), (WeldMethod<?, T>)var14_34);
                }
                for (Class clazz : WeldMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                    if (var14_34.getAnnotatedWBParameters(clazz).size() <= 0) continue;
                    this.methodsByAnnotatedParameters.put((Class<Annotation>)((Class<? extends Annotation>)clazz), (WeldMethod<?, ?>)var14_34);
                    if (c != rawType) continue;
                    this.declaredMethodsByAnnotatedParameters.put((Class<Annotation>)((Class<? extends Annotation>)clazz), (WeldMethod<?, T>)var14_34);
                }
            }
        }
    }

    private <X> WeldClass<X> getDeclaringWBClass(Member member, ClassTransformer transformer) {
        if (member.getDeclaringClass().equals(this.getJavaClass())) {
            return this;
        }
        return transformer.loadClass(member.getDeclaringClass());
    }

    public Class<? extends T> getAnnotatedClass() {
        return this.getJavaClass();
    }

    @Override
    public Class<T> getDelegate() {
        return this.getJavaClass();
    }

    @Override
    public Set<WeldField<?, ?>> getWeldFields() {
        return Collections.unmodifiableSet(this.fields);
    }

    public Set<WeldField<?, ?>> getDeclaredFields() {
        return Collections.unmodifiableSet(this.declaredFields);
    }

    @Override
    public <F> WeldField<F, ?> getDeclaredWeldField(String fieldName, WeldClass<F> expectedType) {
        return this.declaredFieldsByName.get(fieldName);
    }

    @Override
    public Set<WeldField<?, T>> getDeclaredAnnotatedWeldFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredAnnotatedFields.get(annotationType));
    }

    @Override
    public Set<WeldConstructor<T>> getWeldConstructors() {
        return Collections.unmodifiableSet(this.constructors);
    }

    @Override
    public WeldConstructor<T> getDeclaredWeldConstructor(ConstructorSignature signature) {
        return this.declaredConstructorsBySignature.get(signature);
    }

    @Override
    public Set<WeldField<?, ?>> getMetaAnnotatedWeldFields(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(this.metaAnnotatedFields.get(metaAnnotationType));
    }

    @Override
    public Set<WeldField<?, ?>> getAnnotatedWeldFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedFields.get(annotationType));
    }

    @Override
    public boolean isNonStaticMemberClass() {
        return this._nonStaticMemberClass;
    }

    @Override
    public boolean isAbstract() {
        return this._abstract;
    }

    @Override
    public boolean isEnum() {
        return this._enum;
    }

    @Override
    public Set<WeldMethod<?, ?>> getAnnotatedWeldMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedMethods.get(annotationType));
    }

    @Override
    public Set<WeldMethod<?, T>> getDeclaredAnnotatedWeldMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredAnnotatedMethods.get(annotationType));
    }

    @Override
    public Set<WeldConstructor<T>> getAnnotatedWeldConstructors(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedConstructors.get(annotationType));
    }

    @Override
    public WeldConstructor<T> getNoArgsWeldConstructor() {
        return this.constructorsByArgumentMap.get(NO_ARGUMENTS);
    }

    @Override
    public Set<WeldMethod<?, ?>> getWeldMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.methodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public Set<WeldConstructor<?>> getWeldConstructorsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.constructorsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public Set<WeldMethod<?, T>> getDeclaredWeldMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.declaredMethodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public WeldMethod<?, ?> getWeldMethod(Method methodDescriptor) {
        for (WeldMethod<?, ?> annotatedMethod : this.methods) {
            if (!annotatedMethod.getName().equals(methodDescriptor.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), methodDescriptor.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Set<WeldMethod<?, ?>> getWeldMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    @Override
    public WeldMethod<?, ?> getDeclaredWeldMethod(Method method) {
        for (WeldMethod<?, ?> annotatedMethod : this.declaredMethods) {
            if (!annotatedMethod.getName().equals(method.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), method.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Set<WeldMethod<?, ?>> getDeclaredWeldMethods() {
        return this.declaredMethods;
    }

    @Override
    public <M> WeldMethod<M, ?> getDeclaredWeldMethod(MethodSignature signature, WeldClass<M> expectedReturnType) {
        return this.declaredMethodsBySignature.get(signature);
    }

    @Override
    public <M> WeldMethod<M, ?> getWBMethod(MethodSignature signature) {
        return this.methodsBySignature.get(signature);
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Override
    public String getSimpleName() {
        return this._simpleName;
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic(this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal(this.getDelegate());
    }

    @Override
    public boolean isPublic() {
        return this._public;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WeldClass<?> getWeldSuperclass() {
        return this.superclass;
    }

    @Override
    public boolean isEquivalent(Class<?> clazz) {
        return this.getDelegate().equals(clazz);
    }

    @Override
    public boolean isPrivate() {
        return this._private;
    }

    @Override
    public boolean isPackagePrivate() {
        return this._packagePrivate;
    }

    @Override
    public Package getPackage() {
        return this._package;
    }

    @Override
    public <U> WeldClass<? extends U> asWeldSubclass(WeldClass<U> clazz) {
        return this;
    }

    @Override
    public <S> S cast(Object object) {
        return (S)object;
    }

    @Override
    public Set<AnnotatedConstructor<T>> getConstructors() {
        return this.constructors;
    }

    @Override
    public Set<AnnotatedField<? super T>> getFields() {
        return this.fields;
    }

    @Override
    public Set<AnnotatedMethod<? super T>> getMethods() {
        return this.methods;
    }
}

