/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.New;
import org.jboss.weld.literal.NewLiteral;
import org.jboss.weld.resolution.ForwardingResolvable;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableTransformer;
import org.jboss.weld.util.Reflections;

public class NewResolvableTransformer
implements ResolvableTransformer {
    public Resolvable transform(final Resolvable element) {
        if (element.isAnnotationPresent(New.class) && element.getJavaClass() != null) {
            New originalNewAnnotation = element.getAnnotation(New.class);
            if (originalNewAnnotation.value().equals(New.class)) {
                final HashSet<Annotation> bindings = new HashSet<Annotation>(element.getQualifiers());
                final NewLiteral newNewAnnotation = new NewLiteral(){

                    @Override
                    public Class<?> value() {
                        return element.getJavaClass();
                    }
                };
                bindings.remove(originalNewAnnotation);
                bindings.add(newNewAnnotation);
                return new ForwardingResolvable(){

                    @Override
                    protected Resolvable delegate() {
                        return element;
                    }

                    @Override
                    public Set<Annotation> getQualifiers() {
                        return bindings;
                    }

                    @Override
                    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                        if (annotationType.equals(New.class)) {
                            return (A)((Annotation)annotationType.cast(newNewAnnotation));
                        }
                        return this.delegate().getAnnotation(annotationType);
                    }
                };
            }
            final Class<?> javaClass = originalNewAnnotation.value();
            final Set<Type> typeClosure = new Reflections.HierarchyDiscovery(javaClass).getTypeClosureAsSet();
            return new ForwardingResolvable(){

                @Override
                protected Resolvable delegate() {
                    return element;
                }

                @Override
                public Class<?> getJavaClass() {
                    return javaClass;
                }

                @Override
                public Set<Type> getTypeClosure() {
                    return typeClosure;
                }
            };
        }
        return element;
    }
}

