/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.registry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.interceptor.model.InterceptorClassMetadata;
import org.jboss.interceptor.model.InterceptorClassMetadataImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorClassMetadataRegistry {
    private static InterceptorClassMetadataRegistry interceptorMetadataRegistry = new InterceptorClassMetadataRegistry();
    private final Map<Key, InterceptorClassMetadata> interceptorClassMetadataMap = new ConcurrentHashMap<Key, InterceptorClassMetadata>();
    private final Lock lock = new ReentrantLock();

    public static InterceptorClassMetadataRegistry getRegistry() {
        return interceptorMetadataRegistry;
    }

    public InterceptorClassMetadata getInterceptorClassMetadata(Class<?> interceptorClass) {
        return this.getInterceptorClassMetadata(interceptorClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterceptorClassMetadata getInterceptorClassMetadata(Class<?> interceptorClass, boolean isInterceptorTargetClass) {
        Key key = new Key(interceptorClass, isInterceptorTargetClass);
        if (!this.interceptorClassMetadataMap.containsKey(key)) {
            try {
                this.lock.lock();
                if (!this.interceptorClassMetadataMap.containsKey(key)) {
                    this.interceptorClassMetadataMap.put(key, new InterceptorClassMetadataImpl(interceptorClass, isInterceptorTargetClass));
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.interceptorClassMetadataMap.get(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key {
        private Class<?> clazz;
        private boolean isInterceptorTargetClass;

        private Key(Class<?> clazz, boolean interceptorTargetClass) {
            this.clazz = clazz;
            this.isInterceptorTargetClass = interceptorTargetClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.isInterceptorTargetClass != key.isInterceptorTargetClass) {
                return false;
            }
            return !(this.clazz != null ? !this.clazz.equals(key.clazz) : key.clazz != null);
        }

        public int hashCode() {
            int result = this.clazz != null ? this.clazz.hashCode() : 0;
            result = 31 * result + (this.isInterceptorTargetClass ? 1 : 0);
            return result;
        }
    }
}

