/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.interceptor;

import java.lang.reflect.Constructor;
import javax.enterprise.context.spi.CreationalContext;
import org.jboss.interceptor.proxy.DirectClassInterceptionHandler;
import org.jboss.interceptor.proxy.InterceptionHandler;
import org.jboss.interceptor.proxy.InterceptionHandlerFactory;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInterceptionHandlerFactory<T>
implements InterceptionHandlerFactory<Class<T>> {
    private final CreationalContext<T> creationalContext;
    private BeanManagerImpl manager;

    public ClassInterceptionHandlerFactory(CreationalContext<T> creationalContext, BeanManagerImpl manager) {
        this.creationalContext = creationalContext;
        this.manager = manager;
    }

    @Override
    public InterceptionHandler createFor(Class<T> clazz) {
        try {
            Constructor<?> constructor = SecureReflections.getDeclaredConstructor(clazz, new Class[0]);
            Object interceptorInstance = SecureReflections.ensureAccessible(constructor).newInstance(new Object[0]);
            this.manager.createInjectionTarget(this.manager.createAnnotatedType(clazz)).inject(interceptorInstance, this.creationalContext);
            return new DirectClassInterceptionHandler(interceptorInstance, clazz);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }
}

