/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalProductException;
import org.jboss.weld.exceptions.InconsistentSpecializationException;
import org.jboss.weld.exceptions.NullableDependencyException;
import org.jboss.weld.exceptions.UnproxyableResolutionException;
import org.jboss.weld.exceptions.UnserializableDependencyException;
import org.jboss.weld.introspector.WeldAnnotated;
import org.jboss.weld.logging.messages.ValidatorMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.ResolvableWeldClass;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
implements Service {
    private void validateBean(Bean<?> bean, BeanManagerImpl beanManager) {
        for (InjectionPoint ij : bean.getInjectionPoints()) {
            this.validateInjectionPoint(ij, beanManager);
        }
        boolean normalScoped = beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(bean.getScope()).isNormal();
        if (normalScoped && !Beans.isBeanProxyable(bean)) {
            throw new UnproxyableResolutionException(ValidatorMessage.NOT_PROXYABLE, bean);
        }
    }

    private void validateRIBean(RIBean<?> bean, BeanManagerImpl beanManager, Collection<RIBean<?>> specializedBeans) {
        this.validateBean(bean, beanManager);
        if (!(bean instanceof NewManagedBean) && !(bean instanceof NewSessionBean)) {
            RIBean<?> abstractBean = bean;
            if (abstractBean.isSpecializing()) {
                if (specializedBeans.contains(abstractBean.getSpecializedBean())) {
                    throw new InconsistentSpecializationException(ValidatorMessage.BEAN_SPECIALIZED_TOO_MANY_TIMES, bean);
                }
                specializedBeans.add(abstractBean.getSpecializedBean());
            }
            if (bean instanceof AbstractClassBean && bean.isPassivationCapableBean()) {
                AbstractClassBean classBean = (AbstractClassBean)bean;
                if (classBean.hasDecorators()) {
                    this.validateDecorators(beanManager, classBean);
                }
                if (classBean.hasCdiBoundInterceptors()) {
                    this.validateCdiBoundInterceptors(beanManager, classBean);
                }
                if (((AbstractClassBean)bean).hasDirectlyDefinedInterceptors()) {
                    this.validateDirectlyDefinedInterceptorClasses(beanManager, classBean);
                }
            }
        }
    }

    private void validateDirectlyDefinedInterceptorClasses(BeanManagerImpl beanManager, AbstractClassBean<?> classBean) {
        Class[] classDeclaredInterceptors;
        InterceptionModel ejbInterceptorModel = beanManager.getClassDeclaredInterceptorsRegistry().getInterceptionModel(classBean.getType());
        if (ejbInterceptorModel != null && (classDeclaredInterceptors = ejbInterceptorModel.getAllInterceptors().toArray(new Class[ejbInterceptorModel.getAllInterceptors().size()])) != null) {
            for (Class interceptorClass : classDeclaredInterceptors) {
                if (!Reflections.isSerializable(interceptorClass)) {
                    throw new DeploymentException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_INTERCEPTOR, this, interceptorClass.getName());
                }
                InjectionTarget injectionTarget = beanManager.createInjectionTarget(beanManager.createAnnotatedType(interceptorClass));
                for (InjectionPoint injectionPoint : injectionTarget.getInjectionPoints()) {
                    Bean resolvedBean = beanManager.resolve(beanManager.getInjectableBeans(injectionPoint));
                    this.validateInjectionPointPassivationCapable(injectionPoint, resolvedBean, beanManager);
                }
            }
        }
    }

    private void validateCdiBoundInterceptors(BeanManagerImpl beanManager, AbstractClassBean<?> classBean) {
        Set<SerializableContextual<Interceptor<?>, ?>> interceptors;
        InterceptionModel cdiInterceptorModel = beanManager.getCdiInterceptorsRegistry().getInterceptionModel(classBean.getType());
        if (cdiInterceptorModel != null && (interceptors = cdiInterceptorModel.getAllInterceptors()).size() > 0) {
            for (SerializableContextual serializableContextual : interceptors) {
                if (!((InterceptorImpl)serializableContextual.get()).isSerializable()) {
                    throw new DeploymentException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_INTERCEPTOR, classBean, serializableContextual.get());
                }
                for (InjectionPoint injectionPoint : ((Interceptor)serializableContextual.get()).getInjectionPoints()) {
                    Bean resolvedBean = beanManager.resolve(beanManager.getInjectableBeans(injectionPoint));
                    this.validateInjectionPointPassivationCapable(injectionPoint, resolvedBean, beanManager);
                }
            }
        }
    }

    private void validateDecorators(BeanManagerImpl beanManager, AbstractClassBean<?> classBean) {
        for (Decorator<?> decorator : classBean.getDecorators()) {
            if (!((WeldDecorator)decorator).getWeldAnnotated().isSerializable()) {
                throw new UnserializableDependencyException(ValidatorMessage.PASSIVATING_BEAN_WITH_NONSERIALIZABLE_DECORATOR, classBean, decorator);
            }
            for (InjectionPoint ij : decorator.getInjectionPoints()) {
                Bean resolvedBean = beanManager.resolve(beanManager.getInjectableBeans(ij));
                this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
            }
        }
    }

    public void validateInjectionPoint(InjectionPoint ij, BeanManagerImpl beanManager) {
        if (ij.getAnnotated().getAnnotation(New.class) != null && ij.getQualifiers().size() > 1) {
            throw new DefinitionException(ValidatorMessage.NEW_WITH_QUALIFIERS, ij);
        }
        if (ij.getType().equals(InjectionPoint.class) && ij.getBean() == null) {
            throw new DefinitionException(ValidatorMessage.INJECTION_INTO_NON_BEAN, ij);
        }
        if (ij.getType().equals(InjectionPoint.class) && !Dependent.class.equals(ij.getBean().getScope())) {
            throw new DefinitionException(ValidatorMessage.INJECTION_INTO_NON_DEPENDENT_BEAN, ij);
        }
        if (ij.getType() instanceof TypeVariable) {
            throw new DefinitionException(ValidatorMessage.INJECTION_POINT_WITH_TYPE_VARIABLE, ij);
        }
        Validator.checkFacadeInjectionPoint(ij, Instance.class);
        Validator.checkFacadeInjectionPoint(ij, Event.class);
        Object[] bindings = ij.getQualifiers().toArray(new Annotation[0]);
        WeldAnnotated annotatedItem = ResolvableWeldClass.of(ij.getType(), (Annotation[])bindings, beanManager);
        Set resolvedBeans = beanManager.getBeanResolver().resolve(beanManager.getInjectableBeans(ij));
        if (resolvedBeans.isEmpty()) {
            throw new DeploymentException(ValidatorMessage.INJECTION_POINT_HAS_UNSATISFIED_DEPENDENCIES, ij, Arrays.toString(bindings));
        }
        if (resolvedBeans.size() > 1 && !ij.isDelegate()) {
            throw new DeploymentException(ValidatorMessage.INJECTION_POINT_HAS_AMBIGUOUS_DEPENDENCIES, ij, Arrays.toString(bindings) + "; Possible dependencies: " + resolvedBeans);
        }
        Bean resolvedBean = resolvedBeans.iterator().next();
        if (beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(resolvedBean.getScope()).isNormal() && !Proxies.isTypeProxyable(ij.getType())) {
            throw new UnproxyableResolutionException(ValidatorMessage.INJECTION_POINT_HAS_NON_PROXYABLE_DEPENDENCIES, ij);
        }
        if (annotatedItem.isPrimitive() && resolvedBean.isNullable()) {
            throw new NullableDependencyException(ValidatorMessage.INJECTION_POINT_HAS_NULLABLE_DEPENDENCIES, ij);
        }
        if (ij.getBean() != null && Beans.isPassivatingScope(ij.getBean(), beanManager) && !ij.isTransient() && !Beans.isPassivationCapableBean(resolvedBean)) {
            this.validateInjectionPointPassivationCapable(ij, resolvedBean, beanManager);
        }
    }

    public void validateInjectionPointPassivationCapable(InjectionPoint ij, Bean<?> resolvedBean, BeanManagerImpl beanManager) {
        if (!ij.isTransient() && !Beans.isPassivationCapableDependency(resolvedBean)) {
            if (resolvedBean.getScope().equals(Dependent.class) && resolvedBean instanceof AbstractProducerBean) {
                throw new IllegalProductException(ValidatorMessage.NON_SERIALIZABLE_BEAN_INJECTED_INTO_PASSIVATING_BEAN, ij.getBean(), resolvedBean);
            }
            throw new UnserializableDependencyException(ValidatorMessage.INJECTION_POINT_HAS_NON_SERIALIZABLE_DEPENDENCY, ij.getBean(), resolvedBean);
        }
    }

    public void validateDeployment(BeanManagerImpl manager, BeanDeployerEnvironment environment) {
        this.validateBeans(manager.getDecorators(), new ArrayList(), manager);
        this.validateBeans(manager.getBeans(), new ArrayList(), manager);
        this.validateEnabledDecoratorClasses(manager);
        this.validateEnabledInterceptorClasses(manager);
        this.validateEnabledAlternatives(manager);
        this.validateDisposalMethods(environment);
        this.validateBeanNames(manager);
    }

    public void validateBeans(Collection<? extends Bean<?>> beans, Collection<RIBean<?>> specializedBeans, BeanManagerImpl manager) {
        for (Bean<?> bean : beans) {
            if (bean instanceof RIBean) {
                this.validateRIBean((RIBean)bean, manager, specializedBeans);
                continue;
            }
            this.validateBean(bean, manager);
        }
    }

    public void validateBeanNames(BeanManagerImpl beanManager) {
        SetMultimap<String, Bean<?>> namedAccessibleBeans = Multimaps.newSetMultimap(new HashMap(), new Supplier<Set<Bean<?>>>(){

            @Override
            public Set<Bean<?>> get() {
                return new HashSet();
            }
        });
        for (Bean<?> bean : beanManager.getAccessibleBeans()) {
            if (bean.getName() == null) continue;
            namedAccessibleBeans.put(bean.getName(), bean);
        }
        ArrayList<String> accessibleNamespaces = new ArrayList<String>();
        for (String namespace : beanManager.getAccessibleNamespaces()) {
            accessibleNamespaces.add(namespace);
        }
        for (String name : namedAccessibleBeans.keySet()) {
            Set resolvedBeans = beanManager.getBeanResolver().resolve(Beans.removeDisabledAndSpecializedBeans(namedAccessibleBeans.get(name), beanManager.getEnabledAlternativeClasses(), beanManager.getEnabledAlternativeStereotypes(), beanManager.getSpecializedBeans()));
            if (resolvedBeans.size() > 1) {
                throw new DeploymentException(ValidatorMessage.AMBIGUOUS_EL_NAME, name, resolvedBeans);
            }
            if (!accessibleNamespaces.contains(name)) continue;
            throw new DeploymentException(ValidatorMessage.BEAN_NAME_IS_PREFIX, name);
        }
    }

    private void validateEnabledInterceptorClasses(BeanManagerImpl beanManager) {
        HashSet interceptorBeanClasses = new HashSet();
        for (Interceptor<?> interceptor : beanManager.getInterceptors()) {
            interceptorBeanClasses.add(interceptor.getBeanClass());
        }
        for (Class clazz : beanManager.getEnabledInterceptorClasses()) {
            if (beanManager.getEnabledInterceptorClasses().indexOf(clazz) < beanManager.getEnabledInterceptorClasses().lastIndexOf(clazz)) {
                throw new DeploymentException(ValidatorMessage.INTERCEPTOR_SPECIFIED_TWICE, clazz + " specified twice");
            }
            if (interceptorBeanClasses.contains(clazz)) continue;
            throw new DeploymentException(ValidatorMessage.INTERCEPTOR_NOT_ANNOTATED_OR_REGISTERED, clazz);
        }
    }

    private void validateEnabledDecoratorClasses(BeanManagerImpl beanManager) {
        HashSet decoratorBeanClasses = new HashSet();
        for (Decorator<?> decorator : beanManager.getDecorators()) {
            decoratorBeanClasses.add(decorator.getBeanClass());
        }
        for (Class clazz : beanManager.getEnabledDecoratorClasses()) {
            if (beanManager.getEnabledDecoratorClasses().indexOf(clazz) < beanManager.getEnabledDecoratorClasses().lastIndexOf(clazz)) {
                throw new DeploymentException(ValidatorMessage.DECORATOR_SPECIFIED_TWICE, clazz);
            }
            if (decoratorBeanClasses.contains(clazz)) continue;
            throw new DeploymentException(ValidatorMessage.DECORATOR_CLASS_NOT_BEAN_CLASS_OF_DECORATOR, clazz, decoratorBeanClasses);
        }
    }

    private void validateEnabledAlternatives(BeanManagerImpl beanManager) {
        ArrayList<Class<? extends Annotation>> seenAlternatives = new ArrayList<Class<? extends Annotation>>();
        for (Class<? extends Annotation> clazz : beanManager.getEnabledAlternativeStereotypes()) {
            if (!clazz.isAnnotationPresent(Alternative.class)) {
                throw new DeploymentException(ValidatorMessage.ALTERNATIVE_STEREOTYPE_NOT_ANNOTATED, clazz);
            }
            if (seenAlternatives.contains(clazz)) {
                throw new DeploymentException(ValidatorMessage.ALTERNATIVE_STEREOTYPE_SPECIFIED_MULTIPLE_TIMES, clazz);
            }
            seenAlternatives.add(clazz);
        }
        for (Class<Annotation> clazz : beanManager.getEnabledAlternativeClasses()) {
            if (!clazz.isAnnotationPresent(Alternative.class)) {
                throw new DeploymentException(ValidatorMessage.ALTERNATIVE_BEAN_CLASS_NOT_ANNOTATED, clazz);
            }
            if (seenAlternatives.contains(clazz)) {
                throw new DeploymentException(ValidatorMessage.ALTERNATIVE_BEAN_CLASS_SPECIFIED_MULTIPLE_TIMES, clazz);
            }
            seenAlternatives.add(clazz);
        }
    }

    private void validateDisposalMethods(BeanDeployerEnvironment environment) {
        Set<DisposalMethod<?, ?>> beans = environment.getUnresolvedDisposalBeans();
        if (!beans.isEmpty()) {
            throw new DefinitionException(ValidatorMessage.DISPOSAL_METHODS_WITHOUT_PRODUCER, beans);
        }
    }

    private static void checkFacadeInjectionPoint(InjectionPoint injectionPoint, Class<?> type) {
        if (injectionPoint.getAnnotated().getBaseType().equals(type)) {
            if (injectionPoint.getType() instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)injectionPoint.getType();
                if (parameterizedType.getActualTypeArguments()[0] instanceof TypeVariable) {
                    throw new DefinitionException(ValidatorMessage.INJECTION_POINT_WITH_TYPE_VARIABLE, injectionPoint);
                }
                if (parameterizedType.getActualTypeArguments()[0] instanceof WildcardType) {
                    throw new DefinitionException(ValidatorMessage.INJECTION_POINT_HAS_WILDCARD, type, injectionPoint);
                }
            } else {
                throw new DefinitionException(ValidatorMessage.INJECTION_POINT_MUST_HAVE_TYPE_PARAMETER, type, injectionPoint);
            }
        }
    }

    @Override
    public void cleanup() {
    }
}

