/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.inject.Inject;
import org.jboss.interceptor.util.InterceptionUtils;
import org.jboss.weld.exceptions.ForbiddenStateException;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.ForwardingWeldField;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.manager.BeanManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInjectionPoint<T, X>
extends ForwardingWeldField<T, X>
implements WeldInjectionPoint<T, Field>,
Serializable {
    private final Bean<?> declaringBean;
    private final WeldField<T, X> field;
    private final boolean delegate;

    public static <T, X> FieldInjectionPoint<T, X> of(Bean<?> declaringBean, WeldField<T, X> field) {
        return new FieldInjectionPoint<T, X>(declaringBean, field);
    }

    protected FieldInjectionPoint(Bean<?> declaringBean, WeldField<T, X> field) {
        this.declaringBean = declaringBean;
        this.field = field;
        this.delegate = this.isAnnotationPresent(Inject.class) && this.isAnnotationPresent(Delegate.class) && declaringBean instanceof Decorator;
    }

    @Override
    protected WeldField<T, X> delegate() {
        return this.field;
    }

    @Override
    public Bean<?> getBean() {
        return this.declaringBean;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.delegate().getQualifiers();
    }

    public void inject(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        try {
            Object instanceToInject = declaringInstance;
            if (!this.isDelegate()) {
                instanceToInject = InterceptionUtils.getRawInstance(declaringInstance);
            }
            this.delegate().set(instanceToInject, manager.getInjectableReference(this, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        try {
            Object instanceToInject = declaringInstance;
            if (!this.isDelegate()) {
                instanceToInject = InterceptionUtils.getRawInstance(declaringInstance);
            }
            this.delegate().set(instanceToInject, value);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    public Annotated getAnnotated() {
        return this.delegate();
    }

    @Override
    public boolean isDelegate() {
        return this.delegate;
    }

    @Override
    public Type getType() {
        return this.getBaseType();
    }

    @Override
    public Member getMember() {
        return this.getJavaMember();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy<T>
    extends WeldInjectionPoint.WeldInjectionPointSerializationProxy<T, Field> {
        private static final long serialVersionUID = -3491482804822264969L;
        private final String fieldName;

        public SerializationProxy(FieldInjectionPoint<T, ?> injectionPoint) {
            super(injectionPoint);
            this.fieldName = injectionPoint.getName();
        }

        private Object readResolve() {
            WeldField<T, ?> field = this.getWeldField();
            Bean bean = this.getDeclaringBean();
            if (field == null || bean == null) {
                throw new ForbiddenStateException(ReflectionMessage.UNABLE_TO_GET_FIELD_ON_DESERIALIZATION, this.getDeclaringBeanId(), this.getDeclaringWeldClass(), this.fieldName);
            }
            return FieldInjectionPoint.of(this.getDeclaringBean(), this.getWeldField());
        }

        protected WeldField<T, ?> getWeldField() {
            return this.getDeclaringWeldClass().getDeclaredWeldField(this.fieldName);
        }
    }
}

