/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.jsf;

import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.jboss.weld.Container;
import org.jboss.weld.context.ContextLifecycle;
import org.jboss.weld.context.ConversationContext;
import org.jboss.weld.context.SessionContext;
import org.jboss.weld.jsf.JsfHelper;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.JsfMessage;
import org.jboss.weld.servlet.BeanProvider;
import org.jboss.weld.servlet.ConversationBeanStore;
import org.slf4j.cal10n.LocLogger;

public class WeldPhaseListener
implements PhaseListener {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.JSF);

    public void beforePhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RESTORE_VIEW)) {
            this.beforeRestoreView(phaseEvent.getFacesContext());
        }
    }

    public void afterPhase(PhaseEvent phaseEvent) {
        if (phaseEvent.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            this.afterRenderResponse(phaseEvent.getFacesContext());
        } else if (phaseEvent.getFacesContext().getResponseComplete()) {
            this.afterResponseComplete(phaseEvent.getFacesContext(), phaseEvent.getPhaseId());
        }
    }

    private void beforeRestoreView(FacesContext facesContext) {
        log.trace(JsfMessage.INITIATING_CONVERSATION, "Restore View");
        this.initiateSessionAndConversation(facesContext);
    }

    private void afterRenderResponse(FacesContext facesContext) {
        SessionContext sessionContext = Container.instance().services().get(ContextLifecycle.class).getSessionContext();
        ConversationContext conversationContext = Container.instance().services().get(ContextLifecycle.class).getConversationContext();
        if (sessionContext.isActive()) {
            log.trace(JsfMessage.CLEANING_UP_CONVERSATION, "Render Response", "response complete");
            BeanProvider.conversationManager(JsfHelper.getServletContext(facesContext)).cleanupConversation();
            conversationContext.setActive(false);
        } else {
            log.trace(JsfMessage.SKIPPING_CLEANING_UP_CONVERSATION, "Render Response", "session has been terminated");
        }
    }

    private void afterResponseComplete(FacesContext facesContext, PhaseId phaseId) {
        SessionContext sessionContext = Container.instance().services().get(ContextLifecycle.class).getSessionContext();
        if (sessionContext.isActive()) {
            log.trace(JsfMessage.CLEANING_UP_CONVERSATION, phaseId, "the response has been marked complete");
            BeanProvider.conversationManager(JsfHelper.getServletContext(facesContext)).cleanupConversation();
        } else {
            log.trace(JsfMessage.SKIPPING_CLEANING_UP_CONVERSATION, phaseId, "session has been terminated");
        }
    }

    private void initiateSessionAndConversation(FacesContext facesContext) {
        ServletContext servletContext = JsfHelper.getServletContext(facesContext);
        HttpSession session = JsfHelper.getHttpSession(facesContext);
        BeanProvider.httpSessionManager(servletContext).setSession(session);
        BeanProvider.conversationManager(servletContext).beginOrRestoreConversation(JsfHelper.getConversationId(facesContext));
        String cid = BeanProvider.conversation(servletContext).getUnderlyingId();
        ConversationContext conversationContext = Container.instance().services().get(ContextLifecycle.class).getConversationContext();
        conversationContext.setBeanStore(new ConversationBeanStore(session, cid));
        conversationContext.setActive(true);
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

