/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.model.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.model.InterceptionTypeRegistry;
import org.jboss.interceptor.model.InterceptorMetadata;
import org.jboss.interceptor.model.InterceptorMetadataException;
import org.jboss.interceptor.model.MethodHolder;
import org.jboss.interceptor.model.metadata.ClassReference;
import org.jboss.interceptor.model.metadata.MethodReference;
import org.jboss.interceptor.util.InterceptionUtils;
import org.jboss.interceptor.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterceptorMetadata
implements InterceptorMetadata,
Serializable {
    private Logger log = LoggerFactory.getLogger(AbstractInterceptorMetadata.class);
    private ClassReference interceptorClass;
    private Map<InterceptionType, List<MethodReference>> methodMap;
    private boolean targetClass;

    protected AbstractInterceptorMetadata(ClassReference interceptorClass, boolean targetClass) {
        this.interceptorClass = interceptorClass;
        this.methodMap = this.buildMethodMap(interceptorClass, targetClass);
        this.targetClass = targetClass;
    }

    private Map<InterceptionType, List<MethodReference>> buildMethodMap(ClassReference interceptorClass, boolean isTargetClass) {
        HashMap<InterceptionType, List<MethodReference>> methodMap = new HashMap<InterceptionType, List<MethodReference>>();
        ClassReference currentClass = interceptorClass;
        HashSet<MethodHolder> foundMethods = new HashSet<MethodHolder>();
        do {
            HashSet<InterceptionType> detectedInterceptorTypes = new HashSet<InterceptionType>();
            for (MethodReference method : currentClass.getDeclaredMethods()) {
                for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
                    if (!InterceptionUtils.isInterceptorMethod(interceptionType, method, isTargetClass)) continue;
                    if (methodMap.get((Object)interceptionType) == null) {
                        methodMap.put(interceptionType, new LinkedList());
                    }
                    if (detectedInterceptorTypes.contains((Object)interceptionType)) {
                        throw new InterceptorMetadataException("Same interception type cannot be specified twice on the same class");
                    }
                    detectedInterceptorTypes.add(interceptionType);
                    ReflectionUtils.ensureAccessible(method.getJavaMethod());
                    if (foundMethods.contains(MethodHolder.of(method, false))) continue;
                    ((List)methodMap.get((Object)interceptionType)).add(0, method);
                }
                foundMethods.add(MethodHolder.of(method, false));
            }
        } while (!Object.class.equals((currentClass = currentClass.getSuperclass()).getJavaClass()));
        return methodMap;
    }

    @Override
    public ClassReference getInterceptorClass() {
        return this.interceptorClass;
    }

    @Override
    public List<MethodReference> getInterceptorMethods(InterceptionType interceptionType) {
        if (this.methodMap != null) {
            List<MethodReference> methods = this.methodMap.get((Object)interceptionType);
            return methods == null ? Collections.emptyList() : methods;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isInterceptor() {
        return !this.methodMap.keySet().isEmpty();
    }

    private Object writeReplace() {
        return this.createSerializableProxy();
    }

    protected abstract Object createSerializableProxy();

    @Override
    public boolean isTargetClass() {
        return this.targetClass;
    }
}

